/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drwebn.server.tasks;

import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.bean.PeriodicErrorManager;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.drweb.common.bean.TariffAVD;
import ru.bitel.bgbilling.modules.drweb.server.bean.TariffAVDManager;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgent;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgentStatusBase;
import ru.bitel.bgbilling.modules.drwebn.server.bean.DrwebAgentDAO;
import ru.bitel.bgbilling.modules.drwebn.server.tariff.DrWebNTariffContext;
import ru.bitel.bgbilling.modules.drwebn.server.tariff.DrWebNTariffRequest;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public abstract class CalculatorBase
extends TaskBase {
    protected Calendar startMonth;
    protected Calendar endMonth;
    protected String cids;
    protected int daysInMonth;
    protected PeriodicErrorManager errorManager;
    protected DrwebAgentDAO manager;
    protected TariffAVDManager tm;
    protected DrWebNTariffContext context;
    protected ServiceCostCache costCache;
    protected boolean calcErrors = false;
    protected boolean preCalcMode = false;
    protected TariffModuleTreeSetDao tariffModuleTreeSetDao;
    protected int cnt = 0;
    private int graceperiodCount = 1;
    private int graceperiodUnit = 0;

    protected boolean initTask() {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        if (moduleSetup != null) {
            this.graceperiodCount = moduleSetup.getInt("graceperiod.count", 1);
            String val = moduleSetup.get("graceperiod.unit", "month").toLowerCase();
            if (val.equals("month")) {
                this.graceperiodUnit = 0;
            } else if (val.equals("day")) {
                this.graceperiodUnit = 1;
            }
        }
        this.initDate(-1);
        return true;
    }

    protected void initDate(int delta) {
        this.startMonth = (Calendar)this.getOperatingTime().clone();
        this.startMonth.add(11, delta);
        this.startMonth.set(5, 1);
        this.startMonth.set(11, 0);
        this.endMonth = TimeUtils.getEndMonth((Calendar)this.startMonth);
        this.daysInMonth = this.startMonth.getActualMaximum(5);
    }

    public void setPreCalc() {
        this.preCalcMode = true;
    }

    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            this.manager = new DrwebAgentDAO(con, this.moduleId);
            this.tm = new TariffAVDManager(con, this.moduleId);
            this.tariffModuleTreeSetDao = new TariffModuleTreeSetDao(con);
            this.errorManager = new PeriodicErrorManager(con);
            this.errorManager.initErrorMessage(this.moduleId, "drweb", String.valueOf(this.moduleId), this.startMonth.getTime());
            this.execute(con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.startMonth.getTime());
                this.errorManager.processErrors();
            }
            catch (Exception exception) {}
            ServerUtils.closeConnection((Connection)con);
        }
    }

    protected abstract void execute(Connection var1) throws BGException, SQLException;

    protected void processStatus(DrwebAgent agent, DrwebAgentStatusBase agentStatus) throws SQLException, BGException {
        TariffAVD tariffAVD;
        int contractId = agent.getCid();
        Calendar statusStart = null;
        Calendar statusEnd = null;
        this.getLogger().debug("processStatus...");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Service period: " + TimeUtils.formatPeriod(statusStart, statusEnd));
        }
        if ((tariffAVD = (TariffAVD)this.tm.get(agentStatus.getTariffId())) == null) {
            this.getLogger().error("Not find drweb tariff => " + agentStatus.getTariffId() + " for agent => " + agent.getId());
            return;
        }
        int sid = -1;
        sid = this.isNewAgent(agent.getDateFrom(), new Date()) && tariffAVD.getSidForNew() != -1 ? tariffAVD.getSidForNew() : tariffAVD.getSid();
        TariffModuleTreeSet tariffTreeSet = this.tariffModuleTreeSetDao.getRealtimeTariffTreeSet(contractId, this.startMonth.getTime(), "drwebn", this.moduleId, 0, 0);
        boolean accept = false;
        for (TariffModuleTreeSet.Entry tariffPeriod : tariffTreeSet.entries()) {
            Calendar tariffFrom = tariffPeriod.getCalendarFrom();
            Calendar tariffTo = tariffPeriod.getCalendarTo();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Tariff period: " + TimeUtils.formatPeriod((Calendar)tariffFrom, (Calendar)tariffTo));
            }
            Calendar date1 = this.trimByMonthStart(statusStart);
            Calendar date2 = this.trimByMonthEnd(statusEnd);
            if (tariffFrom != null && TimeUtils.dateBefore((Calendar)date2, (Calendar)tariffFrom)) continue;
            if (tariffFrom != null && TimeUtils.dateBefore((Calendar)date1, (Calendar)tariffFrom)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Trim left");
                }
                date1 = tariffFrom;
            }
            if (tariffTo != null && TimeUtils.dateBefore((Calendar)tariffTo, (Calendar)date2)) {
                if (!TimeUtils.dateBeforeOrEq((Calendar)date1, (Calendar)tariffTo)) continue;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Trim right");
                }
                date2 = tariffTo;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Request period: " + TimeUtils.formatPeriod((Calendar)date1, (Calendar)date2));
            }
            DrWebNTariffRequest.DrWebNServiceCost drWebNServiceCost = (DrWebNTariffRequest.DrWebNServiceCost)new DrWebNTariffRequest.DrWebNServiceCost().setServiceId(sid).setServiceStart(statusStart == null ? null : TimeUtils.convertDateToLocalDate((Date)statusStart.getTime())).setServiceEnd(statusEnd == null ? null : TimeUtils.convertDateToLocalDate((Date)statusEnd.getTime())).setDate1(date1).setDate2(date2).setAmount(1L).to(DrWebNTariffRequest.DrWebNServiceCost.class);
            DrWebNTariffRequest drWebNTariffRequest = new DrWebNTariffRequest(this.moduleId, contractId, -1);
            drWebNTariffRequest.setAccountingMonthDays(this.daysInMonth);
            drWebNTariffRequest.setServiceCost(sid, Collections.singletonList(drWebNServiceCost));
            drWebNTariffRequest.setAgentId(agent.getId());
            drWebNTariffRequest.setTariffTreeSetEntry(tariffPeriod);
            TariffModuleTree tree = tariffPeriod.getTree();
            tree.execute((AbstractTariffRequest)drWebNTariffRequest, (TariffContext)this.context);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Request after processing: " + tariffPeriod.getTree().getTreeId());
                this.getLogger().debug(drWebNTariffRequest.toString());
            }
            if (drWebNTariffRequest.isAccepted()) {
                accept = true;
                for (DrWebNTariffRequest.DrWebNServiceCost serviceCost : drWebNTariffRequest.getServiceCostList()) {
                    CostSum sum = new CostSum(contractId, serviceCost.getServiceId(), serviceCost.getCost());
                    this.costCache.addAmount(sum);
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("Add cost cache cid: " + contractId + "; sid: " + serviceCost.getServiceId() + "; cost: " + String.valueOf(serviceCost.getCost()));
                }
            }
            if (!accept) {
                this.calcErrors = true;
                if (!this.preCalcMode && !this.errorManager.isCapReached()) {
                    String subject = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438";
                    String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + contractId + "\n\u041e\u0431\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430: " + sid;
                    this.errorManager.addErrorToList(subject, text);
                }
                this.getLogger().error("Tariff error contractId: " + contractId + "; serviceId: " + sid);
            }
            ++this.cnt;
            if (this.cnt % 1000 != 0 || !this.getLogger().isInfoEnabled()) continue;
            this.getLogger().info("Item count " + this.cnt);
        }
    }

    protected List<DrwebAgent> getAgentList(DrwebAgentDAO am) throws Exception {
        List<DrwebAgent> agentList;
        if (this.cids == null) {
            agentList = am.getAgentListAll();
        } else {
            agentList = new ArrayList<DrwebAgent>();
            Iterator iterator = Utils.toIntegerList((String)this.cids).iterator();
            while (iterator.hasNext()) {
                int cid = (Integer)iterator.next();
                List<DrwebAgent> list = am.getAgentListByCid(cid);
                agentList.addAll(list);
            }
        }
        return agentList;
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c DrWeb. \u0417\u0430\u0434\u0430\u0447\u0430 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ". \u0417\u0430 \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.format((Calendar)this.startMonth, (String)"yyyy.MM");
    }

    public void setCids(String cids) {
        this.cids = cids;
    }

    protected Calendar trimByMonthEnd(Calendar date) {
        if (date == null || TimeUtils.dateBefore((Calendar)this.endMonth, (Calendar)date)) {
            date = (Calendar)this.endMonth.clone();
        }
        return date;
    }

    protected Calendar trimByMonthStart(Calendar date1) {
        if (date1 == null || TimeUtils.dateBefore((Calendar)date1, (Calendar)this.startMonth)) {
            date1 = (Calendar)this.startMonth.clone();
        }
        return date1;
    }

    protected boolean isNewAgent(Date agentDate, Date nowDate) {
        if (this.graceperiodUnit == 0) {
            return TimeUtils.monthsDelta((Date)agentDate, (Date)nowDate) <= this.graceperiodCount;
        }
        if (this.graceperiodUnit == 1) {
            return TimeUtils.daysDelta((Date)agentDate, (Date)nowDate) <= this.graceperiodCount;
        }
        return false;
    }
}

