/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.bean.documents;

import java.io.FileInputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.server.bean.DocumentDao;
import ru.bitel.bgbilling.plugins.documents.server.filestorage.DocumentsFileStorage;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentInfos;
import ru.bitel.bgbilling.plugins.edo.common.bean.ExtDocument;
import ru.bitel.bgbilling.plugins.edo.server.bean.EdoExtDocumentDao;
import ru.bitel.bgbilling.plugins.edo.server.bean.EdoManager;
import ru.bitel.bgbilling.plugins.edo.server.provider.sbis.SbisAPI;
import ru.bitel.common.ParameterMap;

public class EdoDocumentsManager {
    private Connection con;
    private int userId;
    private EdoManager edoManager;

    public EdoDocumentsManager(Connection con, int userId) {
        this.con = con;
        this.userId = userId;
        this.edoManager = new EdoManager(con, userId);
    }

    public ExtDocument sendEdo(int edoDocumentTypeId, int signatoryId, ContragentInfos contragentInfos, int documentId, List<Integer> fileIds) throws BGException {
        ExtDocument extDocument;
        DocumentDao dd = new DocumentDao(this.con);
        try {
            Document document = dd.getDocument(documentId);
            ParameterMap documentSetup = this.edoManager.getDocumentSetup(edoDocumentTypeId, signatoryId, document.getContractId());
            ArrayList<SbisAPI.InputFile> inputFiles = new ArrayList<SbisAPI.InputFile>();
            DocumentsFileStorage documentsFileStorage = new DocumentsFileStorage(this.con);
            for (Integer id : fileIds) {
                FileInputStream fis = documentsFileStorage.load(id.intValue());
                String title = documentsFileStorage.getFileById(id.intValue()).getTitle();
                inputFiles.add(new SbisAPI.InputFile(title, fis));
            }
            SbisAPI sbisAPI = new SbisAPI(this.userId);
            SbisAPI.WriteDoc writeDoc = sbisAPI.writeNotFormalizedDoc(inputFiles, documentSetup, contragentInfos);
            EdoExtDocumentDao edd = new EdoExtDocumentDao(this.con);
            ExtDocument extDocument2 = new ExtDocument();
            extDocument2.setDocumentTypeId(edoDocumentTypeId);
            extDocument2.setSignatoryId(signatoryId);
            extDocument2.setExtLink(writeDoc.link);
            extDocument2.setExtTitle(writeDoc.title);
            extDocument2.setDate(new Date());
            extDocument2.setUserId(this.userId);
            extDocument2.setContractId(document.getContractId());
            extDocument2.setBillingDocTitle(document.getTitle() + " (" + document.getComment() + ")");
            extDocument2.setDocumentId(documentId);
            edd.update(extDocument2);
            extDocument = extDocument2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    dd.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0432 \u042d\u0414\u041e \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u0439 (" + fileIds.size() + ") \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 documentId=" + documentId + " \u043f\u043b\u0430\u0433\u0438\u043d\u0430 documents", (Throwable)e);
            }
        }
        dd.close();
        return extDocument;
    }
}

