/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.service;

import jakarta.jws.WebService;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentInfos;
import ru.bitel.bgbilling.plugins.edo.common.bean.ExtDocument;
import ru.bitel.bgbilling.plugins.edo.common.service.EdoDocumentsService;
import ru.bitel.bgbilling.plugins.edo.server.bean.documents.EdoDocumentsManager;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.edo.common.service.EdoDocumentsService")
public class EdoDocumentsServiceImpl
extends AbstractService
implements EdoDocumentsService {
    public ExtDocument sendEdo(int documentTypeId, int signatoryId, ContragentInfos contragentInfos, int documentId, List<Integer> fileIds) throws BGException {
        if (documentTypeId <= 0 || signatoryId <= 0 || documentId <= 0) {
            throw new BGIllegalArgumentException("documentTypeId/signatoryId/documentId");
        }
        if (contragentInfos == null || Utils.isEmptyCollection(fileIds)) {
            throw new BGIllegalArgumentException("contragentInfos/fileIds");
        }
        EdoDocumentsManager em = new EdoDocumentsManager(this.getConnection(), this.userId);
        ExtDocument extDocument = em.sendEdo(documentTypeId, signatoryId, contragentInfos, documentId, fileIds);
        return extDocument;
    }
}

