/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class PaymentManager {
    private static final String TABLE_CONTRACT_PYAMENT = "contract_payment";
    private static final String TABLE_CONTRACT_PYAMENT_DELETED = "contract_payment_deleted";
    private Connection con;

    public PaymentManager(Connection con) {
        this.con = con;
    }

    public List<Payment> getPaymentList(int contractId) throws SQLException {
        return this.getPaymentList(contractId, null);
    }

    public List<Payment> getPaymentList(int contractId, Period period) throws SQLException {
        ArrayList<Payment> result = new ArrayList<Payment>();
        int index = 1;
        StringBuilder query = new StringBuilder("SELECT * FROM ");
        query.append(TABLE_CONTRACT_PYAMENT);
        query.append(" WHERE cid=?");
        if (period != null) {
            if (period.getDateFrom() != null) {
                query.append(" AND dt>=?");
            }
            if (period.getDateTo() != null) {
                query.append(" AND dt<?");
            }
        }
        query.append(" ORDER BY dt");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(index++, contractId);
        if (period != null && period.getDateFrom() != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
        }
        if (period != null && period.getDateTo() != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(this.getPaymentFromRs(rs));
        }
        rs.close();
        ps.close();
        return result;
    }

    public void updatePayment(Payment payment) throws BGException {
        try {
            if (payment != null) {
                String query = null;
                PreparedStatement ps = null;
                if (payment.getId() < 0) {
                    query = "INSERT INTO contract_payment SET dt=?, cid=?, pt=?, uid=?, summa=?, comment=?";
                    ps = this.con.prepareStatement(query, 1);
                } else {
                    query = "UPDATE contract_payment SET dt=?, cid=?, pt=?, uid=?, summa=?, comment=? WHERE id=?";
                    ps = this.con.prepareStatement(query);
                    ps.setInt(7, payment.getId());
                }
                ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)payment.getDate()));
                ps.setInt(2, payment.getContractId());
                ps.setInt(3, payment.getTypeId());
                ps.setInt(4, payment.getUserId());
                ps.setBigDecimal(5, payment.getSum());
                ps.setString(6, payment.getComment());
                ps.executeUpdate();
                if (payment.getId() < 0) {
                    payment.setId(ServerUtils.lastInsertId(ps));
                }
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public Payment getPaymentById(int id) throws BGException {
        try {
            Payment result = null;
            StringBuilder query = new StringBuilder("SELECT * FROM ").append(TABLE_CONTRACT_PYAMENT).append(" WHERE id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getPaymentFromRs(rs);
            }
            ps.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public boolean deletePayment(int id) throws BGException {
        try {
            boolean result = false;
            String query = "INSERT INTO contract_payment_deleted SELECT * FROM contract_payment WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            ps = this.con.prepareStatement("DELETE FROM contract_payment WHERE id=?");
            ps.setInt(1, id);
            result = ps.executeUpdate() > 0;
            ps.close();
            ps = this.con.prepareStatement("UPDATE contract_payment_deleted SET lm=null WHERE id=?");
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void zeroBalancePayment(Date date, int contractId, int paymentTypeId) throws BGException {
        this.zeroBalancePayment(date, contractId, paymentTypeId, "\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0434\u043b\u044f \u043e\u0431\u043d\u0443\u043b\u0435\u043d\u0438\u044f \u0431\u0430\u043b\u0430\u043d\u0441\u0430");
    }

    public void zeroBalancePayment(Date date, int contractId, int paymentTypeId, String paymentComment) throws BGException {
        if (date != null) {
            try (BalanceUtils bu = new BalanceUtils(this.con);){
                BigDecimal balance = bu.getBalance(date, contractId);
                if (balance.compareTo(BigDecimal.ZERO) >= 0) {
                    return;
                }
                BigDecimal delta = balance.abs();
                Payment payment = new Payment().setTypeId(paymentTypeId).setContractId(contractId).setDate(date).setSum(delta).setComment(paymentComment).setUserId(0);
                this.updatePayment(payment);
                bu.updateBalance(date, contractId);
            }
        }
    }

    private Payment getPaymentFromRs(ResultSet rs) throws SQLException {
        Payment payment = new Payment();
        payment.setId(rs.getInt("id"));
        payment.setContractId(rs.getInt("cid"));
        payment.setComment(rs.getString("comment"));
        payment.setDate(rs.getDate("dt"));
        payment.setTypeId(rs.getInt("pt"));
        payment.setSum(rs.getBigDecimal("summa"));
        payment.setUserId(rs.getInt("uid"));
        payment.setTimeChange(rs.getTimestamp("lm"));
        return payment;
    }

    public List<Payment> getPaymentsById(String idList) throws SQLException {
        ArrayList<Payment> result = new ArrayList<Payment>();
        if (Utils.isBlankString((String)idList)) {
            return result;
        }
        String query = "SELECT * FROM contract_payment WHERE id IN (" + idList + ")";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(this.getPaymentFromRs(rs));
        }
        ps.close();
        return result;
    }

    public void deletePaymentsById(String idList) throws SQLException {
        if (Utils.isEmptyString((String)idList)) {
            return;
        }
        String query = "INSERT INTO contract_payment_deleted SELECT * FROM contract_payment WHERE id IN (" + idList + ")";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.executeUpdate();
        ps.close();
        query = "DELETE FROM contract_payment WHERE id IN (" + idList + ")";
        ps = this.con.prepareStatement(query);
        ps.executeUpdate();
        ps.close();
    }

    @Deprecated
    public void zeroBalancePayment(Calendar date, int contractId, int paymentTypeId) throws BGException {
        if (date != null) {
            this.zeroBalancePayment(date.getTime(), contractId, paymentTypeId);
        }
    }

    @Deprecated
    public List<Payment> getPaymentList(int contractId, Calendar date1, Calendar date2) throws SQLException {
        Period period = new Period();
        period.setDateFrom(TimeUtils.convertCalendarToDate((Calendar)date1));
        period.setDateTo(TimeUtils.convertCalendarToDate((Calendar)date2));
        return this.getPaymentList(contractId, new Period());
    }

    @Deprecated
    public void updatePayment(String id, Payment payment) throws BGException {
        if (payment != null) {
            payment.setId(Utils.parseInt((String)id, (int)-1));
            this.updatePayment(payment);
        }
    }

    @Deprecated
    public Payment getPaymentByID(int id) throws BGException {
        return this.getPaymentById(id);
    }
}

