/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatusLog;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

public class ContractStatusLogDao
extends AbstractIdDao<ContractStatusLog> {
    public ContractStatusLogDao(Connection con) {
        super(con, "contract_status_log");
    }

    protected ContractStatusLog getFromRS(ResultSet rs) throws SQLException {
        return new ContractStatusLog().setId(rs.getInt("id")).setDate(rs.getTimestamp("date")).setUserId(rs.getInt("uid")).setContractId(rs.getInt("cid")).setObjectId(rs.getInt("object_id")).setStatus(rs.getInt("status")).setDate1(rs.getDate("date1")).setDate2(rs.getDate("date2")).setComment(rs.getString("comment"));
    }

    protected void updateImpl(ContractStatusLog contractStatusLog) throws SQLException {
        String query = "INSERT INTO " + this.tableName + " SET date=?, status=?, comment=?, uid=?, date1=?, date2=?, cid=?, object_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)contractStatusLog.getDate()));
            ps.setInt(index++, contractStatusLog.getStatus());
            ps.setString(index++, contractStatusLog.getComment());
            ps.setInt(index++, contractStatusLog.getUserId());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)contractStatusLog.getDate1()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)contractStatusLog.getDate2()));
            ps.setInt(index++, contractStatusLog.getContractId());
            ps.setInt(index++, contractStatusLog.getObjectId());
            ps.executeUpdate();
        }
    }

    public List<ContractStatusLog> getLogList(int contractId) throws SQLException {
        return this.getLogList(contractId, 0);
    }

    public List<ContractStatusLog> getLogList(int contractId, int objectId) throws SQLException {
        return this.list("cid=? AND object_id=?", "date desc", new Object[]{contractId, objectId});
    }

    public void searchContractStatusLog(SearchResult<ContractStatusLog> searchResult, int contractId, int objectId) throws SQLException {
        Result result = this.list(searchResult.getPage(), "cid=? AND object_id=?", "date desc", new Object[]{contractId, objectId});
        searchResult.setList(result.getList());
        searchResult.setPage(result.getPage());
    }
}

