/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree.old;

import bitel.billing.server.tariff.detail.TariffDetailUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.Utils;

public class ServiceRangeTariffTreeNode
extends DefaultTariffTreeNode {
    private static final boolean debug = false;
    private int lastCid = -1;
    private long lastContractAmount = 0L;
    private int mode;
    private long nodeAmount = 0L;
    private Map<Integer, Long> contractAmounts = Collections.synchronizedMap(new HashMap(100, 20.0f));

    @Override
    public void init(String dataStr, int deep, int nodeID) {
        super.init(dataStr, deep, nodeID);
        Map<String, String> data = this.getDataInHash();
        int type = Utils.parseInt((String)data.get("type"), (int)-1);
        long col = Utils.parseLong((String)data.get("col"), (long)-1L);
        this.mode = Utils.parseInt((String)data.get("mode"), (int)0);
        if (type >= 0 && col >= 0L) {
            this.nodeAmount = this.getServiceAmount(type, col);
        }
    }

    @Override
    public void processRequest(TariffRequest request) {
        String action = (String)request.getRequestParam("action");
        Long amount = (Long)request.getRequestParam("amount");
        Integer cid = (Integer)request.getRequestParam("cid");
        Float part = null;
        if (action != null) {
            long nodeAmount = this.nodeAmount;
            if (this.mode == 1) {
                part = (Float)request.getRequestParam("part");
                if (part != null) {
                    nodeAmount = (long)((float)nodeAmount * part.floatValue());
                }
            } else if (this.mode == 2) {
                part = (Float)request.getRequestParam("part_tariff");
                if (part != null) {
                    nodeAmount = (long)((float)nodeAmount * part.floatValue());
                }
            } else if (this.mode == 3 && (part = (Float)request.getRequestParam("part_tariff_suspended")) != null) {
                nodeAmount = (long)((float)nodeAmount * part.floatValue());
            }
            if (action.equals("reset") && cid != null) {
                this.contractAmounts.remove(cid);
                this.lastCid = -1;
                this.lastContractAmount = 0L;
            } else if (!action.equals("init") && cid != null && amount != null && amount > 0L && this.enableNodeForContract(cid, nodeAmount)) {
                request.setNoAccepted();
                request.setResponseParam("cost", null);
                request.setResponseParam("divisor", null);
                this.processForChilds(request);
                Float cost = (Float)request.getResponseParam("cost");
                Long divisor = (Long)request.getResponseParam("divisor");
                if (request.wasAccepted() && cost != null && divisor != null && divisor != 0L) {
                    long amountRest;
                    Long contractAmount;
                    boolean cidNew = cid != this.lastCid;
                    Long l = contractAmount = cidNew ? this.contractAmounts.get(cid) : Long.valueOf(this.lastContractAmount);
                    if (contractAmount == null) {
                        contractAmount = 0L;
                    }
                    long takedAmount = (amountRest = nodeAmount - contractAmount) > amount || nodeAmount == 0L ? amount : amountRest;
                    contractAmount = contractAmount + takedAmount;
                    this.contractAmounts.put(cid, contractAmount);
                    this.lastContractAmount = contractAmount;
                    this.lastCid = cid;
                    amount = amount - takedAmount;
                    request.setRequestParam("amount", amount);
                    Float costAmount = (Float)request.getResponseParam("costAmount");
                    if (costAmount == null) {
                        costAmount = Float.valueOf(0.0f);
                    }
                    float takedCost = (float)takedAmount * cost.floatValue() / (float)divisor.longValue();
                    costAmount = Float.valueOf(costAmount.floatValue() + takedCost);
                    request.setResponseParam("costAmount", costAmount);
                    request.setAccepted();
                    Integer sid = (Integer)request.getRequestParam("sid");
                    TariffDetailUtils.processRequest(request, cid, sid, takedAmount, takedCost, nodeAmount, cost.floatValue(), divisor);
                }
            }
        } else {
            request.addError("Params error! ServiceRangeTariffTreeNode ( action = NULL )");
        }
    }

    private boolean enableNodeForContract(Integer cid, long nodeAmount) {
        boolean result = true;
        if (nodeAmount != 0L) {
            Long contractAmount;
            boolean cidNew = cid != this.lastCid;
            Long l = contractAmount = cidNew ? this.contractAmounts.get(cid) : Long.valueOf(this.lastContractAmount);
            if (contractAmount != null && contractAmount >= nodeAmount) {
                result = false;
            }
        }
        return result;
    }
}

