/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gazprombank.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.Connection;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.gazprombank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.gazprombank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.gazprombank.server.event.GazprombankCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="GazprombankExecutor", urlPatterns={"/gpb/*"})
public class ModuleExecutor
extends CommonExecutor {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String orderId = request.getParameter("o.order_id");
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
            Transaction transaction = (Transaction)new TransactionManager(con, moduleId).get(Utils.parseInt((String)orderId));
            if (transaction == null) {
                this.getLogger().error("Not found transaction for ID = " + orderId);
                this.send(response, "FAILED");
                return;
            }
            this.getLogger().debug("publish SberbankCheckEvent");
            EventProcessor eventProcessor = EventProcessor.getInstance();
            eventProcessor.publish((Event)new GazprombankCheckEvent(moduleId, transaction.getId()));
            eventProcessor.publish((Event)new GazprombankCheckEvent(moduleId, transaction.getContractId(), transaction.isAutopayment()));
            this.send(response, "OK");
        }
        catch (Exception ex) {
            this.send(response, "FAILED");
            this.logError(ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    private void send(HttpServletResponse response, String desc) {
        response.setContentType("text/xml");
        String body = "<register-payment-response>\n  <result>\n    <code>1</code>\n    <desc>" + desc + "</desc>\n  </result>\n</register-payment-response>";
        try (ServletOutputStream out = response.getOutputStream();){
            out.print(body);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }
}

