/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.service;

import jakarta.jws.WebService;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.DataProcessRecord;
import ru.bitel.bgbilling.modules.inet.common.service.InetLogManagementService;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.DataProcessRecordDao;
import ru.bitel.bgbilling.modules.inet.server.event.RequestLogInfoEvent;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Result;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.inet.common.service.InetLogManagementService")
public class InetLogManagementServiceImpl
extends AbstractService
implements InetLogManagementService {
    private DataProcessRecordDao dataProcessRecordDao;

    public Result<String> inetLogExist(Integer deviceId, Date month) throws BGException {
        Result result = new Result();
        int[] exists = this.getLogExists(deviceId, month);
        if (exists != null) {
            result.setAttribute("logExists", (Object)exists);
        }
        return result;
    }

    public List<DataProcessRecord> inetLogLoading(Integer deviceId, Date month) throws BGException {
        return this.getLogLoad(deviceId, month);
    }

    protected List<DataProcessRecord> getLogLoad(Integer deviceId, Date month) throws BGException {
        return (List)this.tryReturn(() -> {
            Calendar cal = new GregorianCalendar();
            cal.setTime(month);
            cal = TimeUtils.getStartMonth((Calendar)cal);
            cal.set(5, 1);
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)cal);
            Date dateFrom = TimeUtils.convertCalendarToDate((Calendar)cal);
            cal.add(2, 1);
            Date dateTo = TimeUtils.convertCalendarToDate((Calendar)cal);
            return this.getDataProcessRecordDao().list(deviceId, dateFrom, dateTo, 1);
        });
    }

    protected int[] getLogExists(Integer deviceId, Date month) throws BGException {
        return (int[])this.tryReturn(() -> {
            int accountingRootDeviceId = InetUtils.getAccountingRootDeviceId(this.context.getSetup(), this.moduleId, (int)deviceId);
            int[] exists = null;
            RequestLogInfoEvent event = new RequestLogInfoEvent(this.moduleId, month, accountingRootDeviceId, deviceId);
            event = (RequestLogInfoEvent)EventProcessor.getInstance().request((Event)event, 5000L);
            if (event != null) {
                exists = event.getLogs();
            }
            return exists;
        });
    }

    public void inetAddProcessLogs(Integer deviceId, List<Date> days) throws BGException {
        this.addTasks(deviceId, days, (byte)1);
    }

    public void addTasks(Integer deviceId, List<Date> days, byte type) throws BGException {
        this.tryCall(() -> {
            List<DataProcessRecord> list = this.getDataProcessRecordDao().list(deviceId, days, type);
            for (Date day : days) {
                boolean found = false;
                for (DataProcessRecord record : list) {
                    if (!record.getDay().equals(day)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                DataProcessRecord record = new DataProcessRecord();
                record.setDeviceId(deviceId.intValue());
                record.setDay(day);
                record.setType(type);
                this.getDataProcessRecordDao().update(record);
            }
        });
    }

    public void inetDeleteProcessLogs(Integer deviceId, List<Date> days) throws BGException {
        this.tryCall(() -> this.getDataProcessRecordDao().delete(deviceId, days, 1));
    }

    public void inetAddCreateSessions(Integer deviceId, List<Date> days) throws BGException {
        this.addTasks(deviceId, days, (byte)2);
    }

    public void inetDeleteCreateSessions(Integer deviceId, List<Date> days) throws BGException {
        this.tryCall(() -> this.getDataProcessRecordDao().delete(deviceId, days, 2));
    }

    public List<DataProcessRecord> inetLogSessionCreating(Integer deviceId, Date month) throws BGException {
        return (List)this.tryReturn(() -> {
            Calendar cal = new GregorianCalendar();
            cal.setTime(month);
            cal = TimeUtils.getStartMonth((Calendar)cal);
            cal.set(5, 1);
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)cal);
            Date dateFrom = TimeUtils.convertCalendarToDate((Calendar)cal);
            cal.add(2, 1);
            Date dateTo = TimeUtils.convertCalendarToDate((Calendar)cal);
            return this.getDataProcessRecordDao().list(deviceId, dateFrom, dateTo, 2);
        });
    }

    private DataProcessRecordDao getDataProcessRecordDao() {
        this.dataProcessRecordDao = new DataProcessRecordDao(this.getConnection(), this.moduleId);
        return Optional.ofNullable(this.dataProcessRecordDao).orElse(this.dataProcessRecordDao);
    }
}

