/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.radius;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNas;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetOptionRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetOptionRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceReserve;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceReserveManager;

public class IpResourceEntry {
    private static final Logger logger = LogManager.getLogger();
    final Map<String, LinkedHashSet<Integer>> realmIpCategoriesMap = new HashMap<String, LinkedHashSet<Integer>>();
    final Map<String, IpResourceReserveManager> realmIpReserveMap = new HashMap<String, IpResourceReserveManager>();
    final Map<String, LinkedHashSet<Integer>> realmPrefixIpCategoriesMap = new HashMap<String, LinkedHashSet<Integer>>();
    final Map<String, IpResourceReserveManager> realmPrefixIpReserveMap = new HashMap<String, IpResourceReserveManager>();
    final Map<String, LinkedHashSet<Integer>> realmDelegatedPrefixIpCategoriesMap = new HashMap<String, LinkedHashSet<Integer>>();
    final Map<String, IpResourceReserveManager> realmDelegatedPrefixIpReserveMap = new HashMap<String, IpResourceReserveManager>();
    final Map<String, Map<Integer, LinkedHashSet<Integer>>> realmOptionIpCategoriesMap = new HashMap<String, Map<Integer, LinkedHashSet<Integer>>>();
    final Map<String, Map<Integer, IpResourceReserveManager>> realmOptionIpReserveMap = new HashMap<String, Map<Integer, IpResourceReserveManager>>();
    private boolean hasOptionsConfiguration = false;
    private final boolean empty;

    IpResourceEntry(InetApplication access, InetOptionRuntimeMap optionRuntimeMap, InetDeviceRuntime deviceRuntime, ParameterMap config) {
        IpResourceReserveManager ipReserve;
        LinkedHashSet<Integer> categories;
        for (Map.Entry e : config.subKeyed("radius.realm.").entrySet()) {
            LinkedHashSet categories2;
            String realm = (String)e.getKey();
            ParameterMap params = (ParameterMap)e.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug("Loading named pools for realm: " + realm);
            }
            IpResourceEntry.loadPool(access, deviceRuntime, realm, params.get("ipPool", null), this.realmIpCategoriesMap, this.realmIpReserveMap);
            IpResourceEntry.loadPool(access, deviceRuntime, realm, params.get("prefixPool", null), this.realmPrefixIpCategoriesMap, this.realmPrefixIpReserveMap);
            IpResourceEntry.loadPool(access, deviceRuntime, realm, params.get("delegatedPrefixPool", null), this.realmDelegatedPrefixIpCategoriesMap, this.realmDelegatedPrefixIpReserveMap);
            if (logger.isDebugEnabled()) {
                logger.debug("Loading unnamed ip categories for realm: " + realm);
            }
            if ((categories2 = new LinkedHashSet(Utils.toIntegerList((String)params.get("ipCategories", params.get("pool", ""))))) == null || categories2.size() <= 0) continue;
            this.realmIpCategoriesMap.put(realm, categories2);
            if (access == null) continue;
            IpResourceReserveManager ipReserve2 = access.ipResourceManager.getReserveManager(categories2, "radius.realm." + realm + ".ipCategories");
            this.realmIpReserveMap.put(realm, ipReserve2);
        }
        String pool = config.get("radius.disable.ipPool", null);
        if (logger.isDebugEnabled()) {
            logger.debug("Loading NAMED disable pool");
        }
        if (Utils.notBlankString((String)pool) && (categories = deviceRuntime.getIpPoolCategoryIds(pool)) != null && categories.size() > 0) {
            this.realmIpCategoriesMap.put("disable", categories);
            if (logger.isDebugEnabled()) {
                logger.debug("Loaded named disable pool categories: " + Utils.toString(categories) + " for device: " + deviceRuntime.inetDevice.getId());
            }
            if (access != null) {
                ipReserve = deviceRuntime.getIpPool(pool);
                this.realmIpReserveMap.put("disable", ipReserve);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Loading UNNAMED disable pools");
        }
        if ((categories = new LinkedHashSet(Utils.toIntegerList((String)config.get("radius.disable.ipCategories", config.get("nas.radius.realm.reject.pool", ""))))) != null && categories.size() > 0) {
            this.realmIpCategoriesMap.put("disable", categories);
            if (logger.isDebugEnabled()) {
                logger.debug("Loaded unnamed disable pool categories: " + Utils.toString(categories) + " for device: " + deviceRuntime.inetDevice.getId());
            }
            if (access != null) {
                ipReserve = access.ipResourceManager.getReserveManager(categories, "radius.disable.ipCategories");
                this.realmIpReserveMap.put("disable", ipReserve);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Loading ip pools from options");
        }
        this.loadOptions(optionRuntimeMap, deviceRuntime, config);
        this.empty = this.realmIpReserveMap.isEmpty() && this.realmPrefixIpReserveMap.isEmpty() && this.realmDelegatedPrefixIpReserveMap.isEmpty() && !this.hasOptionsConfiguration;
    }

    private static void loadPool(InetApplication access, InetDeviceRuntime deviceRuntime, String realm, String pool, Map<String, LinkedHashSet<Integer>> realmIpCategoriesMap, Map<String, IpResourceReserveManager> realmIpReserveMap) {
        if (Utils.isBlankString((String)pool)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Loading pool: " + pool);
        }
        LinkedHashSet<Integer> categories = deviceRuntime.getIpPoolCategoryIds(pool);
        if (logger.isDebugEnabled()) {
            logger.debug("Device id: " + deviceRuntime.inetDevice.getId() + "; categories: " + Utils.toString(categories));
        }
        if (categories != null && categories.size() > 0) {
            realmIpCategoriesMap.put(realm, categories);
            if (access != null) {
                IpResourceReserveManager ipReserve = deviceRuntime.getIpPool(pool);
                realmIpReserveMap.put(realm, ipReserve);
            }
        }
    }

    private void loadOptions(InetOptionRuntimeMap optionRuntimeMap, InetDeviceRuntime deviceRuntime, ParameterMap conf) {
        Object option;
        for (Map.Entry<Integer, InetOptionRuntime> entry : optionRuntimeMap.getMap().entrySet()) {
            option = entry.getValue();
            for (Map.Entry<String, String> entry2 : ((InetOptionRuntime)option).getRealmPoolMap().entrySet()) {
                String realm = entry2.getKey();
                String pool = entry2.getValue();
                if (Utils.isBlankString((String)pool)) continue;
                Map<Integer, LinkedHashSet<Integer>> categoryMap = this.realmOptionIpCategoriesMap.get(realm);
                if (categoryMap == null) {
                    categoryMap = new HashMap<Integer, LinkedHashSet<Integer>>();
                    this.realmOptionIpCategoriesMap.put(realm, categoryMap);
                }
                categoryMap.put(((InetOptionRuntime)option).id, deviceRuntime.getIpPoolCategoryIds(pool));
                IpResourceReserveManager reserveManager = deviceRuntime.getIpPool(pool);
                if (reserveManager == null) continue;
                Map<Integer, IpResourceReserveManager> realmMap = this.realmOptionIpReserveMap.get(realm);
                if (realmMap == null) {
                    realmMap = new HashMap<Integer, IpResourceReserveManager>();
                    this.realmOptionIpReserveMap.put(realm, realmMap);
                }
                realmMap.put(entry.getKey(), reserveManager);
            }
        }
        for (Map.Entry<Integer, InetOptionRuntime> entry : conf.subIndexed("radius.inetOption.").entrySet()) {
            option = entry.getKey();
            for (Map.Entry<String, String> entry3 : ((ParameterMap)entry.getValue()).subKeyed("").entrySet()) {
                String realm;
                String key2 = entry3.getKey();
                String pool = null;
                String prefixPool = null;
                String delegatedPrefixPool = null;
                if ("template".equals(key2) || "attributes".equals(key2)) continue;
                if ("ipPool".equals(key2)) {
                    pool = ((ParameterMap)entry3.getValue()).get("", null);
                    realm = "default";
                } else if ("prefixPool".equals(key2)) {
                    prefixPool = ((ParameterMap)entry3.getValue()).get("", null);
                    realm = "default";
                } else if ("delegatedPrefixPool".equals(key2)) {
                    delegatedPrefixPool = ((ParameterMap)entry3.getValue()).get("", null);
                    realm = "default";
                } else {
                    pool = ((ParameterMap)entry3.getValue()).get("ipPool", null);
                    prefixPool = ((ParameterMap)entry3.getValue()).get("prefixPool", null);
                    delegatedPrefixPool = ((ParameterMap)entry3.getValue()).get("delegatedPrefixPool", null);
                    realm = key2;
                }
                if (Utils.isBlankString((String)pool) && Utils.isBlankString((String)prefixPool) && Utils.isBlankString((String)delegatedPrefixPool)) continue;
                Map<Integer, LinkedHashSet<Integer>> categoryMap = this.realmOptionIpCategoriesMap.get(realm);
                if (categoryMap == null) {
                    categoryMap = new HashMap<Integer, LinkedHashSet<Integer>>();
                    this.realmOptionIpCategoriesMap.put(realm, categoryMap);
                }
                categoryMap.put((Integer)option, deviceRuntime.getIpPoolCategoryIds(pool));
                IpResourceReserveManager reserveManager = deviceRuntime.getIpPool(pool);
                if (reserveManager == null) continue;
                Map<Integer, IpResourceReserveManager> realmMap = this.realmOptionIpReserveMap.get(realm);
                if (realmMap == null) {
                    realmMap = new HashMap<Integer, IpResourceReserveManager>();
                    this.realmOptionIpReserveMap.put(realm, realmMap);
                }
                realmMap.put((Integer)option, reserveManager);
                this.hasOptionsConfiguration = true;
            }
        }
    }

    private IpResourceReserveManager getForOption(String realm, Set<Integer> optionSet) {
        if (this.realmOptionIpReserveMap.size() == 0 || optionSet == null || optionSet.size() == 0) {
            return null;
        }
        Map<Integer, IpResourceReserveManager> optionMap = this.realmOptionIpReserveMap.get(realm);
        if (optionMap == null || optionMap.size() == 0) {
            return null;
        }
        if (optionSet.size() < optionMap.size()) {
            for (Integer option : optionSet) {
                IpResourceReserveManager result = optionMap.get(option);
                if (result == null) continue;
                return result;
            }
        } else {
            for (Map.Entry<Integer, IpResourceReserveManager> e : optionMap.entrySet()) {
                if (!optionSet.contains(e.getKey())) continue;
                return e.getValue();
            }
        }
        return null;
    }

    public Set<Integer> getCategoriesForOption(String realm, Set<Integer> optionSet) {
        if (this.realmOptionIpCategoriesMap.size() == 0 || optionSet == null || optionSet.size() == 0) {
            return null;
        }
        Map<Integer, LinkedHashSet<Integer>> optionMap = this.realmOptionIpCategoriesMap.get(realm);
        if (optionMap == null || optionMap.size() == 0) {
            return null;
        }
        if (optionSet.size() < optionMap.size()) {
            for (Integer option : optionSet) {
                LinkedHashSet<Integer> result = optionMap.get(option);
                if (result == null) continue;
                return result;
            }
        } else {
            for (Map.Entry<Integer, LinkedHashSet<Integer>> e : optionMap.entrySet()) {
                if (!optionSet.contains(e.getKey())) continue;
                return e.getValue();
            }
        }
        return null;
    }

    public IpResourceReserve reserve(InetNas nas, String realm, boolean[] resourceExist, Set<Integer> optionSet) {
        IpResourceReserve reserve;
        IpResourceReserveManager reserveManager;
        if (optionSet != null && optionSet.size() > 0 && (reserveManager = this.getForOption(realm, optionSet)) != null && (reserve = reserveManager.reserve()) != null) {
            return reserve;
        }
        return IpResourceEntry.reserve(this.realmIpReserveMap, nas, realm, resourceExist, AddressType.Default);
    }

    public IpResourceReserve reservePrefix(InetNas nas, String realm, boolean[] resourceExist) {
        return IpResourceEntry.reserve(this.realmPrefixIpReserveMap, nas, realm, resourceExist, AddressType.IPv6Prefix);
    }

    public IpResourceReserve reserveDelegatedPrefix(InetNas nas, String realm, boolean[] resourceExist) {
        return IpResourceEntry.reserve(this.realmDelegatedPrefixIpReserveMap, nas, realm, resourceExist, AddressType.IPv6DelegatedPrefix);
    }

    private static IpResourceReserve reserve(Map<String, IpResourceReserveManager> realmIpReserveMap, InetNas nas, String realm, boolean[] resourceExist, AddressType addressType) {
        IpResourceReserve reserve;
        IpResourceReserveManager reserveManager = realmIpReserveMap.get(realm);
        if (reserveManager == null) {
            if (resourceExist == null) {
                logger.error("Not found ip resources inetNas:" + nas.getId() + " and realm: " + realm + " for addressType: " + addressType.name() + "!");
            }
            return null;
        }
        if (resourceExist != null) {
            resourceExist[0] = true;
        }
        if ((reserve = reserveManager.reserve()) == null) {
            if (addressType == AddressType.Default || resourceExist != null && resourceExist[0]) {
                switch (addressType.ordinal()) {
                    case 1: {
                        logger.error("Can't reserve IPv6Prefix for inetNas:" + nas.getId() + " and realm: " + realm + "!");
                        break;
                    }
                    case 2: {
                        logger.error("Can't reserve IPv6DelegatedPrefix for inetNas:" + nas.getId() + " and realm: " + realm + "!");
                        break;
                    }
                    default: {
                        logger.error("Can't reserve IP-address for inetNas:" + nas.getId() + " and realm: " + realm + "!");
                    }
                }
            }
            return null;
        }
        return reserve;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public static enum AddressType {
        Default,
        IPv6Prefix,
        IPv6DelegatedPrefix;

    }

    public static class IpResourceReserveKit {
        IpResourceReserve ipv4Address;
        IpResourceReserve ipv6Prefix;
        IpResourceReserve ipv6DelegatedPrefix;
    }
}

