/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.task;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.FindFirstAccountingEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.InetCanCalculateEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.InetRecalculateBaseEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.InetRecalculateCurrentDayEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.InetRecalculateCurrentMonthBeforeDayEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.InetRecalculateDayInCurrentMonthEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.TarrificationContinueEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.TarrificationSuspendEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.response.RecalculateResponseEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetAllTariffMaxTraffAndRangeUpdate;
import ru.bitel.bgbilling.modules.inet.server.mail.MailTaskRecalculator;
import ru.bitel.bgbilling.modules.inet.server.task.InetRecalculateResponseEventProcessor;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.concurrent.ConcurrentUtils;
import ru.bitel.common.concurrent.FutureResult;

public class InetRecalculator
extends RunTask {
    protected int moduleId = -1;
    protected Date month;
    protected String email = null;
    private final Set<Integer> cids;
    private Integer day;
    private List<Integer> aplicationIds = new ArrayList<Integer>();
    InetRecalculateResponseEventProcessor respProcessor;
    Map<Integer, Map<Integer, FutureResult<Boolean>>> answers = new HashMap<Integer, Map<Integer, FutureResult<Boolean>>>();
    private final boolean calculateOnlyLogSessions;
    private static final Object mutex = new Object();
    private static final AtomicInteger requestIndex = new AtomicInteger(0);

    public InetRecalculator(Date month, Integer day, int moduleId, String email, Set<Integer> cids, String comment, boolean calculateOnlyLogSessions) {
        this.moduleId = moduleId;
        this.month = month;
        this.email = email;
        this.cids = cids;
        this.day = day;
        this.calculateOnlyLogSessions = calculateOnlyLogSessions;
        this.respProcessor = new InetRecalculateResponseEventProcessor(this.answers);
    }

    public String getDescription() {
        return "\u041c\u043e\u0434\u0443\u043b\u044c Inet. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0430 \u0441\u0435\u0441\u0441\u0438\u0439. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + "; \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + Utils.toString(this.cids) + "; \u041c\u0435\u0441\u044f\u0446: + " + String.valueOf(this.month) + "; \u0414\u0435\u043d\u044c: + " + this.day + "; \u041f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043b\u043e\u0433\u043e\u0432:" + this.calculateOnlyLogSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        long time = System.currentTimeMillis();
        String error = null;
        try {
            this.calculate();
        }
        catch (BGException ex) {
            try {
                this.getLogger().error("", (Throwable)ex);
                error = ex.getMessage();
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                if (this.email != null) {
                    StringBuffer report = new StringBuffer("\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 Inet \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e\n").append("\n\u0412\u0440\u0435\u043c\u044f: ").append(TimeUtils.formatDeltaTime((long)((end - time) / 1000L)));
                    if (error != null) {
                        report.append("\n\u041e\u0448\u0438\u0431\u043a\u0438: " + error);
                    }
                    try {
                        MailData mailData = new MailTaskRecalculator().setModuleId(this.moduleId).setRecipients(this.email).setSubject("\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 Inet \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e" + (error != null ? " c \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438" : "")).addTextPart("text", report.toString());
                        new MailMsg((Preferences)this.setup).sendMessage(mailData);
                    }
                    catch (Exception ex2) {
                        this.logError(ex2);
                    }
                }
                throw throwable;
            }
            long end = System.currentTimeMillis();
            if (this.email != null) {
                StringBuffer report = new StringBuffer("\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 Inet \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e\n").append("\n\u0412\u0440\u0435\u043c\u044f: ").append(TimeUtils.formatDeltaTime((long)((end - time) / 1000L)));
                if (error != null) {
                    report.append("\n\u041e\u0448\u0438\u0431\u043a\u0438: " + error);
                }
                try {
                    MailData mailData = new MailTaskRecalculator().setModuleId(this.moduleId).setRecipients(this.email).setSubject("\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 Inet \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e" + (error != null ? " c \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438" : "")).addTextPart("text", report.toString());
                    new MailMsg((Preferences)this.setup).sendMessage(mailData);
                }
                catch (Exception ex3) {
                    this.logError(ex3);
                }
            }
        }
        long end = System.currentTimeMillis();
        if (this.email != null) {
            StringBuffer report = new StringBuffer("\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 Inet \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e\n").append("\n\u0412\u0440\u0435\u043c\u044f: ").append(TimeUtils.formatDeltaTime((long)((end - time) / 1000L)));
            if (error != null) {
                report.append("\n\u041e\u0448\u0438\u0431\u043a\u0438: " + error);
            }
            try {
                MailData mailData = new MailTaskRecalculator().setModuleId(this.moduleId).setRecipients(this.email).setSubject("\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 Inet \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e" + (error != null ? " c \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438" : "")).addTextPart("text", report.toString());
                new MailMsg((Preferences)this.setup).sendMessage(mailData);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculate() throws BGException {
        block21: {
            try {
                ArrayList<Integer> availableIds = new ArrayList<Integer>();
                List<Integer> calculateIds = new ArrayList<Integer>();
                this.getLogger().info("init application ids: " + Utils.toString(this.aplicationIds));
                if (this.aplicationIds.size() == 0) {
                    Object event = new FindFirstAccountingEvent(this.moduleId);
                    try {
                        event = (FindFirstAccountingEvent)EventProcessor.getInstance().request((Event)event, 20000L);
                        if (event == null) {
                            throw new BGException("No one accounting  accessible");
                        }
                        availableIds.add(((FindFirstAccountingEvent)((Object)event)).getApplicationId());
                        calculateIds.add(((FindFirstAccountingEvent)((Object)event)).getApplicationId());
                    }
                    catch (Exception e) {
                        this.getLogger().error(e.getMessage(), (Throwable)e);
                        throw new BGException("No one accounting  accessible");
                    }
                } else {
                    for (Integer id : this.aplicationIds) {
                        InetCanCalculateEvent canCalEvent = new InetCanCalculateEvent(this.moduleId, id);
                        try {
                            canCalEvent = (InetCanCalculateEvent)EventProcessor.getInstance().request((Event)canCalEvent, 20000L);
                            if (canCalEvent != null) {
                                availableIds.add(id);
                                calculateIds.add(id);
                                continue;
                            }
                            this.getLogger().error("Accounting server with id = " + id + " is not accessible");
                        }
                        catch (Exception e) {
                            this.getLogger().error(e.getMessage(), (Throwable)e);
                            this.getLogger().error("Accounting server with id = " + id + " is not accessible");
                        }
                    }
                }
                if (availableIds.size() == 0) {
                    throw new BGException("No one accounting  accessible");
                }
                this.getLogger().info("available application ids: " + Utils.toString(availableIds));
                if (this.cids.size() > 0 && calculateIds.size() > 0) {
                    calculateIds = calculateIds.subList(0, 1);
                }
                this.getLogger().info("real calculate application ids: " + Utils.toString(calculateIds));
                Date now = new Date();
                int currentDay = TimeUtils.convertDateToCalendar((Date)now).get(5);
                if (TimeUtils.monthsDelta((Date)this.month, (Date)now) > 0 || this.calculateOnlyLogSessions) {
                    this.getLogger().info("executing calulatePastMonth");
                    this.calulatePastMonth(calculateIds);
                    this.getLogger().info("calulatePastMonth end");
                    break block21;
                }
                Object object = mutex;
                synchronized (object) {
                    if (this.day == null || this.day < currentDay) {
                        this.getLogger().info("executing calculateBeforeCurrentDay");
                        this.calculateBeforeCurrentDay(calculateIds, currentDay);
                        this.getLogger().info("calculateBeforeCurrentDay end");
                    }
                    try {
                        this.getLogger().info("stoping calculation");
                        this.stopCalculation(availableIds);
                        this.getLogger().info("calculation stoped");
                        this.getLogger().info("recalculateCurrentDay");
                        this.calculateCurrentDay(calculateIds, currentDay);
                        this.getLogger().info("recalculateCurrentDay stoped");
                    }
                    finally {
                        this.getLogger().info("continue calculate");
                        this.startCalculation(availableIds);
                        InetAllTariffMaxTraffAndRangeUpdate event = new InetAllTariffMaxTraffAndRangeUpdate(this.moduleId);
                        EventProcessor.getInstance().publish((Event)event);
                    }
                    this.getLogger().info("end of recalculate");
                }
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    protected void calulatePastMonth(List<Integer> appIds) throws InterruptedException, ExecutionException, BGException {
        AccountingEventSender sender = new AccountingEventSender((List)appIds){

            @Override
            protected QueueEvent createEvent(int count, Integer aplicationId, int idx, int requestIndex) {
                return new InetRecalculateBaseEvent(InetRecalculator.this.moduleId, InetRecalculator.this.month, InetRecalculator.this.day, aplicationId, count, idx, InetRecalculator.this.cids, requestIndex);
            }
        };
        sender.send(true);
    }

    protected void calculateCurrentDay(List<Integer> appIds, final int currentDay) throws InterruptedException, ExecutionException, BGException {
        AccountingEventSender sender = new AccountingEventSender(appIds){

            @Override
            protected QueueEvent createEvent(int count, Integer aplicationId, int idx, int requestIndex) {
                return new InetRecalculateCurrentDayEvent(InetRecalculator.this.moduleId, InetRecalculator.this.month, (Integer)currentDay, aplicationId, count, idx, InetRecalculator.this.cids, requestIndex);
            }
        };
        sender.send(true);
    }

    protected void stopCalculation(List<Integer> appIds) throws InterruptedException, ExecutionException, BGException {
        AccountingEventSender sender = new AccountingEventSender((List)appIds){

            @Override
            protected QueueEvent createEvent(int count, Integer aplicationId, int idx, int requestIndex) {
                return new TarrificationSuspendEvent(InetRecalculator.this.moduleId, aplicationId);
            }
        };
        sender.send(false);
    }

    protected void startCalculation(List<Integer> appIds) throws InterruptedException, ExecutionException, BGException {
        AccountingEventSender sender = new AccountingEventSender((List)appIds){

            @Override
            protected QueueEvent createEvent(int count, Integer aplicationId, int idx, int requestIndex) {
                return new TarrificationContinueEvent(InetRecalculator.this.moduleId, aplicationId);
            }
        };
        sender.send(false);
    }

    protected void calculateBeforeCurrentDay(List<Integer> appIds, final int currentDay) throws InterruptedException, ExecutionException, BGException {
        AccountingEventSender sender = new AccountingEventSender(appIds){

            @Override
            protected QueueEvent createEvent(int count, Integer aplicationId, int idx, int requestIndex) {
                InetRecalculateBaseEvent event = InetRecalculator.this.day == null ? new InetRecalculateCurrentMonthBeforeDayEvent(InetRecalculator.this.moduleId, InetRecalculator.this.month, currentDay, aplicationId, count, idx, InetRecalculator.this.cids, requestIndex) : new InetRecalculateDayInCurrentMonthEvent(InetRecalculator.this.moduleId, InetRecalculator.this.month, InetRecalculator.this.day, aplicationId, count, idx, InetRecalculator.this.cids, requestIndex);
                return event;
            }
        };
        sender.send(true);
    }

    public InetRecalculator init(Setup setup) throws Exception {
        super.init(setup);
        try (Connection con = setup.getDBConnectionFromPool();){
            String ids = new ModuleSetup(con, this.moduleId).get("accounting.application.ids", "");
            this.aplicationIds = Utils.toIntegerList((String)ids);
        }
        return this;
    }

    abstract class AccountingEventSender {
        List<Integer> aplicationIds;

        public AccountingEventSender(List<Integer> aplicationIds) {
            this.aplicationIds = aplicationIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(boolean waitFutures) throws InterruptedException, ExecutionException, BGException {
            HashSet<Integer> indexSet = new HashSet<Integer>();
            try {
                int count = this.aplicationIds.size();
                ArrayList<FutureResult> futureList = new ArrayList<FutureResult>();
                InetRecalculator.this.answers.clear();
                for (int i = 0; i < this.aplicationIds.size(); ++i) {
                    Integer applicationId = this.aplicationIds.get(i);
                    int idx = i;
                    int requestIndex = this.newRequestIndex();
                    indexSet.add(requestIndex);
                    if (waitFutures) {
                        EventProcessor.getInstance().addListener((EventListener)InetRecalculator.this.respProcessor, RecalculateResponseEvent.class, InetRecalculator.this.moduleId, "requestIndex=" + requestIndex);
                        FutureResult future = new FutureResult();
                        Map<Integer, FutureResult<Boolean>> map = InetRecalculator.this.answers.get(applicationId);
                        if (map == null) {
                            map = new HashMap<Integer, FutureResult<Boolean>>();
                            InetRecalculator.this.answers.put(applicationId, map);
                        }
                        map.put(requestIndex, (FutureResult<Boolean>)future);
                        futureList.add(future);
                    }
                    InetRecalculator.this.getLogger().info("send request to applicationId=" + applicationId + ", requestIndex = " + requestIndex);
                    QueueEvent event = this.createEvent(count, applicationId, idx, requestIndex);
                    try {
                        event = (QueueEvent)EventProcessor.getInstance().request((Event)event, 600000L);
                        if (event != null) continue;
                        throw new BGException("Timeout request ");
                    }
                    catch (BGException e) {
                        InetRecalculator.this.getLogger().error("", (Throwable)e);
                    }
                }
                if (waitFutures) {
                    boolean ok = ConcurrentUtils.awaitFutures(futureList, (long)20L, (TimeUnit)TimeUnit.HOURS);
                    for (FutureResult future : futureList) {
                        ok &= ((Boolean)future.get()).booleanValue();
                    }
                    if (!ok) {
                        throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430 acconting-\u0441\u0435\u0440\u0432\u0435\u0440\u0435");
                    }
                }
            }
            finally {
                if (waitFutures) {
                    for (Integer requestIndex : indexSet) {
                        EventProcessor.getInstance().removeListener((EventListener)InetRecalculator.this.respProcessor, RecalculateResponseEvent.class, InetRecalculator.this.moduleId, "requestIndex=" + requestIndex);
                    }
                }
            }
        }

        private Integer newRequestIndex() {
            return requestIndex.incrementAndGet();
        }

        protected abstract QueueEvent createEvent(int var1, Integer var2, int var3, int var4);
    }
}

