/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ru.bitel.common.util.Matcher;
import ru.bitel.common.util.RangeSet2;
import ru.bitel.common.util.Ranger;

public class SegmentedRangeSet<K, C, R> {
    protected final Class<R> clazz;
    protected final Class<C> rangerClass;
    protected final Comparator<C> comparator;
    protected final Ranger<R, C> ranger;
    protected final ConcurrentMap<K, RangeSet2<R, C>> segments;
    protected final RangeSet2<R, C> notSegmented;
    protected final Segmenter<K, R> segmenter;

    protected SegmentedRangeSet(Class<R> clazz, Class<C> rangerClass, Comparator<C> comparator, Ranger<R, C> ranger, Segmenter<K, R> segmenter) {
        this.clazz = clazz;
        this.rangerClass = rangerClass;
        this.comparator = comparator;
        this.ranger = ranger;
        this.segmenter = segmenter;
        this.segments = new ConcurrentHashMap<K, RangeSet2<R, C>>();
        this.notSegmented = new RangeSet2<R, C>(ranger, comparator, clazz, rangerClass);
    }

    public int size() {
        int size = 0;
        for (RangeSet2 rangeSet : this.segments.values()) {
            size += rangeSet.size();
        }
        return size + this.notSegmented.size();
    }

    public void add(R range) {
        K key = this.segmenter.segmentKey(range);
        if (key != null) {
            RangeSet2<R, C> newRangeSet;
            RangeSet2<R, C> rangeSet = (RangeSet2<R, C>)this.segments.get(key);
            if (rangeSet == null && (rangeSet = this.segments.putIfAbsent(key, newRangeSet = new RangeSet2<R, C>(this.ranger, this.comparator, this.clazz, this.rangerClass))) == null) {
                rangeSet = newRangeSet;
            }
            rangeSet.add(range);
        } else {
            this.notSegmented.add(range);
        }
    }

    protected void addAll(List<R> ranges) {
        Object rangeSet;
        K key;
        HashSet<R> notSegmented = new HashSet<R>();
        HashMap<K, HashSet<R>> segments = new HashMap<K, HashSet<R>>();
        for (R r : ranges) {
            key = this.segmenter.segmentKey(r);
            if (key != null) {
                rangeSet = (HashSet<R>)segments.get(key);
                if (rangeSet == null) {
                    rangeSet = new HashSet<R>();
                    segments.put(key, (HashSet<R>)rangeSet);
                }
                rangeSet.add(r);
                continue;
            }
            notSegmented.add(r);
        }
        this.notSegmented.addAll(notSegmented);
        for (Map.Entry entry : segments.entrySet()) {
            RangeSet2<R, C> newRangeSet;
            key = entry.getKey();
            rangeSet = (RangeSet2)this.segments.get(key);
            if (rangeSet == null && (rangeSet = this.segments.putIfAbsent(key, newRangeSet = new RangeSet2<R, C>(this.ranger, this.comparator, this.clazz, this.rangerClass))) == null) {
                rangeSet = newRangeSet;
            }
            ((RangeSet2)rangeSet).addAll((Set)entry.getValue());
        }
    }

    public void remove(R range) {
        K key = this.segmenter.segmentKey(range);
        if (key != null) {
            RangeSet2 rangeSet = (RangeSet2)this.segments.get(key);
            if (rangeSet != null) {
                rangeSet.remove(range);
            }
        } else {
            this.notSegmented.remove(range);
        }
    }

    protected R get(K segment, C key) {
        Object result;
        RangeSet2 rangeSet = (RangeSet2)this.segments.get(segment);
        if (rangeSet != null && (result = rangeSet.search(key)) != null) {
            return result;
        }
        return this.notSegmented.search(key);
    }

    protected R get(K segmentKey, C key, Matcher<R> matcher) {
        R result;
        RangeSet2 rangeSet = (RangeSet2)this.segments.get(segmentKey);
        if (rangeSet != null && (result = rangeSet.get(key, matcher)) != null) {
            return result;
        }
        return this.notSegmented.get(key, matcher);
    }

    protected List<R> listContains(K segmentKey, C key) {
        RangeSet2 rangeSet = (RangeSet2)this.segments.get(segmentKey);
        if (rangeSet != null) {
            return rangeSet.listContains(key);
        }
        return this.notSegmented.listContains(key);
    }

    public static interface Segmenter<K, R> {
        public K segmentKey(R var1);
    }
}

