/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.flow;

import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.SFlowArray;
import ru.bitel.common.Utils;

public class SFlowRecord
extends Data {
    private static Logger logger = LogManager.getLogger();
    private static final int NFT_ETHHDR_SIZ = 14;
    private static final int NFT_IP_HEADER_SIZE = 20;
    private static final int NFT_MIN_SIZ = 34;
    private static final int NFT_MAX_8023_LEN = 1500;
    int sFlowVersion;

    private static final long getUnsignedInt(ByteBuffer data) {
        return (long)data.getInt() & 0xFFFFFFFFL;
    }

    private static final short getUnsignedByte(ByteBuffer data) {
        return (short)(data.get() & 0xFF);
    }

    private static final int getUnsignedShort(ByteBuffer data) {
        return data.getShort() & 0xFFFF;
    }

    public void setMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public void fillData(ByteBuffer data) {
        this.octets = 0L;
        this.packets = 0L;
        this.first = 0L;
        this.last = 0L;
        this.nextHop = 0L;
        this.inputInterface = 0;
        this.outputInterface = 0;
        this.srcAddress.address = this.ipv4SrcAddress;
        this.srcAddress.clear();
        this.srcPort = 0;
        this.dstAddress.address = this.ipv4DstAddress;
        this.dstAddress.clear();
        this.dstPort = 0;
        this.diffServ = 0;
        this.protocol = 0;
        int formatSampleData = data.getInt();
        data.getInt();
        switch (formatSampleData) {
            case 1: 
            case 3: {
                boolean expanded = formatSampleData == 3;
                data.getInt();
                if (expanded) {
                    data.getInt();
                    data.getInt();
                } else {
                    data.getInt();
                }
                this.packets = SFlowRecord.getUnsignedInt(data);
                data.getInt();
                data.getInt();
                if (expanded) {
                    data.getInt();
                    this.inputInterface = data.getInt();
                    data.getInt();
                    this.outputInterface = data.getInt();
                } else {
                    this.inputInterface = (int)(SFlowRecord.getUnsignedInt(data) & 0x3FFFFFFFL & 0xFFFFL);
                    this.outputInterface = (int)(SFlowRecord.getUnsignedInt(data) & 0x3FFFFFFFL & 0xFFFFL);
                }
                long recordsCount = SFlowRecord.getUnsignedInt(data);
                int sampleCounter = 0;
                for (long recordNum = 0L; recordNum < recordsCount; ++recordNum) {
                    data.limit(data.capacity());
                    int formatFlowData = data.getInt();
                    int flowDataLength = data.getInt();
                    int sampleStartPos = data.position();
                    switch (formatFlowData) {
                        case 1: {
                            int typeLen;
                            int offsetToIPV4 = 0;
                            int headerProtocol = data.getInt();
                            long sampledPacketSize = SFlowRecord.getUnsignedInt(data);
                            long stripped = this.sFlowVersion >= 5 ? SFlowRecord.getUnsignedInt(data) : 0L;
                            int headerLen = data.getInt();
                            int startPos = data.position();
                            data.limit(startPos + headerLen);
                            if (headerProtocol == 1) {
                                byte version;
                                logger.debug("Ethernet header");
                                if (headerLen < 14) break;
                                byte[] dstMAC = new byte[6];
                                byte[] srcMAC = new byte[6];
                                data.get(dstMAC);
                                data.get(srcMAC);
                                typeLen = SFlowRecord.getUnsignedShort(data);
                                if (typeLen == 33024) {
                                    SFlowRecord.getUnsignedShort(data);
                                    typeLen = SFlowRecord.getUnsignedShort(data);
                                }
                                if (headerLen < 34) {
                                    logger.debug("not enough for an IPv4 header");
                                    break;
                                }
                                if (typeLen == 512 || typeLen == 513 || typeLen == 1536) {
                                    logger.debug("IPX");
                                    break;
                                }
                                if (typeLen <= 1500) {
                                    data.mark();
                                    if (data.get() == -86 && data.get() == -86 && data.get() == 3) {
                                        if (data.get() != 0 || data.get() != 0 || data.get() != 0) {
                                            logger.debug("No further decode for vendor-specific protocol (VSNAP_OUI)");
                                            break;
                                        }
                                        typeLen = SFlowRecord.getUnsignedShort(data);
                                    } else if (data.reset() != null && data.get() == 6 && data.get() == 6 && data.get() == 1) {
                                        typeLen = 2048;
                                    } else {
                                        logger.debug("assume 802.3+802.2 header, no SNAP");
                                        break;
                                    }
                                }
                                data.mark();
                                if (typeLen == 2048) {
                                    logger.debug("IPV4");
                                    if (data.limit() - data.position() < 20) {
                                        logger.debug("Small header size");
                                        break;
                                    }
                                    version = data.get();
                                    if (version >> 4 != 4) {
                                        logger.debug("not version 4");
                                        break;
                                    }
                                    if ((version & 0xF) < 5) {
                                        logger.debug("not IP (hdr len must be 5 quads or more)");
                                        break;
                                    }
                                    offsetToIPV4 = data.position() - startPos;
                                    headerProtocol = 11;
                                }
                                if (typeLen == 34525) {
                                    version = data.get();
                                    if (version >> 4 != 6) break;
                                    offsetToIPV4 = data.position() - startPos;
                                    headerProtocol = 12;
                                }
                                data.reset();
                            } else {
                                typeLen = 0;
                            }
                            block8 : switch (headerProtocol) {
                                case 11: {
                                    logger.debug("IP header");
                                    SFlowRecord.getUnsignedByte(data);
                                    this.diffServ = data.get();
                                    SFlowRecord.getUnsignedShort(data);
                                    SFlowRecord.getUnsignedShort(data);
                                    int fragOff = SFlowRecord.getUnsignedShort(data);
                                    data.get();
                                    short protocol = SFlowRecord.getUnsignedByte(data);
                                    this.protocol = protocol;
                                    data.getShort();
                                    data.get(this.srcAddress.address);
                                    data.get(this.dstAddress.address);
                                    if ((fragOff &= 0x1FFF) > 0 || headerLen < 28) break;
                                    switch (protocol) {
                                        case 1: {
                                            break block8;
                                        }
                                        case 6: {
                                            this.srcPort = SFlowRecord.getUnsignedShort(data);
                                            this.dstPort = SFlowRecord.getUnsignedShort(data);
                                            break block8;
                                        }
                                        case 17: {
                                            this.srcPort = SFlowRecord.getUnsignedShort(data);
                                            this.dstPort = SFlowRecord.getUnsignedShort(data);
                                            this.octets = SFlowRecord.getUnsignedShort(data);
                                            data.getShort();
                                            break block8;
                                        }
                                    }
                                    break;
                                }
                                case 12: {
                                    if (!logger.isDebugEnabled()) break;
                                    logger.debug("No decode header protocol=" + headerProtocol);
                                    break;
                                }
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 13: {
                                    if (!logger.isDebugEnabled()) break;
                                    logger.debug("No decode header protocol=" + headerProtocol);
                                    break;
                                }
                                default: {
                                    if (!logger.isDebugEnabled()) break;
                                    logger.debug("Undefined header protocol=" + headerProtocol + ", type=" + typeLen);
                                }
                            }
                            if (this.octets == 0L) {
                                this.octets = sampledPacketSize - stripped - (long)offsetToIPV4;
                            }
                            data.position(data.limit());
                            data.limit(data.capacity());
                            break;
                        }
                        case 3: {
                            long sampledPacketSize = SFlowRecord.getUnsignedInt(data);
                            this.protocol = data.getInt();
                            data.get(this.srcAddress.address);
                            data.get(this.dstAddress.address);
                            this.srcPort = data.getInt();
                            this.dstPort = data.getInt();
                            data.getInt();
                            this.diffServ = data.getInt();
                            this.octets = sampledPacketSize;
                            break;
                        }
                        case 1002: {
                            int ipv = data.getInt();
                            if (ipv == 1) {
                                this.nextHop = SFlowRecord.getUnsignedInt(data);
                            } else {
                                data.get(new byte[16]);
                            }
                            data.getInt();
                            data.getInt();
                        }
                        default: {
                            data.position(data.position() + flowDataLength);
                        }
                    }
                    data.position(sampleStartPos + flowDataLength);
                }
                this.octets *= this.packets;
                if (!logger.isDebugEnabled()) break;
                logger.debug(++sampleCounter + " " + this.toString());
            }
        }
    }

    public static void main(String[] args) {
        byte[] data = Utils.stringToBytes((String)"0000000500000001c0a872200000000000000ae903d216a00000000200000001000000ac00000b6902000018000003e800289e7000000000000000183fffffff0000000100000001000000800000000100000072000000040000006effffffffffff0015173dca298100000a080600010800060400010015173dca29c0a80aeb000000000000c0a80a850000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000150000000000000001000000ac00000b6a02000018000003e80028a25800000000000000183fffffff0000000100000001000000800000000100000072000000040000006effffffffffff0015173dca298100000a080600010800060400010015173dca29c0a80aeb000000000000c0a80aac00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", null);
        SFlowArray array = new SFlowArray(30);
        System.out.println(array.parsePacket(ByteBuffer.wrap(data), System.currentTimeMillis()));
        for (int i = 0; i < array.size; ++i) {
            System.out.println(((SFlowRecord[])array.array)[i]);
        }
    }

    class SFLOW_SAMPLE_FORMAT {
        public static final int FLOW_SAMPLE = 1;
        public static final int COUNTERS_SAMPLE = 2;
        public static final int FLOW_SAMPLE_EXPANDED = 3;
        public static final int COUNTERS_SAMPLE_EXPANDED = 4;

        SFLOW_SAMPLE_FORMAT(SFlowRecord this$0) {
        }
    }

    class PACKET_HEADER_PROTOCOL {
        public static final int HEADER_ETHERNET_ISO8023 = 1;
        public static final int HEADER_ISO88024_TOKENBUS = 2;
        public static final int HEADER_ISO88025_TOKENRING = 3;
        public static final int HEADER_FDDI = 4;
        public static final int HEADER_FRAME_RELAY = 5;
        public static final int HEADER_X25 = 6;
        public static final int HEADER_PPP = 7;
        public static final int HEADER_SMDS = 8;
        public static final int HEADER_AAL5 = 9;
        public static final int HEADER_AAL5_IP = 10;
        public static final int HEADER_IPv4 = 11;
        public static final int HEADER_IPv6 = 12;
        public static final int HEADER_MPLS = 13;

        PACKET_HEADER_PROTOCOL(SFlowRecord this$0) {
        }
    }

    class SFLOW_TYPE_TAG {
        public static final int FLOW_HEADER = 1;
        public static final int FLOW_ETHERNET = 2;
        public static final int FLOW_IPV4 = 3;
        public static final int FLOW_IPV6 = 4;
        public static final int FLOW_EX_SWITCH = 1001;
        public static final int FLOW_EX_ROUTER = 1002;
        public static final int FLOW_EX_GATEWAY = 1003;
        public static final int FLOW_EX_USER = 1004;
        public static final int FLOW_EX_URL = 1005;
        public static final int FLOW_EX_MPLS = 1006;
        public static final int FLOW_EX_NAT = 1007;
        public static final int FLOW_EX_MPLS_TUNNEL = 1008;
        public static final int FLOW_EX_MPLS_VC = 1009;
        public static final int FLOW_EX_MPLS_FTN = 1010;
        public static final int FLOW_EX_MPLS_LDP_FEC = 1011;
        public static final int FLOW_EX_VLAN_TUNNEL = 1012;
        public static final int SFLFLOW_EX_PROCESS = 17612803;

        SFLOW_TYPE_TAG(SFlowRecord this$0) {
        }
    }
}

