/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.errorlog.common.bean;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.common.bean.ErrorMessage;

public class AlarmErrorMessage
extends ErrorMessage {
    private String key;
    private Throwable exception;
    private boolean isSendToEmail = true;
    private boolean isSendToLog = false;
    private boolean dumpStackTrace = false;

    public AlarmErrorMessage(String key, String subject, String text) {
        super(subject, text);
        this.key = key;
    }

    public AlarmErrorMessage(String key, String subject, String text, Throwable ex) {
        this(key, subject, text);
        this.exception = ex;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public String getText() {
        StringBuilder result = new StringBuilder(this.text);
        if (this.exception != null) {
            result.append("\n\n");
            result.append(BGException.printStackTraceToString((Throwable)this.exception));
        }
        return result.toString();
    }

    public boolean isSendToEmail() {
        return this.isSendToEmail;
    }

    public void setSendToEmail(boolean isSendToEmail) {
        this.isSendToEmail = isSendToEmail;
    }

    public boolean isSendToLog() {
        return this.isSendToLog;
    }

    public void setSendToLog(boolean isSendToLog) {
        this.isSendToLog = isSendToLog;
    }

    public boolean isDumpStackTrace() {
        return this.dumpStackTrace;
    }

    public void setDumpStackTrace(boolean dumpStackTrace) {
        this.dumpStackTrace = dumpStackTrace;
    }
}

