/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.runner;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.swing.JOptionPane;
import ru.bitel.bgbilling.client.runner.BGClientRunnerDbInfo;
import ru.bitel.bgbilling.client.runner.BGClientRunnerHostnameVerifier;
import ru.bitel.bgbilling.client.runner.BGClientRunnerTrustManager;
import ru.bitel.bgbilling.client.runner.json.JSONArray;
import ru.bitel.bgbilling.client.runner.json.JSONObject;

public class BGClientRunnerUtil {
    public static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static File getLocalSettingsFile() {
        return BGClientRunnerUtil.getLocalFile(System.getProperty("local.setting.file.name", "config"));
    }

    public static File getLocalSettingsDir() {
        String folderName = System.getProperty("local.setting.folder.name", ".bgbilling");
        File file = new File(System.getProperty("user.home") + File.separator + folderName);
        return file;
    }

    public static File getLocalFile(String fileName) {
        try {
            File file = BGClientRunnerUtil.getLocalSettingsDir();
            if (!file.exists() && !file.mkdir()) {
                System.err.println("error create dir " + file.getAbsolutePath());
                BGClientRunnerUtil.showError("\u041d\u0435 \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044e \"" + file.getAbsolutePath() + "\"");
                return null;
            }
            if (file.isDirectory()) {
                if (!(file = new File(String.valueOf(file.getAbsoluteFile()) + File.separator + fileName)).exists()) {
                    file.createNewFile();
                }
                if (file.exists() && file.isFile()) {
                    return file;
                }
                BGClientRunnerUtil.showError("\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u0444\u0430\u0439\u043b\u043e\u043c \"" + file.getAbsolutePath() + "\":\n\u041d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442/\u043d\u0435 \u0444\u0430\u0439\u043b/\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c");
            }
        }
        catch (Exception e) {
            System.err.println("error get local file " + fileName);
            e.printStackTrace();
            BGClientRunnerUtil.showError("\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u0444\u0430\u0439\u043b\u043e\u043c \"" + fileName + "\": " + e.toString());
        }
        return null;
    }

    public static File getUserFolderForFile(String fileName) {
        File file = new File(BGClientRunnerUtil.getLocalSettingsDir().getAbsolutePath() + File.separator + fileName);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static String loadDefaultConfig() throws Exception {
        String config = null;
        URL url = ClassLoader.getSystemResource("config.json");
        if (url != null) {
            config = BGClientRunnerUtil.readFile(new File(url.toURI()));
        }
        return config;
    }

    public static String loadDefaultHttpConfig(String configURL, String defaultConfigURL, boolean anySSL) throws Exception {
        String serverURL = configURL != null ? configURL : System.getProperty("default.config.url", defaultConfigURL);
        String config = null;
        if (!"none".equals(serverURL)) {
            config = BGClientRunnerUtil.doRequest(serverURL, null, "GET", null, anySSL);
        }
        return config;
    }

    public static String loadServersConfig() throws IOException {
        return BGClientRunnerUtil.readFile(BGClientRunnerUtil.getLocalFile("servers.json"));
    }

    public static String doRequest(String serverUrl, String[][] headers, String requestMethod, String outputText, boolean anySSL) throws Exception {
        HttpURLConnection urlConnection = BGClientRunnerUtil.getHttpURLConnection(serverUrl, headers, requestMethod, outputText, anySSL);
        String result = BGClientRunnerUtil.readInputStream(urlConnection.getInputStream());
        urlConnection.disconnect();
        return result;
    }

    public static HttpURLConnection getHttpURLConnection(String serverURL, String[][] headers, String requestMethod, String outputText, boolean anySSL) throws Exception {
        URL url = URI.create(serverURL).toURL();
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        BGClientRunnerUtil.ssl(urlConnection, url, anySSL);
        urlConnection.setConnectTimeout(3000);
        urlConnection.setRequestMethod(requestMethod);
        if (headers != null) {
            for (String[] header : headers) {
                if (header.length <= 1) continue;
                urlConnection.setRequestProperty(header[0], header[1]);
            }
        }
        urlConnection.setDoOutput(outputText != null);
        urlConnection.setDoInput(true);
        if (outputText != null) {
            BGClientRunnerUtil.writeOutputStream(urlConnection.getOutputStream(), outputText);
        }
        urlConnection.connect();
        return urlConnection;
    }

    private static void ssl(HttpURLConnection urlConnection, URL url, boolean anySSL) throws Exception {
        System.out.println("anySSL = " + anySSL + "; protocol = " + url.getProtocol());
        if (anySSL && "https".equalsIgnoreCase(url.getProtocol())) {
            SSLContext sslContext = SSLContext.getInstance(System.getProperty("version.tls", "TLSv1.2"));
            sslContext.init(new KeyManager[0], new TrustManager[]{new BGClientRunnerTrustManager()}, new SecureRandom());
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslContext.getSocketFactory());
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(new BGClientRunnerHostnameVerifier());
        }
    }

    public static String readFile(File file) throws IOException {
        String serversConfig = "";
        if (file != null && file.canRead()) {
            serversConfig = BGClientRunnerUtil.readInputStream(new FileInputStream(file));
        }
        return serversConfig;
    }

    public static void writeOutputStream(OutputStream outputStream, String data) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        bw.write(data.toCharArray());
        bw.close();
    }

    public static String readInputStream(InputStream inputStream) throws IOException {
        StringBuffer serversConfig = new StringBuffer();
        if (inputStream != null) {
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");){
                char[] target = new char[1024];
                int bytes = 0;
                while ((bytes = inputStreamReader.read(target)) > -1) {
                    serversConfig.append(target, 0, bytes);
                }
            }
        }
        return serversConfig.toString();
    }

    public static void saveServersConfig(List<? extends BGClientRunnerDbInfo> serverList, String defaultServerKey, String serversListMode, boolean anySSL) {
        try {
            File file = BGClientRunnerUtil.getLocalFile("servers.json");
            if (file != null && file.canWrite()) {
                JSONObject serversJSONObject = new JSONObject();
                JSONObject paramJSONObject = new JSONObject();
                paramJSONObject.put("defaultServerKey", defaultServerKey);
                paramJSONObject.put("serversListMode", serversListMode);
                paramJSONObject.put("anySSL", String.valueOf(anySSL));
                serversJSONObject.put("param", paramJSONObject);
                JSONArray serversJSONArray = new JSONArray();
                for (BGClientRunnerDbInfo bGClientRunnerDbInfo : serverList) {
                    serversJSONArray.put(bGClientRunnerDbInfo.toJsonObject());
                }
                serversJSONObject.put("servers", serversJSONArray);
                BGClientRunnerUtil.saveFile(file, serversJSONObject.toString(2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveFile(File file, String outText) throws IOException {
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            fileWriter.write(outText);
        }
    }

    public static boolean deleteDir(File dir) {
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (File f : contents) {
                if (Files.isSymbolicLink(f.toPath())) {
                    f.delete();
                    continue;
                }
                BGClientRunnerUtil.deleteDir(f);
            }
        }
        return dir.delete();
    }

    public static String checkUnsupportedClassVersionError(String message) {
        Pattern p = Pattern.compile("UnsupportedClassVersionError.+recent.+version\\s+(?<need>\\d+).+up\\s+to\\s+(?<has>\\d+)");
        Matcher m = p.matcher(message);
        if (m.find()) {
            try {
                int vneed = Integer.parseInt(m.group("need")) - 44;
                int vhas = Integer.parseInt(m.group("has")) - 44;
                return String.format("\u0414\u043b\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f Java %d, \u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f \u043d\u0430 Java %d\n\n%s", vneed, vhas, message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return message;
    }

    public static String randomAlphanumeric(int count) {
        StringBuilder result = new StringBuilder();
        if (count > 0) {
            String sym = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM0987654321";
            Random random = new Random();
            for (int index = 0; index < count; ++index) {
                result.append("qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM0987654321".charAt(random.nextInt("qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM0987654321".length())));
            }
        }
        return result.toString();
    }

    public static void showError(String errortext) {
        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), errortext, "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
    }

    public static String sha256Hex(InputStream data) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] buffer = new byte[1024];
        int read = data.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = data.read(buffer, 0, 1024);
        }
        return BGClientRunnerUtil.bytesToHexString(digest.digest());
    }

    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        char[] chars = new char[bytes.length * 2];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            chars[j++] = HEX[v >>> 4];
            chars[j++] = HEX[v & 0xF];
        }
        return new String(chars);
    }

    public static String sha256Hex(File file) throws Exception {
        try (FileInputStream is = new FileInputStream(file);){
            String string = BGClientRunnerUtil.sha256Hex(is);
            return string;
        }
    }

    public static long bytesToLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes);
        buffer.flip();
        return buffer.getLong();
    }

    public static byte[] getBytes(InputStream inputStream, int len) throws IOException {
        byte[] bytes = new byte[len];
        while (len > 0) {
            int b = inputStream.read(bytes, bytes.length - len, len);
            len -= b;
        }
        return bytes;
    }

    public static boolean isJavaHomeValid(String javaHomePath) {
        File java = Paths.get(javaHomePath, "bin", "java.exe").toFile();
        if (!java.exists()) {
            java = Paths.get(javaHomePath, "bin", "java").toFile();
            return java.exists();
        }
        return true;
    }
}

