/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.client;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.common.Utils;

public class StatusChartPanel
extends JLabel {
    private Color[] colors;
    private LocalDate selectDate = null;
    private int monthCount = 1;
    private int padX = 10;
    private int padY = 10;
    private int rowH = 20;
    private int rowW = 30;
    private int monthW = 130;
    private int dayH = 25;
    private int areaW = 2 * this.padX + this.monthW + 31 * this.rowW;
    private List<StatusData> statusDatas = new ArrayList<StatusData>();
    private LocalDate now;
    private LocalDate from = this.now = LocalDate.now().withDayOfMonth(1);
    private LocalDate to = this.now;

    public StatusChartPanel() {
        this.setOpaque(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                StatusChartPanel.this.calculateDay(event.getPoint());
            }
        });
    }

    private void calculateDay(Point point) {
        LocalDate date;
        int row = point.y - this.padY - this.dayH;
        if ((row = (row - row % this.rowH) / this.rowH) < 0) {
            return;
        }
        int day = point.x - this.padX - this.monthW;
        if (day < 1) {
            return;
        }
        day = (day - day % this.rowW) / this.rowW + 1;
        if (!this.statusDatas.isEmpty() && (date = this.now.minusMonths(row)).lengthOfMonth() >= day) {
            this.selectDate = date.withDayOfMonth(day);
            StatusData statusData = this.statusDatas.stream().filter(a -> !this.selectDate.isBefore(a.from) && !this.selectDate.isAfter(a.to)).findFirst().orElse(null);
            this.firePropertyChange("selectDate", null, statusData);
            this.repaint();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.areaW, this.monthCount * this.rowH + this.dayH + 2 * this.padY);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        return new Dimension(Math.max(dim.width, this.areaW), Math.max(dim.height, this.monthCount * this.rowH + this.dayH + 2 * this.padY));
    }

    public void setData(List<BGUTableRowData> data, Color[] colors) {
        this.colors = colors;
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        this.statusDatas = data.stream().map(a -> {
            String[] period = a.optValue("period").orElse("").split("-");
            if (period == null || period.length != 2) {
                return null;
            }
            StatusData statusData = new StatusData();
            statusData.from = LocalDate.parse(period[0], dateFormat);
            statusData.to = period[1].length() < 10 ? LocalDate.now() : LocalDate.parse(period[1], dateFormat);
            statusData.status = Utils.parseInt((String)a.optValue("statusId").orElse("0"));
            statusData.statusTitle = a.optValue("status").orElse("?");
            statusData.comment = a.optValue("comment").orElse("");
            return statusData;
        }).filter(a -> a != null).toList();
        this.to = this.statusDatas.isEmpty() ? this.now : this.statusDatas.getLast().from;
        this.monthCount = (int)ChronoUnit.MONTHS.between(this.to, this.now) + 2;
        this.revalidate();
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Color bgColor = Color.WHITE;
        Dimension dim = this.getPreferredSize();
        g.clearRect(0, 0, dim.width, this.monthCount * this.rowH + this.dayH + 2 * this.padY);
        g.setColor(bgColor);
        g.fillRect(0, 0, dim.width, this.monthCount * this.rowH + this.dayH + 2 * this.padY);
        g.setColor(Color.BLACK);
        g.setFont(this.getFont().deriveFont(1));
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("LLLL YYYY");
        int y = this.padY + this.dayH;
        for (int d = 1; d < 32; ++d) {
            String strDay = d < 10 ? "0" + d : "" + d;
            int strW = g.getFontMetrics().charsWidth(strDay.toCharArray(), 0, strDay.length());
            g.drawString(strDay, this.padX + this.monthW + (d - 1) * this.rowW + (this.rowW - strW) / 2, y - 4);
        }
        y += this.rowH;
        this.from = this.now;
        int selectedX = -1;
        int selectedY = -1;
        LocalDate stop = this.to.minusMonths(1L).withDayOfMonth(1);
        while (this.from.isAfter(stop)) {
            String monthYear = dateFormat.format(this.from);
            int strW = g.getFontMetrics().charsWidth(monthYear.toCharArray(), 0, monthYear.length());
            g.setColor(Color.BLACK);
            g.drawString(monthYear, this.padX + (this.monthW - strW) / 2, y - 4);
            for (int d = 0; d < this.from.lengthOfMonth(); ++d) {
                LocalDate date = this.from.withDayOfMonth(d + 1);
                int status = this.statusDatas.stream().filter(a -> !date.isBefore(a.from) && !date.isAfter(a.to)).findFirst().map(a -> a.status).orElse(-1);
                g.setColor(status > -1 ? this.colors[status] : bgColor);
                g.fillRect(this.padX + this.monthW + d * this.rowW, y - this.rowH, this.rowW, this.rowH);
                g.setColor(Color.BLACK);
                g.drawRect(this.padX + this.monthW + d * this.rowW, y - this.rowH, this.rowW, this.rowH);
                if (this.selectDate == null || !date.isEqual(this.selectDate)) continue;
                selectedX = this.padX + this.monthW + d * this.rowW;
                selectedY = y - this.rowH;
            }
            y += this.rowH;
            this.from = this.from.minusMonths(1L);
        }
        if (selectedX > 0) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke stroke = g2.getStroke();
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawRect(selectedX - 1, selectedY - 1, this.rowW + 2, this.rowH + 2);
            g2.setStroke(stroke);
        }
    }

    public static class StatusData {
        public LocalDate from;
        public LocalDate to;
        public int status;
        public String statusTitle;
        public String comment;
    }
}

