/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.basic.server.action.web;

import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPasswordLogItem;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractPasswordChangedEvent;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractPasswordLogDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ActionPassword
extends AbstractAction {
    public ActionPassword() {
        super("contract");
    }

    @Override
    public void execute() throws Exception {
        this.setResultParam("pageTitle", this.getPageTitle(4, this.moduleName));
        this.setResultParam("jspPage", "contract/password.jsp");
    }

    public void log() throws Exception {
        ContractPasswordLogDao contractPasswordLogDao = new ContractPasswordLogDao(this.con);
        SearchResult<ContractPasswordLogItem> searchResult = new SearchResult<ContractPasswordLogItem>(new Page(1, 15));
        searchResult.setSort(new String[]{"lastUpdate:DESC"});
        contractPasswordLogDao.searchContractPasswordLogItemByContractId(searchResult, this.contractId);
        this.setResultParam("logList", searchResult.getList());
        this.setResultParam("userMap", UserMap.getMap());
        this.requestDispatcher(this.moduleName, "password_log");
    }

    public void password() throws BGException {
        block14: {
            String pswd1 = this.context.getRequest().getParameter("pswd1");
            String pswd2 = this.context.getRequest().getParameter("pswd2");
            try {
                if (pswd1 == null || pswd2 == null) break block14;
                if (!pswd1.equals(pswd2)) {
                    throw new BGMessageException("\u041f\u0430\u0440\u043e\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442!");
                }
                int passwordMin = PswdGen.getPasswordLengthMin((ParameterMap)this.setup);
                int passwordMax = PswdGen.getPasswordLengthMax((ParameterMap)this.setup);
                String passwordChars = PswdGen.getPasswordChars((ParameterMap)this.setup);
                String pswd = pswd1.trim();
                if (Utils.isEmptyString(pswd)) {
                    throw new BGMessageException("\u0414\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043e\u0442 " + passwordMin + " \u0434\u043e " + passwordMax + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432!");
                }
                if (pswd.length() < passwordMin || pswd.length() > passwordMax) {
                    throw new BGMessageException("\u0414\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043e\u0442 " + passwordMin + " \u0434\u043e " + passwordMax + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432!");
                }
                if (!PswdGen.checkChars((String)pswd, (String)passwordChars)) {
                    throw new BGMessageException("\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0438\u0437 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432: " + passwordChars);
                }
                try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
                    ContractPasswordLogDao contractPasswordLogDao = new ContractPasswordLogDao(this.con);
                    if (contractDao.updatePassword(this.contractId, pswd1, pswd2, false)) {
                        EventProcessor.getInstance().publish(new ContractPasswordChangedEvent(this.userId, this.contractId, pswd1));
                        contractPasswordLogDao.addContractPasswordLogItem(new ContractPasswordLogItem().setDatetime(new Date()).setContractId(this.contractId).setUserId(-1));
                        this.setResultParam("status", "ok");
                    }
                }
                catch (Exception ex) {
                    this.setResultParam("error", ex.getMessage());
                }
            }
            catch (Exception ex) {
                this.setResultParam("error", ex.getMessage());
            }
        }
        this.requestDispatcher(this.moduleName, "password_form");
    }
}

