/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.flowtools;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.bitel.bgbilling.kernel.network.flow.NetFlowRecord;

public final class FlowToolsLogRecord
extends NetFlowRecord {
    @Override
    public void fillData(ByteBuffer byteBuffer, int position) {
        this.srcAddress.address = this.ipv4SrcAddress;
        this.dstAddress.address = this.ipv4DstAddress;
        byteBuffer.position(position);
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            byteBuffer.get(this.srcAddress.address);
            byteBuffer.get(this.dstAddress.address);
        } else {
            int i;
            int size = this.srcAddress.address.length;
            for (i = 0; i < size; ++i) {
                this.srcAddress.address[i] = byteBuffer.get(position + 3 - i);
            }
            size = this.dstAddress.address.length;
            for (i = 0; i < size; ++i) {
                this.dstAddress.address[i] = byteBuffer.get(position + 7 - i);
            }
        }
        this.nextHop = (long)byteBuffer.getInt(position + 8) & 0xFFFFFFFFL;
        this.inputInterface = byteBuffer.getShort(position + 12) & 0xFFFF;
        this.outputInterface = byteBuffer.getShort(position + 14) & 0xFFFF;
        this.packets = (long)byteBuffer.getInt(position + 16) & 0xFFFFFFFFL;
        this.octets = (long)byteBuffer.getInt(position + 20) & 0xFFFFFFFFL;
        this.first = (long)byteBuffer.getInt(position + 24) & 0xFFFFFFFFL;
        this.last = (long)byteBuffer.getInt(position + 28) & 0xFFFFFFFFL;
        this.srcPort = byteBuffer.getShort(position + 32) & 0xFFFF;
        this.dstPort = byteBuffer.getShort(position + 34) & 0xFFFF;
        this.protocol = byteBuffer.get(position + 36) & 0xFF;
        this.diffServ = byteBuffer.get(position + 37) & 0xFF;
    }
}

