/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectParamType;

public class ObjectParamTypeDao {
    private Connection con;
    private static final String TABLE_NAME = "object_type_param";

    public ObjectParamTypeDao(Connection con) {
        this.con = con;
    }

    public List<ObjectParamType> getTypeParamList(int typeId) throws Exception {
        ArrayList<ObjectParamType> result = new ArrayList<ObjectParamType>();
        String query = "SELECT * FROM object_type_param WHERE type_id=? ORDER BY pos";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, typeId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getTypeParamFromRs(rs));
                }
            }
        }
        return result;
    }

    public void addTypeParam(ObjectParamType typeParam) throws Exception {
        String query = "SELECT MAX(pos) FROM object_type_param WHERE type_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, typeParam.getTypeId());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    typeParam.setPos(rs.getInt(1) + 1);
                }
            }
        }
        query = "INSERT INTO object_type_param SET type_id=?, param_id=?, pos=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, typeParam.getTypeId());
            ps.setInt(2, typeParam.getParamId());
            ps.setInt(3, typeParam.getPos());
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void deleteTypeParam(ObjectParamType typeParam) throws Exception {
        String query = "DELETE FROM object_type_param WHERE type_id=? AND param_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, typeParam.getTypeId());
            ps.setInt(2, typeParam.getParamId());
            ps.executeUpdate();
        }
    }

    public void moveUp(ObjectParamType typeParam) throws Exception {
        this.setTypeParamPos(typeParam);
        ObjectParamType neighbor = this.getNearestTypeParam(typeParam, true);
        if (neighbor != null) {
            this.exchangePosition(typeParam, neighbor);
        }
    }

    public void moveDown(ObjectParamType typeParam) throws Exception {
        this.setTypeParamPos(typeParam);
        ObjectParamType neighbor = this.getNearestTypeParam(typeParam, false);
        if (neighbor != null) {
            this.exchangePosition(typeParam, neighbor);
        }
    }

    private void exchangePosition(ObjectParamType typeParam1, ObjectParamType typeParam2) throws Exception {
        String query = "UPDATE object_type_param SET pos=? WHERE type_id=? AND param_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, typeParam2.getPos());
            ps.setInt(2, typeParam1.getTypeId());
            ps.setInt(3, typeParam1.getParamId());
            ps.executeUpdate();
            ps.setInt(1, typeParam1.getPos());
            ps.setInt(2, typeParam2.getTypeId());
            ps.setInt(3, typeParam2.getParamId());
            ps.executeUpdate();
        }
    }

    private void setTypeParamPos(ObjectParamType typeParam) throws Exception {
        String query = "SELECT pos FROM object_type_param WHERE type_id=? AND param_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, typeParam.getTypeId());
            ps.setInt(2, typeParam.getParamId());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    typeParam.setPos(rs.getInt(1));
                }
            }
        }
    }

    private ObjectParamType getNearestTypeParam(ObjectParamType typeParam, boolean top) throws Exception {
        ObjectParamType result = null;
        String query = "SELECT * FROM object_type_param WHERE type_id=? AND pos" + (top ? "<" : ">") + "? ORDER BY pos" + (top ? " DESC" : "") + " LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, typeParam.getTypeId());
            ps.setInt(2, typeParam.getPos());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getTypeParamFromRs(rs);
                }
            }
        }
        return result;
    }

    private ObjectParamType getTypeParamFromRs(ResultSet rs) throws SQLException {
        return new ObjectParamType().setTypeId(rs.getInt("type_id")).setParamId(rs.getInt("param_id")).setPos(rs.getInt("pos"));
    }
}

