/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractIdTitleComment;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGDialog;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class DialogContractSelect
extends BGDialog
implements ActionListener {
    private BGControlPanelListSelect selectPanel;
    private int withoutContract;

    public DialogContractSelect() {
        this(false, false, -1);
    }

    public DialogContractSelect(boolean singleSelect) {
        this(false, singleSelect, -1);
    }

    public DialogContractSelect(boolean okCancel, boolean singleSelect, int withoutContract) {
        this.withoutContract = withoutContract;
        this.setModal(true);
        this.setTitle(singleSelect ? " \u0412\u044b\u0431\u043e\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " : " \u0412\u044b\u0431\u043e\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 ");
        this.jbInit(singleSelect, okCancel);
        this.pack();
        this.moveWindowToCenterScreen();
        this.setData();
    }

    protected void jbInit(boolean singleSelect, boolean okCancel) {
        BGButtonPanel ctrlPanel;
        this.selectPanel = new BGControlPanelListSelect(singleSelect);
        this.selectPanel.setBorder(BorderFactory.createCompoundBorder(new BGTitleBorder(singleSelect ? " \u0414\u043e\u0433\u043e\u0432\u043e\u0440 " : " \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b "), new EmptyBorder(0, 5, 5, 5)));
        this.selectPanel.setPreferredSize(new Dimension(650, 200));
        this.selectPanel.getList().setCellRenderer(new BGCheckListCellRenderer());
        if (okCancel) {
            panel = new BGButtonPanelOkCancel();
            panel.addActionListener(this);
            ctrlPanel = panel;
        } else {
            panel = new BGButtonPanel(BGButtonPanel.GLUE, BGButtonPanel.CLOSE);
            panel.addActionListener(this);
            ctrlPanel = panel;
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)this.selectPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)ctrlPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        BGUList<BGUListItem> list = this.selectPanel.getList();
        list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                int onmask = 2176;
                int offmask = 64;
                if ((event.getModifiersEx() & (onmask | offmask)) == onmask && event.getKeyCode() == 79) {
                    try {
                        String data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                        ArrayList<BGUListItem> items = new ArrayList<BGUListItem>();
                        for (String s : Utils.toList(data, "\\s*[,;\n]\\s*")) {
                            int id = Utils.parseInt(s, 0);
                            if (id <= 0) continue;
                            items.add(new BGUListItem(id, String.valueOf(Utils.parseInt(s, 0))));
                        }
                        DialogContractSelect.this.selectPanel.getList().setData(items);
                        event.consume();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String cmd = actionEvent.getActionCommand();
        if ("help".equals(cmd)) {
            this.openHelp(this.getClass().getName());
        } else {
            this.result = cmd;
            this.setVisible(false);
        }
    }

    @Override
    public void setData() {
        ArrayList<BGUListItem> listItems = new ArrayList<BGUListItem>();
        for (ContractIdTitleComment contract : BGClientBase.getFrame().getTabbedPane().getContracts()) {
            if (this.withoutContract == contract.getId()) continue;
            BGUListItem item = new BGUListItem(contract.getId(), contract.getTitle());
            item.setAttribute("comment", contract.getComment());
            listItems.add(item);
        }
        this.selectPanel.getList().setData(listItems);
    }

    public List<BGUListItem> getId() {
        return this.selectPanel.getList().getSelectedValuesList();
    }

    public String getSingleId() {
        String result = null;
        List<BGUListItem> idList = this.getId();
        if (idList.size() > 0) {
            result = idList.get(0).getIdStr();
        }
        return result;
    }

    public String[] getSelected() {
        StringBuilder conTitle = new StringBuilder();
        StringBuilder listId = new StringBuilder();
        for (BGUListItem item : this.getId()) {
            int cid = item.getId();
            String title = item.toString();
            if (cid <= 0 || title == null) continue;
            if (conTitle.length() > 0) {
                conTitle.append(", ");
            }
            conTitle.append(title);
            if (listId.length() > 0) {
                listId.append(",");
            }
            listId.append(cid);
        }
        return new String[]{listId.toString(), conTitle.toString()};
    }

    public BGControlPanelListSelect getSelectPanel() {
        return this.selectPanel;
    }

    public static class BGCheckListCellRenderer<T extends BGUListItem>
    extends JCheckBox
    implements ListCellRenderer<T> {
        Border m_noFocusBorder = new EmptyBorder(1, 5, 1, 5);

        public BGCheckListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(this.m_noFocusBorder);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setFont(list.getFont());
            this.setText("<html>" + ((IdTitle)value).getGuiTitle() + this.getComment(value) + "</html>");
            T item = value;
            this.setSelected(((BGUListItem)item).isSelected());
            this.setEnabled(list.isEnabled());
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            JLabel idLabel = new JLabel("ID# " + ((Id)value).getId());
            idLabel.setForeground(new Color(0xCCCCCC));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            panel.add((Component)this, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 10, 0));
            panel.add((Component)idLabel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 5, 0));
            return panel;
        }

        private String getComment(T value) {
            Object obj = ((BGUListItem)value).getAttribute("comment");
            if (obj instanceof String) {
                String comment = (String)obj;
                comment = comment.length() > 60 ? comment.substring(0, 60) + "..." : comment;
                return " <span style='color: #888;'><i>(" + comment + ")</i></span>";
            }
            return "";
        }

        public String getId(T value) {
            return ((Id)value).getId() > -1 ? " <span style='color: #ccc;'>[<i>#" + ((Id)value).getId() + "</i>]</span>" : "";
        }
    }
}

