/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.common;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.common.Utils;

public class VersionInfo {
    private Properties properties;

    public VersionInfo setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    private String getProperty(String name) {
        return this.properties != null ? this.properties.getProperty(name, "") : "";
    }

    public String getModuleName() {
        return this.getProperty("name");
    }

    public String getVersion() {
        return this.getProperty("version");
    }

    public String getBuildNumber() {
        String buildNumber = "";
        String zip = this.getProperty("zipName");
        Pattern pattern = Pattern.compile(".*-([0-9]{10})\\.zip$");
        Matcher matcher = pattern.matcher(zip);
        if (matcher.matches()) {
            buildNumber = matcher.group(1);
        }
        return buildNumber;
    }

    public String getBuildTime() {
        String buildTime = this.getBuildNumber();
        if (!buildTime.isEmpty()) {
            LocalDateTime localDateTime = LocalDateTime.parse(buildTime, DateTimeFormatter.ofPattern("yyMMddHHmm"));
            buildTime = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm").format(localDateTime);
        }
        return buildTime;
    }

    public String getVersionString() {
        String ver = this.getVersion();
        String build = this.getBuildNumber();
        String time = this.getBuildTime();
        return Utils.notBlankString(ver) && Utils.notBlankString(build) && Utils.notBlankString(time) ? String.format("%s-%s / %s", ver, build, time) : "?";
    }

    public static final VersionInfo getVersionInfo(String module) {
        VersionInfo result = new VersionInfo();
        try {
            Properties properties = new Properties();
            Path filesDatPath = Paths.get("conf", "files.dat");
            if (!Files.exists(filesDatPath, new LinkOption[0])) {
                filesDatPath = Paths.get("data", "files.dat");
            }
            if (Files.exists(filesDatPath, new LinkOption[0])) {
                if (module.startsWith("ru.bitel.bgbilling.plugins.")) {
                    module = module.substring("ru.bitel.bgbilling.plugins.".length());
                }
                for (String line : Files.readString(filesDatPath).split("\n")) {
                    if (line.startsWith("version:")) {
                        properties.put("version", line.substring(8));
                        continue;
                    }
                    if (line.startsWith("set:")) {
                        properties.put("set", line.substring(4));
                        continue;
                    }
                    if (!line.startsWith("name:" + module + "\t")) continue;
                    for (String param : line.split("\t")) {
                        int pos = param.indexOf(58);
                        if (pos <= -1) continue;
                        properties.put(param.substring(0, pos), param.substring(pos + 1));
                    }
                    break;
                }
            }
            result.setProperties(properties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

