/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server;

import java.util.Calendar;
import java.util.GregorianCalendar;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskRecalculator;
import ru.bitel.bgbilling.modules.npay.server.bean.RecalculatorParameters;
import ru.bitel.bgbilling.modules.npay.server.mail.MailTaskRecalculator;
import ru.bitel.bgbilling.modules.npay.server.task.Calculator;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class Recalculator
extends RunTaskRecalculator<Calculator> {
    private final RecalculatorParameters parameters;

    public Recalculator(int moduleId, Calendar dt, RecalculatorParameters parameters) {
        super(moduleId, dt, parameters.getEmail());
        this.parameters = parameters;
        GregorianCalendar now = new GregorianCalendar();
        if (TimeUtils.monthsDelta((Calendar)dt, (Calendar)now) == 0) {
            this.dt = now;
        } else {
            Calendar endDay = (Calendar)dt.clone();
            endDay.set(5, endDay.getActualMaximum(5));
            this.dt = endDay;
        }
        this.dt.set(11, 23);
    }

    public Recalculator init(Setup setup) throws Exception {
        super.init(setup);
        return this;
    }

    public void executeTask() {
        try {
            long start = System.currentTimeMillis();
            this.getLogger().info("PaymentRecalculator time: " + TimeUtils.format((Calendar)this.dt, (String)"dd.MM.yyyy HH"));
            Calculator calculator = this.createTask();
            calculator.startTask();
            long end = System.currentTimeMillis();
            if (this.email != null) {
                StringBuffer report = new StringBuffer("\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e\n").append("\u0412\u0440\u0435\u043c\u044f: ").append(TimeUtils.formatDeltaTime((long)((end - start) / 1000L)));
                new MailMsg((Preferences)this.setup).sendMessage(new MailTaskRecalculator().setModuleId(this.mid).setRecipients(this.email).setSubject("\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e").addTextPart("text", report.toString()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected Calculator createTask() {
        String params = "mid=" + this.mid + "\nservice.set=" + this.parameters.getServiceSet() + (this.parameters.isDetail() ? "\ndetail=0" : "") + "\ncomment=" + this.parameters.getComment();
        return (Calculator)new Calculator().setContractIds(this.parameters.getContractIds()).setContractLabelIds(this.parameters.getContractLabelIds()).setExecutingTime(this.dt).initTask(Setup.getSetup(), 0, params).to(Calculator.class);
    }
}

