/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.modules.kernel;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.CheckTree;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.ModTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.LocalDate;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNavigation;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.reports.client.ReportParams;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.list.BGUList;

public class ReportParams_Payment
extends ReportParams {
    private BGControlPanelPeriodNavigation periodPanel = new BGControlPanelPeriodNavigation();
    private BGControlPanelListSelect groupsPanel = new BGControlPanelListSelect();
    private BGControlPanelListSelect usersPanel = new BGControlPanelListSelect(5);
    private BGComboBox<ComboBoxItem> sortCombo1 = new BGComboBox();
    private BGComboBox<ComboBoxItem> sortCombo2 = new BGComboBox();
    private BGComboBox<ComboBoxItem> fcCombo = new BGComboBox();
    private JRadioButton or_RB = new JRadioButton("\u0418\u041b\u0418", true);
    private JRadioButton and_RB = new JRadioButton("\u0418");
    private JTextField mask_TF = new JTextField();
    private CheckTree tree = new CheckTree(new ModTreeNode());

    public ReportParams_Payment() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.periodPanel.setDateFrom(LocalDate.now().minusDays(1L));
        this.periodPanel.setDateTo(LocalDate.now());
        this.tree.setDefaultTree("\u0412\u0441\u0435 \u0442\u0438\u043f\u044b");
        this.periodPanel.setBorder((Border)BorderFactory.createCompoundBorder((Border)new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
    }

    private void jbInit() throws Exception {
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.and_RB);
        buttonGroup3.add(this.or_RB);
        this.initSortCombo(this.sortCombo1);
        this.initSortCombo(this.sortCombo2);
        this.fcCombo.addItem((Object)new ComboBoxItem((Object)"-1", "----------"));
        this.fcCombo.addItem((Object)new ComboBoxItem((Object)"0", "\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435"));
        this.fcCombo.addItem((Object)new ComboBoxItem((Object)"1", "\u042e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u043e\u0435"));
        this.mask_TF.setPreferredSize(new Dimension(100, 24));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.setBorder((Border)new BGTitleBorder(" \u0424\u0438\u043b\u044c\u0442\u0440"));
        filterPanel.add((Component)new JLabel("\u041c\u0430\u0441\u043a\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add((Component)this.mask_TF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)new JLabel("\u041b\u0438\u0446\u043e"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add((Component)this.fcCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel sortPanel = new JPanel(new FlowLayout());
        sortPanel.setBorder((Border)new BGTitleBorder(" \u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e "));
        sortPanel.add((Component)this.sortCombo1);
        sortPanel.add((Component)this.sortCombo2);
        JPanel groupModePanel = new JPanel();
        groupModePanel.add(new JLabel("\u0420\u0435\u0436\u0438\u043c"));
        groupModePanel.add(this.and_RB);
        groupModePanel.add(this.or_RB);
        JPanel groupListPanel = new JPanel(new GridBagLayout());
        groupListPanel.add((Component)groupModePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        groupListPanel.add((Component)this.groupsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel treePanel = new JPanel(new GridBagLayout());
        treePanel.add((Component)new JScrollPane((Component)this.tree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JTabbedPane jTabbedPane1 = new JTabbedPane();
        jTabbedPane1.add((Component)treePanel, "\u0422\u0438\u043f\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
        jTabbedPane1.add((Component)this.usersPanel, "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438");
        jTabbedPane1.add((Component)groupListPanel, "\u0413\u0440\u0443\u043f\u043f\u044b");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.periodPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add(filterPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add(sortPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add(jTabbedPane1, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
    }

    private void initSortCombo(BGComboBox<ComboBoxItem> sortCombo) {
        sortCombo.addItem((Object)new ComboBoxItem((Object)"", "-- \u043d\u0435\u0442 --"));
        sortCombo.addItem((Object)new ComboBoxItem((Object)"t2.dt", "\u0434\u0430\u0442\u0430"));
        sortCombo.addItem((Object)new ComboBoxItem((Object)"t2.summa", "\u0441\u0443\u043c\u043c\u0430"));
        sortCombo.addItem((Object)new ComboBoxItem((Object)"t1.title", "\u0434\u043e\u0433\u043e\u0432\u043e\u0440"));
        sortCombo.addItem((Object)new ComboBoxItem((Object)"t2.comment", "\u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"));
    }

    public void setData() throws Exception {
        Request request = new Request().setModule("contract").setAction("ListGroups");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildList((BGUList)this.groupsPanel.getList(), (Iterable)XMLUtils.selectElements((Node)doc, (String)"//groups/item"));
        }
        if (ClientUtils.checkStatus((Document)(doc = this.getDocument(request = new Request().setModule("admin").setAction("ListDirectory").setAttribute("mode", 1))))) {
            this.tree.setTreeFromDocument(doc, "//directory");
        }
        if (ClientUtils.checkStatus((Document)(doc = this.getDocument(request = new Request().setModule("admin").setAction("UserList"))))) {
            ClientUtils.buildList((BGControlPanelListSelect)this.usersPanel, (Node)XMLUtils.selectNode((Node)doc, (String)"//users"));
        }
    }

    @Override
    protected void putReportParams(Map<String, Object> _reportParams) {
        _reportParams.put("date1", this.periodPanel.getDateString1());
        _reportParams.put("date2", this.periodPanel.getDateString2());
        _reportParams.put("mask", this.mask_TF.getText());
        _reportParams.put("gr", this.groupsPanel.getListValues());
        _reportParams.put("pt", this.tree.getCodes(true));
        _reportParams.put("users", this.usersPanel.getListValues());
        _reportParams.put("sort1", ClientUtils.getIdFromComboBox(this.sortCombo1));
        _reportParams.put("sort2", ClientUtils.getIdFromComboBox(this.sortCombo2));
        _reportParams.put("fc", ClientUtils.getIdFromComboBox(this.fcCombo));
        _reportParams.put("group_mode", this.or_RB.isSelected() ? "or" : "and");
    }
}

