package ru.bitel.bgbilling.modules.sorm.dyn.cdr;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.common.SormManufacturer;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.CDRItem;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.CDRUploadCommon;
import ru.bitel.bgbilling.modules.sorm.server.upload.vasexpert.VasexpertConstants;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

import java.nio.file.Path;

import static ru.bitel.bgbilling.modules.sorm.server.upload.vasexpert.VasexpertFileTitle.CDR;
import static ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils.getUploadFile;

public class VasexpertCDRUpload
    extends CDRUploadCommon
{
    public VasexpertCDRUpload( int moduleId,
                               SormProject sormProject )
        throws BGException
    {
        super( moduleId, sormProject );
    }

    @Override
    protected Path getFile()
    throws BGException
    {
        return getUploadFile( localUserPath,
                              CDR.getTitle(),
                              VasexpertConstants.FILE_NAME_DATE_PATTERN );
    }

    @Override
    protected String[] getHeader()
    {
        return null;
    }

    @Override
    protected String[] getCDRItem( CDRItem cdrItem )
        throws BGException
    {
        //под вопросом пока поля: 3, 14, 15
        // как по номерам определить транки
        String[] item = new String[27];
        item[0] = generateCallId( cdrItem ); //ID звонка, строка, размер 512, содержит уникальный идентификационный номер звонка в АТС оператора
        item[1] = cdrItem.startTime == null ? "" : TimeUtils.format( cdrItem.startTime, TimeUtils.DATE_FORMAT_PATTERN_DDMMYYYY_HHMMSS ); //время установления соединения, дата, формат «YYYY-MM-DD HH:MM:SS», должно быть приведено ко времени UTC
        item[2] = String.valueOf( cdrItem.duration ); //длительность вызова, число, длительность вызова в секундах, не более 86 399 секунд
        item[3] = "16"; //причина разъединения, справочник, код согласно ITU-T Q.850, диапазон значений от 0 до 16 384
        item[4] = "1"; //call-type-id:тип соединения, число, соответствует идентификатору (п.1) в выгрузке типов вызовов
        item[5] = getServiceId(); //supplement-service-id:ДВО при соединении, целое число от 0 до 4 294 967 295, соответствует ИД услуги из выгрузки номенклатуры услуг
        item[6] = ""; //IP-адрес вызывающего абонента, IPv4/IPv6-адрес, заполняется только в случае необходимости эмуляции ААА-сессий

        item[7] = isOurNumber( cdrItem.callingNumber ) ? "0" : "1"; //тип источника, справочник, 0 - абонент данного коммутатора, 1 - абонент сети связи, 2 - роумер
        item[8] = cdrItem.callingNumber; //номер вызывающего абонента, строка, размер 15, формат E.164
        item[9] = ""; //дополнительный внутренний номер вызывающего абонента, строка, размер 15
        item[10] = ""; //IP-адрес вызываемого абонента, IPv4/IPv6-адрес, заполняется только в случае необходимости эмуляции ААА-сессий
        item[11] = isOurNumber( cdrItem.calledNumber ) ? "0" : "1"; //тип назначения, справочник, 0 - абонент данного коммутатора, 1 - абонент сети связи, 2 - роумер
        item[12] = cdrItem.calledNumber; //набранный номер вызываемого абонента, строка, размер 32, номер вызываемого абонента на входе, номер указать без преобразования
        item[13] = cdrItem.calledNumber; //номер вызываемого абонента, строка, размер 15, формат E.164
        item[14] = ""; //дополнительный внутренний номер вызываемого абонента, строка, размер 15
        item[15] = ""; //номер при переадресации, строка, размер 15, формат E.164

        item[16] = String.valueOf( cdrItem.deviceId ); //идентификатор коммутатора, строка, размер 128, идентификатор коммутатора, соответствует п. 1 из выгрузки данных по коммутаторам
        item[17] = String.valueOf( cdrItem.deviceId ); //идентификатор пограничного коммутатора, строка, размер 128, идентификатор коммутатора, соответствует п. 1 из выгрузки данных по коммутаторам

        item[18] = Utils.maskBlank( cdrItem.fromPort, "1"); //идентификатор входящего пучка (транка), число, соответствует п.1 из выгрузки данных по пучкам
        item[19] = Utils.maskBlank( cdrItem.toPort, "1" ); //идентификатор исходящего пучка (транка), число, соответствует п.1 из выгрузки данных по пучкам
        //все остальные пустые ненужные
        item[20] = "";
        item[21] = "";
        item[22] = "";
        item[23] = "";
        item[24] = "";
        item[25] = "";
        item[26] = "";
        return item;
    }

    @Override
    public SormManufacturer getSormManufacturer()
    {
        return SormManufacturer.VASEXPERTS;
    }
}

