/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.LocalDate;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGControlPanelContractSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelMonthAndDays;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractGroupService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.list.BGUCheckList;

public class VoiceSessionRecalcPanel
extends BGUPanel {
    private BGControlPanelContractSelect contractsSelect = new BGControlPanelContractSelect();
    private BGControlPanelMonthAndDays period = new BGControlPanelMonthAndDays();
    private BGUCheckList<ContractGroup> contractGroups = new BGUCheckList();
    private BGTextField email = new BGTextField();
    private BGTextField comment = new BGTextField();

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JPanel group = new JPanel();
        group.setLayout(new BorderLayout());
        group.add((Component)this.contractGroups);
        group.setBorder((Border)new BGTitleBorder("\u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432"));
        JPanel periodPanel = new JPanel();
        periodPanel.setLayout(new BorderLayout());
        periodPanel.add((Component)this.period);
        periodPanel.setBorder((Border)new BGTitleBorder("\u041f\u0435\u0440\u0438\u043e\u0434"));
        JPanel startPanel = new JPanel();
        startPanel.setLayout(new GridBagLayout());
        startPanel.setBorder((Border)new BGTitleBorder("\u041f\u0443\u0441\u043a"));
        startPanel.add((Component)new JLabel("\u0412\u044b\u0441\u043b\u0430\u0442\u044c \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043d\u0430 "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.email.setMinimumSize(new Dimension(100, 24));
        this.email.setPreferredSize(new Dimension(200, 24));
        startPanel.add((Component)this.email, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        JLabel commentLabel = new JLabel("\u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 ");
        commentLabel.setBackground(new Color(255, 0, 0));
        commentLabel.setHorizontalAlignment(2);
        startPanel.add((Component)commentLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        startPanel.add((Component)this.comment, new GridBagConstraints(3, 0, 1, 1, 0.7, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        JButton start = new JButton("\u0417\u0430\u043f\u0443\u0441\u043a");
        startPanel.add((Component)start, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(group, new GridBagConstraints(0, 0, 1, 3, 0.0, 1.0, 11, 3, new Insets(5, 5, 5, 5), 0, 0));
        this.add(periodPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.contractsSelect, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(startPanel, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        start.addActionListener(e -> this.start());
    }

    private void start() {
        try {
            Date dateFrom = TimeUtils.convertLocalDateToDate((LocalDate)this.period.getBeginDate());
            Date dateTo = TimeUtils.convertLocalDateToDate((LocalDate)this.period.getEndDate().plusDays(1L));
            ((VoiceService)((ClientContext)this.getContext()).getWebService(VoiceService.class)).calculate(dateFrom, dateTo, this.contractsSelect.getContractSet(), this.contractGroups.getSelectedMask(), this.email.getText(), this.comment.getText());
            this.saveUserEmail(((ClientContext)this.getContext()).getModule(), this.email.getText().trim());
            JOptionPane.showMessageDialog((Component)((Object)this), "\u041f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442 \u0441\u0435\u0441\u0441\u0438\u0438\u0439 \u0437\u0430\u043f\u0443\u0449\u0435\u043d, \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u0435 \u0431\u0443\u0434\u0435\u0442 \n\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 EMail", "\u041f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442 \u0441\u0435\u0441\u0441\u0438\u0438\u0439 \u0437\u0430\u043f\u0443\u0449\u0435\u043d", 1);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            ContractGroupService contractGroupService = (ContractGroupService)((ClientContext)this.getContext()).getPort(ContractGroupService.class, 0);
            this.contractGroups.setData(contractGroupService.contractGroupList(false, "title"));
            this.email.setText(this.getUserEmail(((ClientContext)this.getContext()).getModule()));
        });
    }
}

