/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.botconfigure;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.common.service.BotManagerService;
import ru.bitel.common.client.list.BGUList;

public class ElementsListTransferHandler
extends TransferHandler {
    public static final DataFlavor LIST_ITEM_DATA_FLAVOR = new DataFlavor(BotDialogElement.class, "BotDialogElementListItem");
    private BotManagerService botManagerService;

    public ElementsListTransferHandler() {
    }

    public ElementsListTransferHandler(BotManagerService botManagerService) {
        this.botManagerService = botManagerService;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return true;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        boolean accept = this.canImport(support);
        if (accept) {
            try {
                Object transferData = support.getTransferable().getTransferData(LIST_ITEM_DATA_FLAVOR);
                Component component = support.getComponent();
                BGUList list = (BGUList)component;
                DefaultListModel listModel = list.getModel();
                ArrayList elementList = Collections.list(listModel.elements());
                BotDialogElement element = (BotDialogElement)transferData;
                if (!elementList.contains(element)) {
                    listModel.addElement(element);
                } else {
                    JList.DropLocation dropLocation = (JList.DropLocation)support.getDropLocation();
                    int newPosition = dropLocation.getIndex();
                    int oldPosition = elementList.indexOf(element);
                    ArrayList newSortedList = new ArrayList();
                    if (newPosition >= elementList.size() - 1) {
                        listModel.remove(oldPosition);
                        listModel.addElement(element);
                        newSortedList.addAll(Collections.list(listModel.elements()));
                    } else if (newPosition >= 0 && newPosition != oldPosition) {
                        int x;
                        elementList.remove(oldPosition);
                        for (x = 0; x < newPosition; ++x) {
                            newSortedList.add((BotDialogElement)elementList.get(x));
                        }
                        newSortedList.add(newPosition, element);
                        for (x = newPosition; x < elementList.size(); ++x) {
                            newSortedList.add(x + 1, (BotDialogElement)elementList.get(x));
                        }
                        listModel.removeAllElements();
                        listModel.addAll(newSortedList);
                    }
                    if (this.botManagerService != null && newSortedList.size() > 0) {
                        HashMap<Integer, Integer> elementSorting = new HashMap<Integer, Integer>();
                        for (int x = 0; x < newSortedList.size(); ++x) {
                            elementSorting.put(((BotDialogElement)newSortedList.get(x)).getId(), x);
                        }
                        this.botManagerService.updateSortPositionOfElements(elementSorting);
                    }
                    list.setSelectedIndex(newPosition);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        return accept;
    }

    @Override
    public int getSourceActions(JComponent c) {
        c.getRootPane().getGlassPane().setCursor(DragSource.DefaultMoveDrop);
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        BotDialogElement elementForTransfer;
        DialogElementTransferable transferable = null;
        if (c instanceof JList && (elementForTransfer = (BotDialogElement)((JList)c).getSelectedValue()) != null) {
            transferable = new DialogElementTransferable(elementForTransfer);
        }
        return transferable;
    }

    private static class DialogElementTransferable
    implements Transferable {
        private BotDialogElement element;

        public DialogElementTransferable(BotDialogElement element) {
            this.element = element;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{LIST_ITEM_DATA_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(LIST_ITEM_DATA_FLAVOR);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            return this.element;
        }
    }
}

