/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.constructor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.modules.reports.client.constructor.FilterPanel;
import ru.bitel.bgbilling.modules.reports.client.include.FillableFilter;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilter;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilterCache;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilterParameterName;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilterTitleName;
import ru.bitel.common.Utils;

public final class GenerateReportOptions {
    private String reportTitle;
    private String reportFileName;
    private String processingClass;
    private List<FilterPanel> filters;
    private Map<String, String> fields;
    private boolean needScroll;

    public String getReportTitle() {
        return this.reportTitle;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public String getProcessingClass() {
        return this.processingClass;
    }

    public List<FilterPanel> getFilters() {
        return this.filters;
    }

    public boolean isNeedScroll() {
        return this.needScroll;
    }

    public GenerateReportOptions setReportTitle(String reportTitle) {
        this.reportTitle = reportTitle;
        return this;
    }

    public GenerateReportOptions setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
        return this;
    }

    public GenerateReportOptions setProcessingClass(String processingClass) {
        this.processingClass = processingClass;
        return this;
    }

    public GenerateReportOptions setFilters(List<FilterPanel> filters) {
        this.filters = filters;
        return this;
    }

    public GenerateReportOptions setFields(Map<String, String> fields) {
        this.fields = fields;
        return this;
    }

    public GenerateReportOptions setNeedScroll(boolean needScroll) {
        this.needScroll = needScroll;
        return this;
    }

    public static XmlReportParser xmlParser(Element reportEl) {
        return new XmlReportParser(new GenerateReportOptions(), reportEl);
    }

    public final class XmlReportParser {
        private Element reportEl;

        private XmlReportParser(GenerateReportOptions this$0, Element reportEl) {
            this.reportEl = reportEl;
        }

        public List<FilterPanel> parseFilters() {
            ArrayList<FilterPanel> filters = new ArrayList<FilterPanel>();
            ReportFilterCache reportFilterCache = ReportFilterCache.getInstance();
            NodeList childs = this.reportEl.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node reportFilterNode = childs.item(i);
                ReportFilter reportFilter = reportFilterCache.getReportFilterByFilterName(reportFilterNode.getNodeName());
                if (reportFilter == null) continue;
                for (Field parameterNameField : reportFilter.getClass().getDeclaredFields()) {
                    ReportFilterTitleName reportFilterTitleName;
                    String nameAttr = null;
                    ReportFilterParameterName reportFilterParameterName = parameterNameField.getAnnotation(ReportFilterParameterName.class);
                    if (reportFilterParameterName != null) {
                        nameAttr = ((Element)reportFilterNode).getAttribute(reportFilterParameterName.attrName());
                    }
                    if ((reportFilterTitleName = parameterNameField.getAnnotation(ReportFilterTitleName.class)) != null) {
                        nameAttr = ((Element)reportFilterNode).getAttribute(reportFilterTitleName.attrName());
                    }
                    if (!Utils.notBlankString((String)nameAttr)) continue;
                    try {
                        parameterNameField.setAccessible(true);
                        parameterNameField.set(reportFilter, nameAttr);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                FilterPanel filterPanel = new FilterPanel(reportFilter);
                if (reportFilter instanceof FillableFilter) {
                    NodeList items = reportFilterNode.getChildNodes();
                    for (int j = 0; j < items.getLength(); ++j) {
                        Node itemNode = items.item(j);
                        if (!"item".equals(itemNode.getNodeName()) || itemNode.getNodeType() != 1) continue;
                        Element item = (Element)items.item(j);
                        filterPanel.addFillableParameter(item.getAttribute("id"), item.getAttribute("title"));
                    }
                }
                filters.add(filterPanel);
            }
            return filters;
        }

        public Map<String, String> parseFields() {
            LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
            NodeList childs = this.reportEl.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!"fields".equals(node.getNodeName())) continue;
                NodeList reportFields = node.getChildNodes();
                for (int j = 0; j < reportFields.getLength(); ++j) {
                    Node n = reportFields.item(j);
                    if (!n.getNodeName().equals("item") || n.getNodeType() != 1) continue;
                    Element field = (Element)n;
                    String id = field.getAttribute("id");
                    String title = field.getAttribute("title");
                    if (!Utils.notBlankString((String)id) || !Utils.notBlankString((String)title)) continue;
                    fields.put(id, title);
                }
            }
            return fields;
        }

        public boolean parseScrollSetting() {
            return "true".equals(this.reportEl.getAttribute("scroll"));
        }
    }
}

