#!/bin/bash

cd ${0%${0##*/}}./..

. ./bin/setenv.sh

if [ ! -e lib/app/kernel-server.jar ]
then
    exit 0
fi

PWD="$($(which pwd))"
NAME_SHORT=${PWD##*/}

APP_HOME=.
CLASSPATH=$APP_HOME:$APP_HOME/lib/*:$APP_HOME/lib/app/*:$APP_HOME/lib/ext/*:$APP_HOME/lib/custom/*
COMPAT_PARAMS="--add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.util.regex=ALL-UNNAMED --add-opens java.base/java.util.concurrent=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED"
COMMON_PARAMS="-Dapp.name=$NAME_SHORT -Dnetworkaddress.cache.ttl=3600 -Djava.net.preferIPv4Stack=true -Dboot.info=1 ${COMPAT_PARAMS}"
LOG_PARAMS="-Dlog.dir.path=log/ -Dlog.prefix=$NAME_SHORT -Dlog4j.configurationFile=conf/log4j2.xml"
MEMORY=-Xmx256m

if [ "$1" = "start" ]; then
	nohup  ${JAVA_HOME}/bin/java ${COMMON_PARAMS} ${LOG_PARAMS} ${MEMORY} -cp ${CLASSPATH} ru.bitel.bgbilling.kernel.application.server.Application > ./log/${NAME_SHORT}.out 2>&1 & echo $! > .run/${NAME_SHORT}.pid &
else
	if [ "$1" = "debug" ]; then
		#starting in debug mode
	    nohup  ${JAVA_HOME}/bin/java ${COMMON_PARAMS} ${LOG_PARAMS} ${MEMORY} -cp ${CLASSPATH} -enableassertions -Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,address=5589,server=y,suspend=n ru.bitel.bgbilling.kernel.application.server.Application > ./log/${NAME_SHORT}.out 2>&1 & echo $! > .run/${NAME_SHORT}.pid
	else
		#execute command
		${JAVA_HOME}/bin/java ${COMMON_PARAMS} -cp ${CLASSPATH} ru.bitel.bgbilling.kernel.application.server.Application $@
	fi
fi
