/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.agr.server.service;

import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.agr.common.bean.Transaction;
import ru.bitel.bgbilling.modules.agr.common.service.AGRService;
import ru.bitel.bgbilling.modules.agr.server.bean.TransactionManager;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.agr.common.service.AGRService")
public class AGRServiceImpl
extends AbstractService
implements AGRService {
    public SearchResult<Transaction> searchTransactionList(SearchParam searchParam, String agrPaymentSystem) throws BGException {
        SearchResult searchResult;
        TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);
        try {
            SearchResult searchResult2 = new SearchResult(searchParam);
            transactionManager.searchTransaction((SearchResult<Transaction>)searchResult2, searchParam, agrPaymentSystem);
            searchResult = searchResult2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    transactionManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        transactionManager.close();
        return searchResult;
    }

    public void checkPayment(int contractId, PeriodWithTime period) throws BGException {
        throw new BGMessageException("\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0432 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0435");
    }

    public List<IdTitle> getAgrPaymentSystemList() throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);){
            List<IdTitle> list = transactionManager.getAGRPaymentSystemList();
            return list;
        }
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        try (TransactionManager dao = new TransactionManager(this.getConnection(), this.moduleId);){
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            url.value = dao.getRedirectUrl(contractId, null, amount, dataMap, this.getModuleSetup());
            dataMap.forEach((a, b) -> ((MapHolder)params.value).getMap().put(a, String.valueOf(b)));
            if (mode != null) {
                mode.value = "redirect";
            }
        }
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
    }
}

