/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.action.web;

import bitel.billing.server.ActionBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistPaymentRecurring;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPaymentRecurringManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;

public class ActionPay
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        if (this.cid <= 0 && this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        String command = this.getParameter("command");
        if ("deleterecurring".equals(command)) {
            this.doDeleteRecurringAction();
            return;
        }
        BigDecimal summ = this.getBigDecimalParameter("summ", BigDecimal.ZERO);
        BigDecimal RecurringMinAmount = this.moduleSetup.getBigDecimal("assist.RecurringMinAmount", null);
        BigDecimal RecurringMaxAmount = this.moduleSetup.getBigDecimal("assist.RecurringMaxAmount", null);
        int RecurringPeriod = this.moduleSetup.getInt("assist.RecurringPeriod", -1);
        boolean RecurringAllowed = RecurringMinAmount != null && RecurringMaxAmount != null && RecurringPeriod != -1;
        AssistPaymentRecurringManager assistPaymentRecurringManager = new AssistPaymentRecurringManager(this.con, this.mid);
        AssistPaymentRecurring recurringAlreadyHas = assistPaymentRecurringManager.getRecurring(this.cid);
        if (recurringAlreadyHas != null) {
            RecurringAllowed = false;
        }
        if (summ.compareTo(BigDecimal.ZERO) > 0) {
            Element pay = this.createElement(this.rootNode, "pay");
            int mobilePhoneParamId = this.moduleSetup.getInt("assist.MobilePhone.param.id", 0);
            if (mobilePhoneParamId > 0) {
                try (ContractDao contractDao = new ContractDao(this.con, 0);){
                    List phones;
                    EntityAttr entityAttr = contractDao.getContractParameter(this.cid, mobilePhoneParamId);
                    if (entityAttr instanceof EntityAttrPhone && (phones = ((EntityAttrPhone)entityAttr).toUnformattedPhoneList()) != null && !phones.isEmpty()) {
                        XMLUtils.setAttribute((Element)pay, (String)"MobilePhone", (String)((String)phones.get(0)));
                    }
                }
            }
            XMLUtils.setAttribute((Element)pay, (String)"RecurringIndicator", (String)"0");
            if (RecurringAllowed) {
                boolean recurringCheckbox = this.getBooleanParameter("recurring", false);
                String RecurringMaxDate = this.getParameter("recurringmaxdate", null);
                Date dRecurringMaxDate = TimeUtils.parseDate((String)RecurringMaxDate, (String)"dd.MM.yyyy");
                if (dRecurringMaxDate == null) {
                    dRecurringMaxDate = new Date(0L);
                }
                if (recurringCheckbox) {
                    XMLUtils.setAttribute((Element)pay, (String)"RecurringIndicator", (String)"1");
                    XMLUtils.setAttribute((Element)pay, (String)"RecurringMinAmount", (String)RecurringMinAmount.toPlainString());
                    XMLUtils.setAttribute((Element)pay, (String)"RecurringMaxAmount", (String)RecurringMaxAmount.toPlainString());
                    XMLUtils.setAttribute((Element)pay, (String)"RecurringPeriod", (String)String.valueOf(RecurringPeriod));
                    XMLUtils.setAttribute((Element)pay, (String)"RecurringMaxDate", (String)RecurringMaxDate);
                    AssistPaymentRecurring assistPaymentRecurring = new AssistPaymentRecurring();
                    assistPaymentRecurring.setContractId(this.cid);
                    assistPaymentRecurring.setDate(new Date());
                    assistPaymentRecurring.setAmount(summ);
                    assistPaymentRecurring.setRecurringMinAmount(RecurringMinAmount);
                    assistPaymentRecurring.setRecurringMaxAmount(RecurringMaxAmount);
                    assistPaymentRecurring.setRecurringPeriod(RecurringPeriod);
                    assistPaymentRecurring.setRecurringMaxDate(dRecurringMaxDate);
                    assistPaymentRecurringManager.add(assistPaymentRecurring);
                }
            }
        }
    }

    private void doDeleteRecurringAction() throws BGException {
        AssistPaymentRecurringManager prm = new AssistPaymentRecurringManager(this.con, this.mid);
        prm.deleteRecurring(this.cid);
        try {
            this.response.sendRedirect("webexecuter?action=PayList&mid=" + this.mid + "&module=" + this.module);
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
    }
}

