/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import java.sql.SQLException;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocType;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocTypeManager;
import ru.bitel.bgbilling.modules.bill.server.bean.DocTypeManager;

public class ActionDocTypeList
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        String type = this.getParameter("type");
        if (this.mid <= 0 || type.trim().isEmpty()) {
            throw new BGIllegalArgumentException();
        }
        DocumentType documentType = type.equals("bill") ? DocumentType.BILL : DocumentType.INVOICE;
        Element selectList = this.createElement(this.rootNode, "list_select");
        Element avaliableList = this.createElement(this.rootNode, "list_avaliable");
        DocTypeManager docTypeManager = new DocTypeManager(this.con, this.mid);
        ContractDocTypeManager cdtm = new ContractDocTypeManager(this.con, this.mid);
        List<DocType> avaliable = docTypeManager.getTypeList(documentType);
        List<ContractDocType> selected = cdtm.getContractTypeList(this.cid, documentType, null);
        for (DocType dt : avaliable) {
            boolean isIn = false;
            for (ContractDocType cdt : selected) {
                if (cdt.getDocTypeId() != dt.getId()) continue;
                isIn = true;
            }
            if (!isIn) {
                this.addListItem(avaliableList, dt.getId(), dt.getTitle());
                continue;
            }
            this.addListItem(selectList, dt.getId(), dt.getTitle());
        }
    }
}

