/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.bill.common.bean.Position;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class PositionDao
extends AbstractIdDao<Position> {
    private DocumentType documentType = null;

    public PositionDao(Connection con, int moduleId, DocumentType documentType) {
        super(con, moduleId, "bill_" + (documentType.equals((Object)DocumentType.BILL) ? "" : "invoice_") + "position");
        this.documentType = documentType;
    }

    public SearchResult<Position> searchPositionList(Page page) throws BGException {
        SearchResult searchResult = new SearchResult(page);
        searchResult.setList(this.list("", "title", new Object[0]));
        return searchResult;
    }

    public Position getPosition(int positionId) throws BGException {
        return (Position)this.get(positionId);
    }

    public Position updatePosition(Position position) throws BGException {
        this.update(position);
        return position;
    }

    public boolean deletePosition(int positionId) throws BGException {
        return this.delete(positionId) > 0;
    }

    public List<Position> getPositonList() {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        ArrayList<Position> result = new ArrayList<Position>();
        ParameterMap pairs = moduleSetup.sub(this.documentType.equals((Object)DocumentType.INVOICE) ? "invoice.pos." : "bill.pos.");
        for (Map.Entry entry : pairs.entrySet()) {
            String param;
            int id;
            String[] id_name;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.endsWith(".name") || (id_name = key.split("\\.")).length != 2 || (id = Utils.parseInt((String)id_name[0], (int)-1)) < 0) continue;
            String name = value;
            String title = pairs.get(id + ".title");
            String inSum = pairs.get(id + ".insum");
            String awlz = pairs.get(id + ".awlz");
            int i = 1;
            HashMap<CallSite, String> params = new HashMap<CallSite, String>();
            while ((param = pairs.get(id + ".param." + i)) != null) {
                String[] val = param.split(":");
                if (val.length > 1) {
                    params.put((CallSite)((Object)("param_" + val[0])), val[1]);
                }
                ++i;
            }
            if (!Utils.notBlankString((String)name) || !Utils.notBlankString((String)title)) continue;
            result.add(Position.builder().setId(id).setName(name).setTitle(title).setSumm(pairs.get(id + ".summ")).setQuantity(pairs.get(id + ".quantity")).setQtyNumsAfterComma(pairs.get(id + ".qtynums")).setQtyNumsRoundingMode(pairs.get(id + ".qtynumsRnd")).setUnit(pairs.get(id + ".unit")).setUnitCode(pairs.get(id + ".unitCode")).setExtractor(pairs.get(id + ".extractor")).setDynclass(pairs.get(id + ".dynclass")).setInSum(inSum == null || !inSum.equals("0")).setAddWhenLessZero(awlz != null && awlz.equals("1")).setParams(params).build());
        }
        try {
            SearchResult<Position> searchResult = this.searchPositionList(new Page(1, 0));
            result.addAll(searchResult.getList());
        }
        catch (BGException ex) {
            ex.printStackTrace();
        }
        Collections.sort(result, new Comparator<Position>(){

            @Override
            public int compare(Position o1, Position o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        });
        return result;
    }

    public Map<Integer, Position> getPositionMap() {
        HashMap<Integer, Position> result = new HashMap<Integer, Position>();
        for (Position pos : this.getPositonList()) {
            result.put(pos.getId(), pos);
        }
        return result;
    }

    protected Position getFromRS(ResultSet rs) throws SQLException, BGException {
        Position position = Position.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setData(rs.getString("data")).build();
        position.fromData();
        return position;
    }

    protected void updateImpl(Position position) throws BGException, SQLException {
        boolean insert = position.getId() <= 0;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET title=?, data=?" + (insert ? "" : " WHERE id=?");
        PreparedStatement ps = this.con.prepareStatement(query, 1);
        if (position.getData() == null || position.getData().isEmpty()) {
            position.toData();
        }
        int index = 1;
        ps.setString(index++, position.getTitle());
        ps.setString(index++, position.getData());
        if (!insert) {
            ps.setInt(index++, position.getId());
        }
        ps.executeUpdate();
        if (insert) {
            position.setId(ServerUtils.lastInsertId((Connection)this.con));
        }
        ps.close();
    }
}

