/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.Position;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.server.bean.BillUtil;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocType;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocTypeManager;
import ru.bitel.bgbilling.modules.bill.server.bean.DocTypeManager;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionDao;
import ru.bitel.bgbilling.modules.bill.server.bean.TemplateBill;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TemplateBillManager {
    private Connection con;
    private int moduleId;
    private DocumentType documentType;

    public TemplateBillManager(Connection con, int moduleId, DocumentType documentType) {
        this.con = con;
        this.moduleId = moduleId;
        this.documentType = documentType;
    }

    public List<TemplateBill> getTemplatePayBillList(Preferences moduleSetup, int yy, int mm, String contractLabels, String cids, String docTypes, String[] outgoing) throws BGException {
        return this.getTemplatePayBillList(moduleSetup, yy, mm, contractLabels, cids, docTypes, outgoing, true);
    }

    public List<TemplateBill> getTemplatePayBillList(Preferences moduleSetup, int yy, int mm, String contractLabels, String cids, String docTypes, String[] outgoing, boolean checkPast) throws BGException {
        ArrayList<TemplateBill> result = new ArrayList<TemplateBill>();
        if (checkPast && !BillUtil.isPast(yy, mm)) {
            return result;
        }
        try {
            Object query;
            List listIds;
            PreparedStatement ps;
            boolean needOutgoing;
            GregorianCalendar date = new GregorianCalendar(yy, mm, 1);
            Calendar endMonth = TimeUtils.getEndMonth((Calendar)date);
            boolean bl = needOutgoing = outgoing != null && outgoing.length == 2 && (Utils.notBlankString((String)outgoing[0]) || Utils.notBlankString((String)outgoing[1]));
            if (needOutgoing) {
                Statement s = this.con.createStatement();
                s.executeUpdate("DROP TEMPORARY TABLE IF EXISTS bill_temp_balance");
                s.executeUpdate("DROP TEMPORARY TABLE IF EXISTS bill_temp_max_balance");
                String sql = "CREATE TEMPORARY TABLE bill_temp_max_balance (UNIQUE (cid)) SELECT cid, MAX(yy*12+(mm-1))%12 + 1 AS mm,FLOOR(MAX(yy*12+(mm-1)) / 12) AS yy FROM contract_balance WHERE (yy < ?) OR (yy=? AND mm<=? + 1) GROUP BY cid";
                ps = this.con.prepareStatement(sql);
                ps.setInt(1, yy);
                ps.setInt(2, yy);
                ps.setInt(3, mm);
                ps.executeUpdate();
                ps.close();
                sql = "CREATE TEMPORARY TABLE bill_temp_balance (UNIQUE (cid)) SELECT b.cid, summa1 + summa2 - summa3 - summa4 as outgoing FROM contract_balance as b LEFT JOIN bill_temp_max_balance as tb ON b.cid=tb.cid WHERE b.yy = tb.yy AND b.mm = tb.mm";
                s.executeUpdate(sql);
                s.executeUpdate("DROP TEMPORARY TABLE IF EXISTS bill_temp_max_balance");
                ps.close();
                s.close();
            }
            if ((listIds = Utils.toList((String)contractLabels)).size() > 0) {
                query = "CREATE TEMPORARY TABLE IF NOT EXISTS `cids` AS (SELECT DISTINCT `contract_id` FROM `contract_label_link` WHERE `label_id` IN ( " + Utils.toString((Iterable)listIds) + " ) )";
                try {
                    ps = this.con.prepareStatement(((String)query).toString());
                    try {
                        ps.executeUpdate();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            query = "SELECT contract_module.cid, contract.title, contract.comment FROM contract_module INNER JOIN contract ON contract_module.cid=contract.id ";
            if (needOutgoing) {
                query = (String)query + "LEFT JOIN bill_temp_balance as tb ON contract.id=tb.cid ";
            }
            if (listIds.size() > 0) {
                query = (String)query + "INNER JOIN cids ON contract_module.cid=cids.contract_id ";
            }
            query = (String)query + "WHERE contract_module.mid=? AND (contract.date1 IS NULL OR contract.date1<=?) AND (contract.date2 IS NULL OR contract.date2>=?)";
            if (needOutgoing) {
                if (Utils.notBlankString((String)outgoing[0])) {
                    query = (String)query + " AND tb.outgoing >= " + outgoing[0] + " ";
                }
                if (Utils.notBlankString((String)outgoing[1])) {
                    query = (String)query + " AND tb.outgoing <= " + outgoing[1] + " ";
                }
            }
            if (Utils.notBlankString((String)cids)) {
                query = (String)query + " AND contract.id IN ( " + cids + ")";
            }
            query = (String)query + " ORDER BY contract.title ASC";
            Map<Integer, DocType> typeMap = new DocTypeManager(this.con, this.moduleId).getTypeMap();
            ContractDocTypeManager contractDocTypeManager = new ContractDocTypeManager(this.con, this.moduleId);
            ContractManager contractManager = new ContractManager(this.con);
            Map<Integer, Position> positionMap = null;
            try (PositionDao positionDao = new PositionDao(this.con, this.moduleId, this.documentType);){
                positionMap = positionDao.getPositionMap();
            }
            PreparedStatement ps2 = this.con.prepareStatement(((String)query).toString());
            ps2.setInt(1, this.moduleId);
            ps2.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)endMonth));
            ps2.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ResultSet rs = ps2.executeQuery();
            while (rs.next()) {
                int contractId = rs.getInt("cid");
                String title = rs.getString("title");
                String comment = rs.getString("comment");
                List<ContractDocType> docList = contractDocTypeManager.getContractTypeList(contractId, this.documentType, docTypes);
                for (ContractDocType contractDocType : docList) {
                    DocType docType = typeMap.get(contractDocType.getDocTypeId());
                    if (docType == null) continue;
                    TemplateBill bill = new TemplateBill();
                    bill.setContractDocTypeId(contractDocType.getId());
                    bill.setDocTypeId(contractDocType.getDocTypeId());
                    bill.setDocTypeTitle(docType.getTitle());
                    bill.setContractId(contractDocType.getContractId());
                    bill.setContractTitle(title);
                    bill.setContractComment(comment);
                    this.getTemplatePositions(contractManager, bill, date, contractId, String.valueOf(contractId), contractDocType, docType, positionMap);
                    result.add(bill);
                }
            }
            rs.close();
            ps2.close();
            try (PreparedStatement psDrop = this.con.prepareStatement("DROP TEMPORARY TABLE IF EXISTS `cids`");){
                psDrop.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            contractManager.recycle();
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public void getTemplatePositions(ContractManager contractManager, TemplateBill bill, Calendar date, int contractId, String billCids, ContractDocType contractDocType, DocType docType, Map<Integer, Position> positionMap) {
        Contract contract = contractManager.getContractById(contractId);
        if (!docType.isSubContractPositions() && !docType.isNSubContractPositions()) {
            if (contract.getSuperId() == -1 && Utils.notBlankString((String)contract.getDependSubList())) {
                billCids = (String)billCids + "," + contract.getDependSubList();
            }
            bill.setPositionList(BillUtil.getPositionList(this.con, date, contract, (String)billCids, docType, positionMap));
        } else {
            bill.setPositionList(BillUtil.getPositionList(this.con, date, contract, (String)billCids, docType, positionMap));
            ArrayList<TemplateBill> subBillList = new ArrayList<TemplateBill>(5);
            if (docType.isSubContractPositions() && contract.getSuperId() == -1 && Utils.notBlankString((String)contract.getDependSubList())) {
                Iterator iterator = Utils.toIntegerList((String)contract.getDependSubList()).iterator();
                while (iterator.hasNext()) {
                    int subCid = (Integer)iterator.next();
                    Contract subContract = contractManager.getContractById(subCid);
                    if (subContract == null) continue;
                    TemplateBill subBill = new TemplateBill();
                    if (contractDocType != null) {
                        subBill.setContractDocTypeId(contractDocType.getId());
                    }
                    subBill.setDocTypeId(docType.getId());
                    subBill.setContractId(subCid);
                    subBill.setContractTitle(subContract.getTitle());
                    subBill.setContractComment(subContract.getComment());
                    subBill.setPositionList(BillUtil.getPositionList(this.con, date, subContract, String.valueOf(subCid), docType, positionMap));
                    subBillList.add(subBill);
                }
            }
            if (docType.isNSubContractPositions()) {
                List nsub = contractManager.getSubContracts(contractId, 1);
                if (contract.getSuperId() == -1 && !nsub.isEmpty()) {
                    for (Contract nsubContract : nsub) {
                        if (nsubContract == null) continue;
                        TemplateBill nsubBill = new TemplateBill();
                        if (contractDocType != null) {
                            nsubBill.setContractDocTypeId(contractDocType.getId());
                        }
                        nsubBill.setDocTypeId(docType.getId());
                        nsubBill.setContractId(nsubContract.getId());
                        nsubBill.setContractTitle(nsubContract.getTitle());
                        nsubBill.setContractComment(nsubContract.getComment());
                        nsubBill.setPositionList(BillUtil.getPositionList(this.con, date, nsubContract, String.valueOf(nsubContract.getId()), docType, positionMap));
                        subBillList.add(nsubBill);
                    }
                }
            }
            bill.setSubBillList(subBillList);
        }
    }
}

