/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.bean;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.FloatTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.bill.client.bean.BGBillTablePos;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGTableModel;

public class BillPositionsEditorTab
extends BGPanel {
    private JPanel editPanel = new JPanel(new GridBagLayout());
    private BGUTable posTable = null;
    private BGTextField positionTitle = new BGTextField();
    private BGComboBox<ComboBoxItem> position = new BGComboBox();
    private FloatTextField sum = new FloatTextField();
    private JTextField quantity = new JTextField();
    private BGTextField unit = new BGTextField();
    private int currentPosNumber = 0;
    private List<BGBillTablePos> currentPosList;
    private ActionListener actionListener;
    private Node positions = null;
    private PositionsTableModel positionsTableModel = new PositionsTableModel(BillPositionsEditorTab.class.getName());

    public BillPositionsEditorTab(ActionListener actionListener) {
        this.actionListener = actionListener;
        this.posTable = new BGUTable((TableModel)((Object)this.positionsTableModel));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBorder(Border border) {
        this.add(Box.createVerticalGlue(), new GridBagConstraints(3, 0, 1, 2, 0.0, 1.0, 16, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 16, 1, new Insets(0, 5, 0, 0), 0, 0));
        super.setBorder(border);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.posTable.setEnabled(enabled);
    }

    private void jbInit() {
        this.sum.setColumns(15);
        this.sum.setMinimumSize(new Dimension(110, 24));
        this.sum.setPreferredSize(new Dimension(110, 24));
        this.quantity.setColumns(10);
        this.quantity.setMinimumSize(new Dimension(50, 24));
        this.quantity.setPreferredSize(new Dimension(50, 24));
        this.unit.setColumns(10);
        this.unit.setMinimumSize(new Dimension(50, 24));
        this.unit.setPreferredSize(new Dimension(50, 24));
        this.unit.setEnabled(false);
        this.editPanel.setVisible(false);
        this.editPanel.add((Component)new JLabel("\u041f\u043e\u0437\u0438\u0446\u0438\u044f"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editPanel.add((Component)this.position, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        this.editPanel.add((Component)this.positionTitle, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editPanel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editPanel.add((Component)this.sum, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editPanel.add((Component)new JLabel("\u041a\u043e\u043b.-\u0432\u043e"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editPanel.add((Component)this.quantity, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editPanel.add((Component)new JLabel("\u0415\u0434\u0438\u043d\u0438\u0446\u044b"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editPanel.add((Component)this.unit, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        this.editPanel.add((Component)okCancel, new GridBagConstraints(1, 2, 3, 2, 0.0, 0.0, 14, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.posTable), new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.editPanel, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        okCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BillPositionsEditorTab.this.stopEdit(e.getActionCommand().equals("ok"));
            }
        });
        this.posTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && BillPositionsEditorTab.this.posTable.isEnabled()) {
                    BillPositionsEditorTab.this.posAction("editItem");
                }
            }
        });
        this.position.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ComboBoxItem item;
                if (e.getStateChange() == 1 && (item = (ComboBoxItem)BillPositionsEditorTab.this.position.getSelectedItem()) != null) {
                    String title = item.toString();
                    BillPositionsEditorTab.this.positionTitle.setText(title);
                    if (Utils.notBlankString((String)title)) {
                        Element posit = XMLUtils.selectElement((Node)BillPositionsEditorTab.this.positions, (String)("pos[@id=" + Utils.parseInt((String)((String)item.getObject()), (int)0) + "]"));
                        if (posit.getAttribute("unit").isEmpty()) {
                            BillPositionsEditorTab.this.unit.setText("\u0448\u0442.");
                        } else {
                            BillPositionsEditorTab.this.unit.setText(posit.getAttribute("unit"));
                        }
                    }
                }
            }
        });
    }

    protected void posAction(String command) {
        if (command.equals("editItem")) {
            this.currentPosNumber = this.posTable.getSelectedRow();
            if (this.currentPosNumber >= 0) {
                this.startEdit();
            }
        }
        if (command.equals("newItem")) {
            this.currentPosNumber = -1;
            this.startEdit();
        } else if (command.compareTo("deleteItem") == 0) {
            this.currentPosNumber = this.posTable.getSelectedRow();
            if (this.currentPosNumber >= 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043e\u0437\u0438\u0446\u0438\u044e?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                this.deletePos(this.currentPosNumber);
            }
        } else if (command.compareTo("refresh") == 0 && this.currentPosList != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430?", "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            this.actionListener.actionPerformed(new ActionEvent((Object)this, 0, "refresh"));
        }
    }

    public void setPositionList(Node node) {
        this.positions = node;
        Element posNode = XMLUtils.selectElement((Node)this.positions, (String)"//positions/positionsCB");
        ClientUtils.buildComboBox(this.position, (Node)posNode, null);
    }

    private void startEdit() {
        if (this.currentPosList != null) {
            if (this.currentPosNumber >= 0) {
                BGBillTablePos pos = this.currentPosList.get(this.posTable.convertRowIndexToModel(this.currentPosNumber));
                for (int j = 0; j < this.position.getItemCount(); ++j) {
                    ComboBoxItem item = (ComboBoxItem)this.position.getItemAt(j);
                    if (!item.getObject().equals(String.valueOf(pos.getPositionId()))) continue;
                    this.position.setSelectedIndex(j);
                    break;
                }
                this.positionTitle.setText(pos.getName());
                this.sum.setText(Utils.formatBigDecimalSumm((BigDecimal)pos.getSum()));
                this.quantity.setText(Utils.maskNull((BigDecimal)pos.getQuantity()).setScale(pos.qtynums, pos.qtynumsRnd).toString());
                this.unit.setText(pos.getUnit());
                this.unit.setEnabled(false);
            } else {
                this.positionTitle.setText("");
                this.position.setSelectedIndex(0);
                this.sum.setText("");
                this.quantity.setText("1");
                this.unit.setText("\u0448\u0442.");
            }
            this.editPanel.setVisible(true);
        }
    }

    private void stopEdit(boolean save) {
        if (save) {
            Element posit;
            BGBillTablePos pos = this.currentPosNumber < 0 ? new BGBillTablePos() : this.currentPosList.get(this.currentPosNumber);
            Object item = this.position.getSelectedItem();
            if (item instanceof ComboBoxItem) {
                ComboBoxItem _item = (ComboBoxItem)this.position.getSelectedItem();
                pos.setPositionId(Utils.parseInt((String)((String)_item.getObject()), (int)0));
                if (Utils.isEmptyString((String)this.positionTitle.getText())) {
                    pos.setName(_item.toString());
                } else {
                    pos.setName(this.positionTitle.getText());
                }
            } else {
                pos.setPositionId(0);
                pos.setName(this.positionTitle.getText());
            }
            pos.setSum(Utils.parseBigDecimal((String)this.sum.getText().replace(',', '.'), (BigDecimal)BigDecimal.ZERO));
            pos.sumUnscaled = pos.getSum();
            String qty = this.quantity.getText().replace(',', '.');
            pos.setQuantity(Utils.parseBigDecimal((String)qty, (BigDecimal)BigDecimal.ZERO));
            pos.qtynums = pos.getQuantity().scale();
            pos.setUnit(this.unit.getText());
            pos.unitCode = !Utils.notBlankString((String)pos.unitCode) ? ((posit = XMLUtils.selectElement((Node)this.positions, (String)("pos[@id=" + pos.getPositionId() + "]"))).getAttribute("unitCode").isEmpty() ? "796" : posit.getAttribute("unitCode")) : pos.unitCode;
            if (this.currentPosNumber < 0) {
                this.currentPosList.add(pos);
            }
            this.showPositions();
            this.actionListener.actionPerformed(new ActionEvent((Object)this, 0, "stopEdit"));
        }
        this.editPanel.setVisible(false);
    }

    private void deletePos(int posId) {
        if (posId < this.currentPosList.size()) {
            this.currentPosList.remove(posId);
            this.actionListener.actionPerformed(new ActionEvent((Object)this, 0, "deletePos"));
            this.showPositions();
        }
    }

    public void showPositions(List<BGBillTablePos> posList) {
        this.editPanel.setVisible(false);
        this.currentPosList = posList;
        this.showPositions();
    }

    private void showPositions() {
        this.positionsTableModel.setData(this.currentPosList != null ? this.currentPosList : new ArrayList());
    }

    public final void serializePositions(Element positions) {
        for (BGBillTablePos pos : this.currentPosList) {
            Element posEl = positions.getOwnerDocument().createElement("pos");
            pos.toElement(posEl);
            positions.appendChild(posEl);
        }
    }

    class PositionsTableModel
    extends BGTableModel<BGBillTablePos> {
        public PositionsTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("ID", 0, 0, 0, "positionId", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.RIGHT);
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 100, -1, "name", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", 150, 150, 150, "sum", true).setTableCellRenderer(DecimalTableCellRenderer.DEFAULT);
            this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", 100, 100, 100, "quantity", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
            this.addColumn("\u0415\u0434\u0438\u043d\u0438\u0446\u044b", 100, 100, 100, "unit", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
        }
    }
}

