/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.server;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnInitServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.SerializeContract;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusContractProgram;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusPayment;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgram;
import ru.bitel.bgbilling.plugins.bonus.common.bonusPrograms.OperationBonusProgram;
import ru.bitel.bgbilling.plugins.bonus.server.dao.BonusDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Period;

public class BGPluginInfo
implements OnInitServer,
SerializeContract,
EventListener<Event> {
    private static final Logger log = LogManager.getLogger();
    int cid;

    public void notify(Event event, EventListenerContext ctx) throws BGException {
        block10: {
            ContractDeleteEvent cdEvent;
            BonusDao bonusDao;
            Connection con;
            block11: {
                String typeOperation;
                int typeIdChargeOrPayment;
                BigDecimal sum;
                block9: {
                    Document doc;
                    Element bonus;
                    con = ctx.getConnection();
                    bonusDao = new BonusDao(con);
                    this.cid = event.getContractId();
                    if (!(event instanceof ContractCreateEvent)) break block9;
                    ContractCreateEvent crEvent = (ContractCreateEvent)event;
                    if (crEvent.isCheck() || (bonus = XMLUtils.selectElement((Node)(doc = crEvent.getPattern().getData()), (String)"data/plugins/bonus")) == null) break block10;
                    bonusDao.updatePluginInclude(this.cid, Utils.parseBoolean((String)bonus.getAttribute("include")));
                    Element addBonusProgram = XMLUtils.selectElement((Node)doc, (String)"data/plugins/bonus/addBonusProgram");
                    if (addBonusProgram != null) {
                        for (Element item : XMLUtils.selectElements((Node)addBonusProgram, (String)"program")) {
                            BonusProgram program = bonusDao.getProgram(Utils.parseInt((String)item.getAttribute("programId")));
                            if (program == null || program.getPeriod().getDateTo() != null && program.getPeriod().getDateTo().compareTo(new Date()) <= 0) continue;
                            bonusDao.updateProgramContract(new BonusContractProgram(this.cid, program, new Period(new Date(), null)));
                        }
                    }
                    break block10;
                }
                if (!(event instanceof PaymentEvent) && !(event instanceof ChargeEvent)) break block11;
                if (event instanceof PaymentEvent) {
                    sum = ((PaymentEvent)event).getPayment().getSum();
                    typeIdChargeOrPayment = ((PaymentEvent)event).getPayment().getTypeId();
                    typeOperation = "1";
                } else {
                    sum = ((ChargeEvent)event).getCharge().getSum();
                    typeIdChargeOrPayment = ((ChargeEvent)event).getCharge().getTypeId();
                    typeOperation = "2";
                }
                if (this.cid <= 0 || !bonusDao.pluginInclude(this.cid) || !bonusDao.checkContractOnProgramType(this.cid, 1, new Date())) break block10;
                List<BonusContractProgram> bonusPrograms = bonusDao.getProgramCotractList(this.cid, 1, new Date());
                for (BonusContractProgram contractProgram : bonusPrograms) {
                    BigDecimal minSum;
                    BonusProgram program = contractProgram.getProgram();
                    if ((!((String)program.getParams().get("typeOperation")).equals("1") || !typeOperation.equals("1")) && (!((String)program.getParams().get("typeOperation")).equals("2") || !typeOperation.equals("2"))) continue;
                    Set typeSet = null;
                    if (program.getParams().get("operationTypeId") != null) {
                        typeSet = Utils.toIntegerSet((String)((String)program.getParams().get("operationTypeId")));
                    }
                    BigDecimal bigDecimal = minSum = program.getParams().get("minSumOperation") != null ? new BigDecimal((String)program.getParams().get("minSumOperation")) : new BigDecimal(0);
                    if (typeSet != null && !typeSet.contains(typeIdChargeOrPayment) || sum.compareTo(minSum) <= -1) continue;
                    OperationBonusProgram operationBonusProgram = new OperationBonusProgram();
                    Period period = operationBonusProgram.getPeriodForBonusPayment(program);
                    BigDecimal bonusSum = operationBonusProgram.getBonusSumAccrual(program, sum);
                    if (bonusSum.compareTo(BigDecimal.ZERO) != 1) continue;
                    BonusPayment bonusPayment = new BonusPayment(0, program.getPaymentTypeId(), new Date(), bonusSum, period.getDateFrom(), period.getDateTo());
                    bonusDao.updatePayment(0, this.cid, bonusPayment);
                }
                break block10;
            }
            if (event instanceof ContractDeleteEvent && !(cdEvent = (ContractDeleteEvent)event).isCheck()) {
                bonusDao.updatePluginInclude(this.cid, false);
                try {
                    PreparedStatement ps = con.prepareStatement("DELETE FROM bonus_contract_program WHERE cid=?");
                    ps.setInt(1, this.cid);
                    ps.executeUpdate();
                    ps.close();
                    ps = con.prepareStatement("DELETE FROM bonus_contract_payment WHERE cid=?");
                    ps.setInt(1, this.cid);
                    ps.executeUpdate();
                    ps.close();
                    ps = con.prepareStatement("DELETE FROM bonus_contract_charge WHERE cid=?");
                    ps.setInt(1, this.cid);
                    ps.executeUpdate();
                    ps.close();
                }
                catch (SQLException e) {
                    throw new BGException((Throwable)e);
                }
            }
        }
    }

    public void onInitServer(String applicationName) {
        try {
            EventProcessor.getInstance().addListener((EventListener)this, PaymentEvent.class);
            EventProcessor.getInstance().addListener((EventListener)this, ChargeEvent.class);
            EventProcessor.getInstance().addListener((EventListener)this, ContractCreateEvent.class);
            EventProcessor.getInstance().addListener((EventListener)this, ContractDeleteEvent.class, 0, null);
        }
        catch (BGException e) {
            log.error("error add event listener", (Throwable)e);
        }
    }

    public void serializeContract(Connection con, int cid, XMLStreamWriter writer, boolean onlyCurrent) throws SQLException, XMLStreamException {
        String cidStr = String.valueOf(cid);
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)writer, (String)"bonus_contract_include", (String)"cid", (String)cidStr, null, (boolean)false, null, null);
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)writer, (String)"bonus_contract_program", (String)"cid", (String)cidStr, null, (boolean)false, null, null);
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)writer, (String)"bonus_contract_payment", (String)"cid", (String)cidStr, null, (boolean)false, null, null);
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)writer, (String)"bonus_contract_charge", (String)"cid", (String)cidStr, null, (boolean)false, null, null);
    }
}

