/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.botmanager.common.bean.Bot;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotType;
import ru.bitel.bgbilling.modules.botmanager.server.bean.UserBotData;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class BotDao
extends AbstractIdDao<Bot> {
    public BotDao(Connection con, int moduleId) {
        this(con, moduleId, "bot_manager_bots");
    }

    private BotDao(Connection con, int moduleId, String tableName) {
        super(con, moduleId, tableName);
    }

    public List<Bot> getBots() throws BGException {
        return super.list(null, null, new Object[0]);
    }

    protected void updateImpl(Bot bot) throws BGException {
        String set = " SET title=?, bot_type=?, token=?, state=?";
        String query = bot.getId() > 0 ? "UPDATE " + this.tableName + set + " WHERE id=?" : "INSERT INTO " + this.tableName + set;
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, bot.getTitle());
            ps.setInt(index++, bot.getBotType().ordinal());
            ps.setString(index++, bot.getToken());
            ps.setInt(index++, bot.getState());
            if (bot.getId() > 0) {
                ps.setInt(index, bot.getId());
            }
            ps.executeUpdate();
            if (bot.getId() <= 0) {
                bot.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected Bot getFromRS(ResultSet rs) throws SQLException, BGException {
        Bot bot = new Bot();
        bot.setId(rs.getInt("id"));
        bot.setBotType(BotType.getTypeByCode((int)rs.getInt("bot_type")));
        bot.setTitle(rs.getString("title"));
        bot.setToken(rs.getString("token"));
        bot.setState(rs.getInt("state"));
        return bot;
    }

    public UserBotData getBotData(int botId) throws BGException {
        UserBotData botData = new UserBotData(botId);
        String query = "SELECT bot_data FROM " + this.tableName + " WHERE id=" + botId;
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            if (rs.next()) {
                HashMap<Long, JSONObject> data = new HashMap<Long, JSONObject>();
                String s = rs.getString("bot_data");
                JSONObject json = new JSONObject(s == null ? "{}" : s);
                json.keySet().forEach(key -> data.put(Long.valueOf(key), new JSONObject(json.get(key))));
                botData.setData(data);
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return botData;
    }

    public void updateBotData(int botId, UserBotData userData) throws BGException {
        JSONObject data = new JSONObject();
        if (userData != null && userData.getData().size() > 0) {
            userData.getData().forEach((chatId, json) -> data.put(String.valueOf(chatId), json));
        }
        String query = "UPDATE " + this.tableName + " SET bot_data=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, data.toString());
            ps.setInt(2, botId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

