/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotDialogElementDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Id;

public class BotDialogDao
extends AbstractIdDao<BotDialog> {
    private BotDialogElementDao dialogElementDao;

    public BotDialogDao(Connection connection, int moduleId) {
        this(connection, moduleId, "bot_dialogs");
        this.dialogElementDao = new BotDialogElementDao(this.con, moduleId);
    }

    private BotDialogDao(Connection con, int moduleId, String tableName) {
        super(con, moduleId, tableName);
    }

    public List<BotDialog> getDialogs() throws BGException {
        return super.list(null, null, new Object[0]);
    }

    public List<BotDialog> getDialogListByGroupId(int groupId) throws BGException {
        ArrayList<BotDialog> result = new ArrayList<BotDialog>();
        String query = null;
        if (groupId == -1) {
            query = "SELECT * FROM " + this.tableName + " WHERE `groups` IS NULL OR `groups`=''";
        } else {
            String dialogGroupsTable = ServerUtils.getModuleTableName((String)"bot_dialog_group", (int)this.moduleId);
            String query1 = "SELECT dialog_ids FROM " + dialogGroupsTable + " as dialog_groups WHERE dialog_groups.id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query1);){
                ResultSet rs;
                if (groupId > 0) {
                    ps.setInt(1, groupId);
                }
                if ((rs = ps.executeQuery()).next()) {
                    String dialogIds = rs.getString("dialog_ids");
                    query = "SELECT * FROM " + this.tableName + " WHERE id IN(" + dialogIds + ")";
                }
                rs.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        if (query != null) {
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
                rs.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return result;
    }

    public BotDialog getByCommand(String command) throws BGException {
        BotDialog result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE command=? LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, command);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRS(rs);
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    protected BotDialog getFromRS(ResultSet rs) throws SQLException, BGException {
        String groupDialogIds;
        BotDialog dialog = new BotDialog();
        dialog.setId(rs.getInt("id"));
        dialog.setTitle(rs.getString("title"));
        dialog.setProcessingClass(rs.getString("processing_class"));
        dialog.setOnlySignedUser(rs.getInt("only_signed") == 1);
        dialog.setCommand(rs.getString("command"));
        String elementsIds = rs.getString("elements_ids");
        if (Utils.notBlankString((String)elementsIds)) {
            dialog.setDialogElements(this.dialogElementDao.getElementsByIds(elementsIds));
        }
        if (Utils.notBlankString((String)(groupDialogIds = rs.getString("groups")))) {
            dialog.setGroups(Utils.toIntegerSet((String)groupDialogIds));
        }
        return dialog;
    }

    protected void updateImpl(BotDialog botDialog) throws BGException, SQLException {
        String set = " SET title=?, elements_ids=?, `groups`=?, processing_class=?, only_signed=?, command=?";
        String query = botDialog.getId() > 0 ? "UPDATE " + this.tableName + set + " WHERE id=?" : "INSERT INTO " + this.tableName + set;
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, botDialog.getTitle());
            String elementsIds = Utils.toString((Iterable)botDialog.getDialogElements().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList()), (String)",");
            ps.setString(index++, elementsIds);
            ps.setString(index++, Utils.toString((Iterable)botDialog.getGroups(), (String)","));
            ps.setString(index++, botDialog.getProcessingClass());
            ps.setInt(index++, botDialog.isOnlySignedUser() ? 1 : 0);
            ps.setString(index++, botDialog.getCommand());
            if (botDialog.getId() > 0) {
                ps.setInt(index, botDialog.getId());
            }
            ps.executeUpdate();
            if (botDialog.getId() <= 0) {
                botDialog.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }
}

