/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.botmanager.common.bean.StatisticNote;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class BotStatisticDao
extends AbstractIdDao<StatisticNote> {
    public BotStatisticDao(Connection con, int moduleId) {
        super(con, moduleId, "bot_manager_statistic");
    }

    public void getList(SearchResult<StatisticNote> searchResult) throws BGException {
        List result = searchResult.getList();
        Page page = searchResult.getPage();
        String where = searchResult.getAttribute("where");
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName;
        if (Utils.notBlankString((String)where)) {
            query = query + " where " + where;
        }
        if (page != null) {
            query = query + page.sqlLimit();
        }
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteByContractId(int contractId) throws BGException {
        this.delete("contract_id=" + contractId, new Object[0]);
    }

    public void deleteByBotId(int botId) throws BGException {
        this.delete("bot_id=" + botId, new Object[0]);
    }

    public List<StatisticNote> getListByContractId(int contractId) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setList(new ArrayList());
        searchResult.setAttribute("where", " contract_id=" + contractId);
        this.getList((SearchResult<StatisticNote>)searchResult);
        return searchResult.getList();
    }

    public List<StatisticNote> getListByBotId(int botId) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setList(new ArrayList());
        searchResult.setAttribute("where", " bot_id=" + botId);
        this.getList((SearchResult<StatisticNote>)searchResult);
        return searchResult.getList();
    }

    public List<StatisticNote> getList(int botId, int cid) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setList(new ArrayList());
        searchResult.setAttribute("where", " bot_id=" + botId + " and contract_id=" + cid);
        this.getList((SearchResult<StatisticNote>)searchResult);
        return searchResult.getList();
    }

    protected StatisticNote getFromRS(ResultSet rs) throws SQLException, BGException {
        return (StatisticNote)this.ormFromResultSet(rs, StatisticNote.class);
    }

    protected void updateImpl(StatisticNote note) throws BGException, SQLException {
        String set = " set contract_id=?, comment=?, bot_id=?, last_dialog_id=?, last_message_time=NOW()";
        boolean isUpdate = this.checkIsUpdate(note);
        Object query = isUpdate ? "update " : "insert into ";
        query = (String)query + this.tableName + set;
        query = isUpdate ? (String)query + " where messenger_user_id=?" : (String)query + ", messenger_user_id=?";
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            int index = 1;
            ps.setInt(index++, note.getContractId());
            ps.setString(index++, note.getComment());
            ps.setInt(index++, note.getBotId());
            ps.setInt(index++, note.getLastViewedDialogId());
            ps.setLong(index, note.getMessengerUserId());
            ps.executeUpdate();
        }
    }

    private boolean checkIsUpdate(StatisticNote note) throws SQLException {
        boolean result = false;
        String query = "select * from " + this.tableName + " where messenger_user_id=" + note.getMessengerUserId();
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                result = true;
            }
        }
        return result;
    }
}

