/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.buyemoney.server.action.web;

import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.buyemoney.common.BuyemoneyStatus;
import ru.bitel.bgbilling.modules.buyemoney.server.action.ActionBase;
import ru.bitel.bgbilling.modules.buyemoney.server.bean.BuyemoneyManager;
import ru.bitel.bgbilling.modules.buyemoney.server.bean.BuyemoneyPayment;
import ru.bitel.bgbilling.modules.buyemoney.server.bean.CurrencyRate;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolCurrency;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolManager;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.TransactionResult;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.util.BGMoney;

public class ActionPay
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        BGMoney sum = this.getMoneyParameter("sum", null);
        int currencyRateId = this.getIntParameter("currency", -1);
        boolean confirm = this.getBooleanParameter("confirm", false);
        String userComment = this.getParameter("userComment", null);
        String userPurse = this.getParameter("purse", null);
        if (currencyRateId == -1) {
            throw new BGMessageException("\u0412\u0430\u043b\u044e\u0442\u0430 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430");
        }
        if (this.cid <= 0 || this.mid <= 0 || sum == null) {
            throw new BGIllegalArgumentException();
        }
        if (sum.compareTo(BGMoney.ZERO) <= 0) {
            throw new BGMessageException("\u0441\u0443\u043c\u043c\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f");
        }
        BuyemoneyManager manager = new BuyemoneyManager(this.con, this.mid);
        CurrencyRate currencyRate = manager.getCurrencyRate(currencyRateId);
        if (currencyRate == null) {
            throw new BGMessageException("\u043d\u0435\u0442 \u0442\u0430\u043a\u043e\u0433\u043e \u043a\u0443\u0440\u0441\u0430 \u0432\u0430\u043b\u044e\u0442\u044b (id='" + currencyRateId + "')");
        }
        if (!TimeUtils.dateInRange((Date)new Date(), (Date)currencyRate.getPeriod().getDateFrom(), (Date)currencyRate.getPeriod().getDateTo()) || !currencyRate.isEnabled()) {
            throw new BGMessageException("\u0432\u0430\u043b\u044e\u0442\u0430 '" + this.getProtocolCurrencyTitle(currencyRate.getProtocolCurrency(), "title") + "' \u0441\u0435\u0433\u043e\u0434\u043d\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
        }
        BGMoney totalSum = currencyRate.getPrice().multiply(sum);
        BalanceUtils bu = new BalanceUtils(this.con);
        BGMoney balance = new BGMoney(bu.getBalance(LocalDate.now(), this.cid));
        bu.close();
        if (totalSum.compareTo(balance) > 0) {
            throw new BGMessageException("\u041d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0434\u0435\u043d\u0435\u0433. \u0421\u0443\u043c\u043c\u0430 " + totalSum.toString() + ", \u0431\u0430\u043b\u0430\u043d\u0441 " + balance.toString());
        }
        ProtocolManager protocolManager = new ProtocolManager((ParameterMap)this.moduleSetup, log);
        ProtocolCurrency pcurrency = protocolManager.getProtocols().get(currencyRate.getProtocolCurrency());
        int purseMode = Utils.parseInt((String)pcurrency.getProtocolParameter("purseMode"));
        String purse = null;
        if (purseMode == 1) {
            contractDao = new ContractDao(this.con, 0);
            try {
                pursePid = Utils.parseInt((String)pcurrency.getProtocolParameter("pursePid"));
                purse = contractDao.getContractParameterTextAsString(this.cid, pursePid).orElse(null);
            }
            finally {
                contractDao.close();
            }
        } else if (purseMode == 2) {
            purse = userPurse;
        } else if (purseMode == 3) {
            contractDao = new ContractDao(this.con, 0);
            try {
                pursePid = Utils.parseInt((String)pcurrency.getProtocolParameter("pursePid"));
                purse = contractDao.getContractParameterTextAsString(this.cid, pursePid).orElse(userPurse);
            }
            finally {
                contractDao.close();
            }
        } else {
            throw new BGException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0441\u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u043c\u043e\u0434\u0443\u043b\u044c (\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 'purseMode')");
        }
        if (Utils.isBlankString((String)purse)) {
            throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043a\u043e\u0448\u0435\u043b\u0451\u043a \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u0430");
        }
        String transactCommentTemplate = pcurrency.getProtocolParameter("transactCommentTemplate");
        int chargeType = Utils.parseInt((String)pcurrency.getProtocolParameter("chargeType"));
        String chargeCommentTemplate = pcurrency.getProtocolParameter("chargeCommentTemplate");
        this.rootNode.setAttribute("sum", sum.toString());
        this.rootNode.setAttribute("currency", String.valueOf(currencyRateId));
        this.rootNode.setAttribute("currencytitle", this.getProtocolCurrencyTitle(currencyRate.getProtocolCurrency(), "title"));
        this.rootNode.setAttribute("balance", balance.toString());
        this.rootNode.setAttribute("sumtotal", totalSum.toString());
        this.rootNode.setAttribute("purse", purse);
        this.rootNode.setAttribute("userComment", userComment);
        if (confirm) {
            BuyemoneyPayment payment = new BuyemoneyPayment();
            payment.setCid(this.cid);
            payment.setDate(new Date());
            payment.setRateId(currencyRate.getId());
            payment.setStatus(BuyemoneyStatus.NEW);
            payment.setSumcur(sum);
            payment.setSumtotal(totalSum);
            payment.setComment("\u041d\u043e\u0432\u044b\u0439 \u043f\u043b\u0430\u0442\u0451\u0436");
            payment.setPurse(purse);
            manager.addPayment(payment);
            String transactComment = manager.formatComment(transactCommentTemplate, payment, userComment, protocolManager);
            TransactionResult result = null;
            try {
                result = pcurrency.transact(payment.getId(), purse, sum, transactComment);
            }
            catch (Exception e) {
                payment.setComment("\u041e\u0448\u0438\u0431\u043a\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 (" + e.getMessage() + ")");
                payment.setStatus(BuyemoneyStatus.FAIL);
                manager.updatePayment(payment);
                log.error("error buyemoney transact", (Throwable)e);
                throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438.\n" + e.getMessage());
            }
            if (result.getDate() != null) {
                payment.setDate(result.getDate());
            }
            payment.setComment(result.getComment());
            payment.setStatus(result.getStatus());
            if (result.getStatus() == BuyemoneyStatus.OK) {
                try {
                    String commentCharge = manager.formatComment(chargeCommentTemplate, payment, userComment, protocolManager);
                    manager.carryOutCharge(payment, chargeType, commentCharge);
                }
                catch (Exception e) {
                    payment.setComment("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0438 \u0440\u0430\u0441\u0445\u043e\u0434\u0430 (" + e.getMessage() + ")");
                    payment.setStatus(BuyemoneyStatus.NEW);
                    manager.updatePayment(payment);
                    log.error("error carryOutCharge", (Throwable)e);
                    throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0438 \u0440\u0430\u0441\u0445\u043e\u0434\u0430.\n" + e.getMessage());
                }
            }
            manager.updatePayment(payment);
            String comment = null;
            switch (result.getStatus()) {
                case OK: {
                    comment = "\u041f\u043b\u0430\u0442\u0451\u0436 #" + payment.getId() + " \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0451\u043d.";
                    break;
                }
                case FAIL: {
                    comment = "\u041f\u043b\u0430\u0442\u0451\u0436 #" + payment.getId() + " \u043f\u0440\u043e\u0432\u0435\u0434\u0451\u043d \u0441 \u043e\u0448\u0438\u0431\u043a\u043e\u0439. " + result.getComment();
                    break;
                }
                case NEW: {
                    comment = "\u041f\u043b\u0430\u0442\u0451\u0436 #" + payment.getId() + " \u0441\u0434\u0435\u043b\u0430\u043d. " + result.getComment() + ". \u0416\u0434\u0438\u0442\u0435 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0435 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438.";
                }
            }
            this.setMsg(comment);
            log.info(comment);
        }
    }
}

