/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cticas4.CtiCas4Con;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class CtiCas4ServiceActivator
extends DigitalTVServiceActivator {
    private static final Logger log = LogManager.getLogger();
    private CtiCas4Con con = null;

    private CtiCas4Con getConnection(int serverId, UserCard userCard) throws BGException {
        ParameterMap moduleSetup = this.getModuleSetup(userCard);
        ParameterMap connectionSetup = moduleSetup.sub("server." + serverId + ".");
        CtiCas4Con newconnect = new CtiCas4Con(connectionSetup, serverId);
        try {
            if (this.con == null) {
                newconnect.connect();
                this.con = newconnect;
            } else {
                this.con.tuneconnect(newconnect);
            }
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
        return this.con;
    }

    @Override
    public void destroy() {
        if (this.con != null) {
            try {
                this.con.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.con = null;
        }
    }

    public CtiCas4ServiceActivator(ParameterMap moduleSetup, Connection con, Connection conSlave, int mid, Calendar time) throws BGException {
        super(moduleSetup, con, conSlave, mid, time);
    }

    private static void smartSynchronize(CtiCas4Con con, long cardNumber, List<DigitalTVServiceActivator.CardPacketCodePair> billingSubscription) throws Exception {
        List<Integer> casSubscription = con.getSubscribeInfo(cardNumber);
        ArrayList<DigitalTVServiceActivator.CardPacketCodePair> toAdd = new ArrayList<DigitalTVServiceActivator.CardPacketCodePair>();
        ArrayList<Integer> toCancel = new ArrayList<Integer>();
        CtiCas4ServiceActivator.subscribeEqualizer(billingSubscription, casSubscription, toAdd, toCancel, new CtiCas4SubscriptionInfo());
        if (!toCancel.isEmpty()) {
            if (toCancel.equals(casSubscription)) {
                con.cancelAllPackage(cardNumber);
            } else {
                con.packageCancel(cardNumber, toCancel);
            }
        }
        if (!toAdd.isEmpty()) {
            ArrayList<Integer> packagesId = new ArrayList<Integer>();
            for (DigitalTVServiceActivator.CardPacketCodePair pairCardPacketPacketCode : toAdd) {
                packagesId.add(Utils.parseInt((String)pairCardPacketPacketCode.packetCode.trim(), (int)0));
            }
            con.packageAuthorization(cardNumber, packagesId);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult modifyImpl(UserCard card, List<CardPacket> cardPacketList) {
        CtiCas4Con con = null;
        try {
            con = this.getConnection(0, card);
            List<DigitalTVServiceActivator.CardPacketCodePair> cpcl = this.getCardPacketCodePairList(cardPacketList, false, true);
            CtiCas4ServiceActivator.smartSynchronize(con, card.getNumber(), cpcl);
        }
        catch (Exception ex) {
            log.error("Exception in modifyImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(long cardNumber) {
        log.info("Closing card " + cardNumber);
        CtiCas4Con con = null;
        try {
            con = this.getConnection(0, null);
            CtiCas4ServiceActivator.smartSynchronize(con, cardNumber, Collections.emptyList());
        }
        catch (Exception ex) {
            log.error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u043d\u043e\u0439 \u043e\u0442\u043c\u0435\u043d\u044b \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(UserCard card, List<CardPacket> cardPacketList) {
        log.info("Closing card: " + card.getNumber() + ", cardPackets count: " + cardPacketList.size());
        CtiCas4Con con = null;
        try {
            con = this.getConnection(0, card);
            CtiCas4ServiceActivator.smartSynchronize(con, card.getNumber(), Collections.emptyList());
        }
        catch (Exception ex) {
            log.error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u043c\u0435\u043d\u044b \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult sendMessagesImpl(List<Long> cardNumbers, String title, String message, boolean ismail) {
        CtiCas4Con con = null;
        try {
            if (cardNumbers == null) {
                con = this.getConnection(0, null);
                long messageId = this.sequentialIdManager.generateSequentialId();
                if (ismail) {
                    con.sendEmailToAllTheUser(title, message, messageId);
                } else {
                    con.sendOSDToAllTheUsers(title, message, messageId);
                }
            } else {
                for (Long cardNumber : cardNumbers) {
                    UserCard userCard = this.userCardManager.getUserCard((long)cardNumber, new Date());
                    con = this.getConnection(0, userCard);
                    long messageId = this.sequentialIdManager.generateSequentialId();
                    if (ismail) {
                        con.sendSingleUserEmail(cardNumber, title, message, messageId);
                        continue;
                    }
                    con.sentOSDToASingleUser(cardNumber, title, message, messageId);
                }
            }
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            log.error("Exception sendMessagesImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult activateImpl(long cardNumber, UserCard card, List<CardPacket> cardPacketList) {
        CtiCas4Con con = null;
        try {
            con = this.getConnection(0, card);
            con.registerSmartcard(cardNumber);
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            log.error("Exception activateImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult deactivateImpl(long cardNumber) {
        CtiCas4Con con = null;
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            con = this.getConnection(0, userCard);
            con.unregisterSmartcard(cardNumber);
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            log.error("Exception deactivateImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult getSubscribeInfoImpl(long cardNumber) {
        StringBuilder infotext = new StringBuilder(64);
        String logline1 = "get subscribe card: " + cardNumber;
        log.info(logline1);
        infotext.append(logline1).append("\n");
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            CtiCas4Con con = this.getConnection(0, userCard);
            List<Integer> packages = con.getSubscribeInfo(cardNumber);
            if (packages.size() == 0) {
                infotext.append("none\n");
            } else {
                infotext.append(Utils.toString(packages)).append("\n");
            }
        }
        catch (Exception ex) {
            log.error("Exception getSubscribeInfoImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438", ex);
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(true, infotext.toString(), null, null);
    }

    private static class CtiCas4SubscriptionInfo
    implements DigitalTVServiceActivator.SubscriptionComparatorForEqualizer<Integer> {
        private CtiCas4SubscriptionInfo() {
        }

        @Override
        public boolean subscriptionEquals(DigitalTVServiceActivator.CardPacketCodePair bgCardpacket, Integer casPacket) {
            return bgCardpacket.packetCode.trim().equals(String.valueOf(casPacket));
        }
    }
}

