/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import bitel.billing.server.contract.object.bean.ObjectManager;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.util.SequentialIdManager;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ObjectParameterGroupAttrDao;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.ChannelMapping;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.PacketChannel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.SynclogEntry;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserDevice;
import ru.bitel.bgbilling.modules.cerbercrypt.server.CerbercryptServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.ChannelMappingManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.GraduallySubscriptionManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.PacketChannelManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.PacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.ServersManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.SynclogManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserDeviceManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.locker.ChannelMappingFinder;
import ru.bitel.bgbilling.modules.cerbercrypt.server.locker.PacketChannelFinder;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.util.RangedLongSet;

public abstract class DigitalTVServiceActivator
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger();
    private final ParameterMap moduleSetup;
    protected final ServersManager serversManager;
    protected PacketChannelManager packetChannelManager;
    protected ChannelMappingManager mappingManager;
    protected PacketChannelFinder channelFinder;
    protected ChannelMappingFinder mappingFinder;
    protected PacketManager packetManager;
    protected SequentialIdManager sequentialIdManager;
    protected UserCardManager userCardManager;
    protected UserDeviceManager userDeviceManager;
    protected GraduallySubscriptionManager graduallySubscriptionManager;
    protected int periodGraduallySubscription;
    protected CardManager cardManager;
    protected CardPacketManager cardPacketManager;
    protected SynclogManager synclogManager;
    private RangedLongSet synclogFilterCardRange = null;
    private Set<String> synclogFilterCommands = null;
    protected Connection conMaster;
    protected Connection conSlave;
    protected ContractDao contractDao;
    protected ContractObjectDao contractObjectDao;
    protected ObjectParameterGroupAttrDao contractObjectParamDao;
    protected ObjectManager objectManager;

    public DigitalTVServiceActivator(ParameterMap moduleSetup, Connection conMaster, Connection conSlave, int moduleId, Calendar time) throws BGException {
        String sloggingcommands;
        Setup setup = Setup.getSetup();
        this.moduleSetup = moduleSetup;
        this.conMaster = conMaster;
        this.conSlave = conSlave;
        this.serversManager = new ServersManager(moduleSetup);
        this.packetChannelManager = new PacketChannelManager(conSlave, moduleId);
        this.mappingManager = new ChannelMappingManager(conSlave, moduleId);
        this.channelFinder = new PacketChannelFinder(this.packetChannelManager.getPacketChannelList(time));
        this.mappingFinder = new ChannelMappingFinder(this.mappingManager.getChannelMappingList(TimeUtils.convertCalendarToDate((Calendar)time)));
        this.packetManager = new PacketManager(conSlave, moduleId);
        this.sequentialIdManager = new SequentialIdManager(setup, String.valueOf(moduleId));
        this.userCardManager = new UserCardManager(conSlave, moduleId, 0);
        this.userDeviceManager = new UserDeviceManager(conSlave, moduleId);
        this.graduallySubscriptionManager = new GraduallySubscriptionManager(conSlave, moduleId);
        this.periodGraduallySubscription = moduleSetup.getInt("period.gradually.subscription", 30);
        this.cardManager = new CardManager(conSlave, moduleId, 0);
        this.cardPacketManager = new CardPacketManager(conSlave, moduleId);
        this.synclogManager = new SynclogManager(conMaster, moduleId);
        String sloggingcardrange = this.moduleSetup.get("logging.card.range");
        if (sloggingcardrange != null) {
            this.synclogFilterCardRange = "*".equals(sloggingcardrange) ? new RangedLongSet(new long[]{-1L, -1L}) : RangedLongSet.parseString((String)sloggingcardrange);
        }
        if ((sloggingcommands = this.moduleSetup.get("logging.commands")) != null) {
            this.synclogFilterCommands = Utils.toSet((String)sloggingcommands);
        }
        this.contractDao = new ContractDao(conSlave, 0);
        this.contractObjectDao = new ContractObjectDao(conSlave, 0);
        this.contractObjectParamDao = new ObjectParameterGroupAttrDao(conSlave);
        this.objectManager = new ObjectManager(conSlave);
    }

    protected ParameterMap getModuleSetup(UserCard userCard) throws BGException {
        if (userCard != null) {
            UserDevice userDevice = (UserDevice)this.userDeviceManager.get(userCard.getUserdeviceId());
            if (userDevice != null && userDevice.getConfig() != null) {
                Preferences p = new Preferences(userDevice.getConfig(), "\n");
                ParameterMap current = this.moduleSetup.inherit((ParameterMap)p);
                return current;
            }
            return this.moduleSetup;
        }
        return this.moduleSetup;
    }

    protected void destroy() {
    }

    @Override
    public void close() {
        this.destroy();
        try {
            this.userCardManager.close();
            this.userDeviceManager.close();
            this.graduallySubscriptionManager.close();
            this.synclogManager.close();
            this.contractDao.close();
            this.contractObjectDao.close();
            this.contractObjectParamDao.close();
        }
        catch (BGException e) {
            log.error("error close activator", (Throwable)e);
        }
    }

    public void checkSynchronizerBeforeDestroy() throws BGException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceActivationResult modify(UserCard card, List<CardPacket> cardPacketList) {
        SynclogEntry synclogEntry = new SynclogEntry(card.getNumber(), card.getId(), "modify");
        log.debug("modify " + card.getNumber());
        try {
            ServiceActivationResult sar = this.modifyImpl(card, cardPacketList);
            synclogEntry.setStatus(sar.isResult(), sar.getMessage(), sar.getLoginfo(), (Throwable)sar.getNestedException());
            ServiceActivationResult serviceActivationResult = sar;
            return serviceActivationResult;
        }
        catch (BGException e) {
            log.error("Exception in modify", (Throwable)e);
            synclogEntry.setStatus(false, "Exception in modify", null, (Throwable)e);
            ServiceActivationResult serviceActivationResult = new ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430.", null, (Exception)((Object)e));
            return serviceActivationResult;
        }
        finally {
            this.writeSynclogEntry(synclogEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceActivationResult cancel(long cardCode) {
        SynclogEntry synclogEntry = new SynclogEntry(cardCode, -1, "cancel");
        log.debug("cancel " + cardCode);
        try {
            ServiceActivationResult sar = this.cancelImpl(cardCode);
            synclogEntry.setStatus(sar.isResult(), sar.getMessage(), sar.getLoginfo(), (Throwable)sar.getNestedException());
            ServiceActivationResult serviceActivationResult = sar;
            return serviceActivationResult;
        }
        catch (BGException e) {
            log.error("Exception in cancel", (Throwable)e);
            synclogEntry.setStatus(false, "Exception in cancel", null, (Throwable)e);
            ServiceActivationResult serviceActivationResult = new ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430.", null, (Exception)((Object)e));
            return serviceActivationResult;
        }
        finally {
            this.writeSynclogEntry(synclogEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceActivationResult cancel(UserCard card, List<CardPacket> cardPacketList) {
        SynclogEntry synclogEntry = new SynclogEntry(card.getNumber(), card.getId(), "cancel");
        log.debug("cancel " + card.getNumber());
        try {
            ServiceActivationResult sar = this.cancelImpl(card, cardPacketList);
            synclogEntry.setStatus(sar.isResult(), sar.getMessage(), sar.getLoginfo(), (Throwable)sar.getNestedException());
            ServiceActivationResult serviceActivationResult = sar;
            return serviceActivationResult;
        }
        catch (BGException e) {
            log.error("Exception in cancel", (Throwable)e);
            synclogEntry.setStatus(false, "Exception in cancel", null, (Throwable)e);
            ServiceActivationResult serviceActivationResult = new ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430.", null, (Exception)((Object)e));
            return serviceActivationResult;
        }
        finally {
            this.writeSynclogEntry(synclogEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceActivationResult sendMessages(List<Long> cardNumbers, String title, String message, boolean ismail) {
        SynclogEntry synclogEntry = new SynclogEntry(cardNumbers != null && cardNumbers.size() == 1 ? cardNumbers.get(0) : 0L, -1, "sendMessages");
        log.debug("sendMessages (" + title + "|" + message + ") to " + (String)(cardNumbers != null ? cardNumbers.size() + " cards" : "all"));
        try {
            ServiceActivationResult sar = this.sendMessagesImpl(cardNumbers, title, message, ismail);
            synclogEntry.setStatus(sar.isResult(), sar.getMessage(), sar.getLoginfo(), (Throwable)sar.getNestedException());
            ServiceActivationResult serviceActivationResult = sar;
            return serviceActivationResult;
        }
        catch (BGException e) {
            log.error("Exception in sendMessages", (Throwable)e);
            synclogEntry.setStatus(false, "Exception in sendMessages", null, (Throwable)e);
            ServiceActivationResult serviceActivationResult = new ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430.", null, (Exception)((Object)e));
            return serviceActivationResult;
        }
        finally {
            this.writeSynclogEntry(synclogEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceActivationResult parentalPinCode(long cardNumber, String pinCode) {
        SynclogEntry synclogEntry = new SynclogEntry(cardNumber, -1, "parentalPin");
        log.debug("parentalPinCode " + cardNumber);
        try {
            ServiceActivationResult sar = this.parentalPinCodeImpl(cardNumber, pinCode);
            synclogEntry.setStatus(sar.isResult(), sar.getMessage(), sar.getLoginfo(), (Throwable)sar.getNestedException());
            ServiceActivationResult serviceActivationResult = sar;
            return serviceActivationResult;
        }
        catch (BGException e) {
            log.error("Exception in parentalPinCode", (Throwable)e);
            synclogEntry.setStatus(false, "Exception in parentalPinCode", null, (Throwable)e);
            ServiceActivationResult serviceActivationResult = new ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430.", null, (Exception)((Object)e));
            return serviceActivationResult;
        }
        finally {
            this.writeSynclogEntry(synclogEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceActivationResult activate(long cardNumber, UserCard card, List<CardPacket> cardPacketList) {
        SynclogEntry synclogEntry = new SynclogEntry(cardNumber, card != null ? card.getId() : -1, "activate");
        log.debug("activate " + cardNumber);
        try {
            ServiceActivationResult sar = this.activateImpl(cardNumber, card, cardPacketList);
            synclogEntry.setStatus(sar.isResult(), sar.getMessage(), sar.getLoginfo(), (Throwable)sar.getNestedException());
            ServiceActivationResult serviceActivationResult = sar;
            return serviceActivationResult;
        }
        catch (BGException e) {
            log.error("Exception in activate", (Throwable)e);
            synclogEntry.setStatus(false, "Exception in activate", null, (Throwable)e);
            ServiceActivationResult serviceActivationResult = new ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430.", null, (Exception)((Object)e));
            return serviceActivationResult;
        }
        finally {
            this.writeSynclogEntry(synclogEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceActivationResult deactivate(long cardNumber) {
        SynclogEntry synclogEntry = new SynclogEntry(cardNumber, -1, "deactivate");
        log.debug("deactivate " + cardNumber);
        try {
            ServiceActivationResult sar = this.deactivateImpl(cardNumber);
            synclogEntry.setStatus(sar.isResult(), sar.getMessage(), sar.getLoginfo(), (Throwable)sar.getNestedException());
            ServiceActivationResult serviceActivationResult = sar;
            return serviceActivationResult;
        }
        catch (BGException e) {
            log.error("Exception in deactivate", (Throwable)e);
            synclogEntry.setStatus(false, "Exception in deactivate", null, (Throwable)e);
            ServiceActivationResult serviceActivationResult = new ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430.", null, (Exception)((Object)e));
            return serviceActivationResult;
        }
        finally {
            this.writeSynclogEntry(synclogEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceActivationResult getSubscribeInfo(long cardNumber) {
        SynclogEntry synclogEntry = new SynclogEntry(cardNumber, -1, "getsubscribeinfo");
        log.debug("getSubscribeInfo " + cardNumber);
        try {
            ServiceActivationResult sar = this.getSubscribeInfoImpl(cardNumber);
            synclogEntry.setStatus(sar.isResult(), sar.getMessage(), sar.getLoginfo(), (Throwable)sar.getNestedException());
            ServiceActivationResult serviceActivationResult = sar;
            return serviceActivationResult;
        }
        catch (BGException e) {
            log.error("Exception in getSubscribeInfo", (Throwable)e);
            synclogEntry.setStatus(false, "Exception in getSubscribeInfo", null, (Throwable)e);
            ServiceActivationResult serviceActivationResult = new ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430.", null, (Exception)((Object)e));
            return serviceActivationResult;
        }
        finally {
            this.writeSynclogEntry(synclogEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceActivationResult getPairing(long cardNumber) {
        SynclogEntry synclogEntry = new SynclogEntry(cardNumber, -1, "getpairing");
        log.debug("getPairing " + cardNumber);
        try {
            ServiceActivationResult sar = this.getPairingImpl(cardNumber);
            synclogEntry.setStatus(sar.isResult(), sar.getMessage(), sar.getLoginfo(), (Throwable)sar.getNestedException());
            ServiceActivationResult serviceActivationResult = sar;
            return serviceActivationResult;
        }
        catch (BGException e) {
            log.error("Exception in getPairing", (Throwable)e);
            synclogEntry.setStatus(false, "Exception in getPairing", null, (Throwable)e);
            ServiceActivationResult serviceActivationResult = new ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430.", null, (Exception)((Object)e));
            return serviceActivationResult;
        }
        finally {
            this.writeSynclogEntry(synclogEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceActivationResult setPairing(long cardNumber, String pairingModule) {
        SynclogEntry synclogEntry = new SynclogEntry(cardNumber, -1, "setpairing");
        log.debug("setPairing " + cardNumber + ":" + pairingModule);
        try {
            ServiceActivationResult sar = this.setPairingImpl(cardNumber, pairingModule);
            synclogEntry.setStatus(sar.isResult(), sar.getMessage(), sar.getLoginfo(), (Throwable)sar.getNestedException());
            ServiceActivationResult serviceActivationResult = sar;
            return serviceActivationResult;
        }
        catch (BGException e) {
            log.error("Exception in setPairing", (Throwable)e);
            synclogEntry.setStatus(false, "Exception in setPairing", null, (Throwable)e);
            ServiceActivationResult serviceActivationResult = new ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430.", null, (Exception)((Object)e));
            return serviceActivationResult;
        }
        finally {
            this.writeSynclogEntry(synclogEntry);
        }
    }

    private void writeSynclogEntry(SynclogEntry synclogEntry) {
        try {
            if (this.synclogFilterCommands != null && this.synclogFilterCardRange != null && this.synclogFilterCommands.contains(synclogEntry.getOperation()) && (this.synclogFilterCardRange.contains((Object)synclogEntry.getNumber()) || this.synclogFilterCardRange.contains((Object)-1))) {
                if (log.isDebugEnabled()) {
                    log.debug("write synclog entry: " + synclogEntry);
                }
                synclogEntry.setDate(new Date());
                this.synclogManager.update(synclogEntry);
                this.synclogManager.commit();
            }
        }
        catch (BGException e) {
            log.error("Exception in write synclog", (Throwable)e);
        }
    }

    protected Map<Integer, List<String>> getCardServerMaskMap(List<CardPacket> cardPacketList) {
        HashMap<Integer, List<String>> maskMap = new HashMap<Integer, List<String>>();
        for (CardPacket cardPacket : cardPacketList) {
            List<PacketChannel> packetChannelList;
            if (log.isDebugEnabled()) {
                log.debug("Processing CardPacket: " + cardPacket.toString());
            }
            if ((packetChannelList = this.channelFinder.getPacketChannelList(cardPacket.getPacketId())) == null) {
                log.debug("Not found channels for packet");
                continue;
            }
            for (PacketChannel packetChannel : packetChannelList) {
                log.debug(packetChannel.toString());
                List<ChannelMapping> channelMappingList = this.mappingFinder.getChannelMappingList(packetChannel.getChannelId());
                if (channelMappingList == null) {
                    log.debug("Not found mappings for channel");
                    continue;
                }
                for (ChannelMapping channelMapping : channelMappingList) {
                    log.debug(channelMapping.toString());
                    int serverCode = channelMapping.getServerCode();
                    ArrayList<String> mask = (ArrayList<String>)maskMap.get(serverCode);
                    if (mask == null) {
                        mask = new ArrayList<String>();
                        maskMap.put(serverCode, mask);
                    }
                    mask.add(channelMapping.getChannelCode());
                }
            }
        }
        return maskMap;
    }

    protected List<CardPacketCodePair> getCardPacketCodePairList(List<CardPacket> cardPacketList, boolean allowEmptyPacketCode, boolean allowEmptyPacketServerCode) throws BGException {
        boolean allowMultiplePacketCode = true;
        boolean allowEqualsPacketCode = false;
        return this.getCardPacketCodePairList(cardPacketList, allowEmptyPacketCode, allowEmptyPacketServerCode, allowMultiplePacketCode, allowEqualsPacketCode);
    }

    protected List<CardPacketCodePair> getCardPacketCodePairList(List<CardPacket> cardPacketList, boolean allowEmptyPacketCode, boolean allowEmptyPacketServerCode, boolean allowMultiplePacketCode, boolean allowEqualsPacketCode) throws BGException {
        ArrayList<CardPacketCodePair> packetCodeList = new ArrayList<CardPacketCodePair>();
        HashSet<String> allPacketCode = new HashSet<String>();
        Map<Integer, Packet> packetMap = this.packetManager.getPacketMap();
        Map<Integer, UserCard> userCardMap = this.userCardManager.getUserCardMap();
        for (CardPacket cardPacket : cardPacketList) {
            Packet packet;
            if (log.isDebugEnabled()) {
                log.debug("Processing CardPacket: " + cardPacket.toString());
            }
            if ((packet = packetMap.get(cardPacket.getPacketId())) == null) {
                log.error("Ignore CardPacket, not found packet id=" + cardPacket.getPacketId());
                continue;
            }
            if (!allowEmptyPacketCode && Utils.isBlankString((String)packet.getPacketCode())) {
                log.error("Ignore CardPacket, empty packet-code packet-id=" + cardPacket.getPacketId());
                continue;
            }
            if (!allowEmptyPacketServerCode && Utils.isBlankString((String)packet.getPacketServerCode())) {
                log.error("Ignore CardPacket, empty packet-server-code packet-id=" + cardPacket.getPacketId());
                continue;
            }
            UserCard usercard = userCardMap.get(cardPacket.getUsercardId());
            if (usercard == null) {
                log.error("Ignore CardPacket, not found usercard id=" + cardPacket.getUsercardId());
                continue;
            }
            if (allowMultiplePacketCode && packet.getPacketCode() != null && packet.getPacketCode().contains(",")) {
                log.debug("detect multiple CardPacket-code: " + packet.getPacketCode());
                for (String packetCode : packet.getPacketCode().split(",")) {
                    if (!allowEqualsPacketCode && Utils.notBlankString((String)packetCode) && allPacketCode.contains(packetCode)) {
                        log.error("Ignore CardPacket, not allowEqualsPacketCode, but dublicate packet-code (" + packetCode + ") packet-id=" + cardPacket.getPacketId());
                        continue;
                    }
                    packetCodeList.add(new CardPacketCodePair(cardPacket, usercard.getNumber(), packetCode, packet.getPacketServerCode()));
                    allPacketCode.add(packetCode);
                }
                continue;
            }
            if (!allowEqualsPacketCode && Utils.notBlankString((String)packet.getPacketCode()) && allPacketCode.contains(packet.getPacketCode())) {
                log.error("Ignore CardPacket, not allowEqualsPacketCode, but dublicate packet-code (" + packet.getPacketCode() + ") packet-id=" + cardPacket.getPacketId());
                continue;
            }
            packetCodeList.add(new CardPacketCodePair(cardPacket, usercard.getNumber(), packet.getPacketCode(), packet.getPacketServerCode()));
            allPacketCode.add(packet.getPacketCode());
        }
        return packetCodeList;
    }

    public static <T> void subscribeEqualizer(List<CardPacketCodePair> billingSubscription, List<T> casSubscription, List<CardPacketCodePair> toAdd, List<T> toCancel, SubscriptionComparatorForEqualizer<T> comparator) {
        if (billingSubscription.isEmpty()) {
            if (!casSubscription.isEmpty()) {
                log.debug("smart synchronize: bg-subscription is empty, cas-subscription not empty, need remove all from cas...");
                toCancel.addAll(casSubscription);
            } else {
                log.debug("smart synchronize: bg-subscription and cas-subscription is empty (i.e. equals), need exit...");
            }
        } else if (casSubscription.isEmpty()) {
            log.debug("smart synchronize: bg-subscription not empty, cas-subscription is empty, need add all bg-subscription to cas...");
            toAdd.addAll(billingSubscription);
        } else {
            ArrayList<CardPacketCodePair> toAddCandidates = new ArrayList<CardPacketCodePair>(billingSubscription);
            ArrayList<T> toCancelCandidates = new ArrayList<T>(casSubscription);
            Iterator casIterator = toCancelCandidates.iterator();
            while (casIterator.hasNext()) {
                Object casItem = casIterator.next();
                Iterator blngIterator = toAddCandidates.iterator();
                while (blngIterator.hasNext()) {
                    CardPacketCodePair blngItem = (CardPacketCodePair)blngIterator.next();
                    if (comparator.subscriptionEquals(blngItem, casItem)) {
                        log.trace("smart synchronize: compare: subscription equal bg-subscription \"" + blngItem + "\", cas-subscription \"" + casItem + "\"");
                        blngIterator.remove();
                        casIterator.remove();
                        continue;
                    }
                    log.trace("smart synchronize: compare: subscription not equal bg-subscription \"" + blngItem + "\", cas-subscription \"" + casItem + "\"");
                }
            }
            toAdd.addAll(toAddCandidates);
            toCancel.addAll(toCancelCandidates);
            if (toAdd.isEmpty() && toCancel.isEmpty()) {
                log.debug("smart synchronize: bg-subscription and cas-subscription equals (" + billingSubscription.size() + " items), need exit...");
            } else {
                log.debug("smart synchronize: bg-subscription " + billingSubscription.size() + " items, cas-subscription " + casSubscription.size() + " items => need " + toCancel.size() + " cancel command, " + toAdd.size() + " add command...");
            }
        }
    }

    public static DigitalTVServiceActivator newInstance(ParameterMap moduleSetup, Connection conMaster, int mid, Calendar time) throws BGException {
        return DigitalTVServiceActivator.newInstance(moduleSetup, conMaster, conMaster, mid, time);
    }

    public static DigitalTVServiceActivator newInstance(ParameterMap moduleSetup, Connection conMaster, Connection conSlave, int mid, Calendar time) throws BGException {
        try {
            Class<?> uclazz = Class.forName(moduleSetup.get("sa", CerbercryptServiceActivator.class.getName()));
            Class<DigitalTVServiceActivator> clazz = uclazz.asSubclass(DigitalTVServiceActivator.class);
            Constructor<DigitalTVServiceActivator> constructor = clazz.getConstructor(ParameterMap.class, Connection.class, Connection.class, Integer.TYPE, Calendar.class);
            return constructor.newInstance(moduleSetup, conMaster, conSlave, mid, time);
        }
        catch (Exception e) {
            throw new BGException("error create activator instance", (Throwable)e);
        }
    }

    protected abstract ServiceActivationResult cancelImpl(long var1) throws BGException;

    protected abstract ServiceActivationResult modifyImpl(UserCard var1, List<CardPacket> var2) throws BGException;

    protected abstract ServiceActivationResult cancelImpl(UserCard var1, List<CardPacket> var2) throws BGException;

    protected ServiceActivationResult sendMessagesImpl(List<Long> cardNumbers, String title, String message, boolean ismail) throws BGException {
        throw new UnsupportedOperationException();
    }

    protected ServiceActivationResult parentalPinCodeImpl(long cardNumber, String pinCode) throws BGException {
        throw new UnsupportedOperationException();
    }

    protected ServiceActivationResult activateImpl(long cardNumber, UserCard card, List<CardPacket> cardPacketList) throws BGException {
        throw new UnsupportedOperationException();
    }

    protected ServiceActivationResult deactivateImpl(long cardNumber) throws BGException {
        throw new UnsupportedOperationException();
    }

    protected ServiceActivationResult getSubscribeInfoImpl(long cardNumber) throws BGException {
        throw new UnsupportedOperationException();
    }

    public void checkChannelMapping(ChannelMapping cm) throws BGException {
    }

    protected ServiceActivationResult getPairingImpl(long cardNumber) throws BGException {
        throw new UnsupportedOperationException();
    }

    protected ServiceActivationResult setPairingImpl(long cardNumber, String pairingModule) throws BGException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceActivationResult customCommand(long cardNumber, String action, String[] params) {
        if (params == null) {
            params = new String[]{};
        }
        String commandName = "custom(" + action + ")";
        SynclogEntry synclogEntry = new SynclogEntry(cardNumber, -1, commandName);
        log.debug(commandName + " to " + cardNumber + " with params: " + Arrays.toString(params));
        try {
            ServiceActivationResult sar = this.customCommandImpl(cardNumber, action, params);
            synclogEntry.setStatus(sar.isResult(), sar.getMessage(), sar.getLoginfo(), (Throwable)sar.getNestedException());
            ServiceActivationResult serviceActivationResult = sar;
            return serviceActivationResult;
        }
        catch (BGException e) {
            log.error("Exception in " + commandName, (Throwable)e);
            synclogEntry.setStatus(false, "Exception in " + commandName, null, (Throwable)e);
            ServiceActivationResult serviceActivationResult = new ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430.", null, (Exception)((Object)e));
            return serviceActivationResult;
        }
        finally {
            this.writeSynclogEntry(synclogEntry);
        }
    }

    public ServiceActivationResult customCommandImpl(long cardNumber, String action, String[] params) throws BGException {
        throw new UnsupportedOperationException();
    }

    public static class ServiceActivationResult {
        protected static final ServiceActivationResult RESULT_OK = new ServiceActivationResult(true, "OK", null, null);
        private boolean result;
        private String message;
        private Exception nestedException;
        private String loginfo;

        public ServiceActivationResult(boolean result, String message) {
            this.result = result;
            this.message = message;
        }

        public ServiceActivationResult(boolean result, String message, Exception nestedException) {
            this.result = result;
            this.message = message;
            this.nestedException = nestedException;
        }

        public ServiceActivationResult(boolean result, String message, String loginfo, Exception nestedException) {
            this.result = result;
            this.message = message;
            this.loginfo = loginfo;
            this.nestedException = nestedException;
        }

        public boolean isResult() {
            return this.result;
        }

        public String getMessage() {
            return this.nestedException != null && Utils.notBlankString((String)this.nestedException.getMessage()) ? this.message + " (" + this.nestedException.getMessage() + ")" : this.message;
        }

        public Exception getNestedException() {
            return this.nestedException;
        }

        public String getLoginfo() {
            return this.loginfo;
        }
    }

    public static class CardPacketCodePair {
        public CardPacket cardpacket;
        public long cardnumber;
        public String packetCode;
        public String packetServerCode;

        public CardPacketCodePair(CardPacket cardpacket, long cardnumber, String packetCode, String packetServerCode) {
            this.cardpacket = cardpacket;
            this.cardnumber = cardnumber;
            this.packetCode = packetCode;
            this.packetServerCode = packetServerCode;
        }

        public String toString() {
            return String.format("%s | %s | %s | %s", this.cardnumber, this.packetCode, this.cardpacket.getDateFrom(), this.cardpacket.getDateTo());
        }
    }

    public static interface SubscriptionComparatorForEqualizer<T> {
        public boolean subscriptionEquals(CardPacketCodePair var1, T var2);
    }
}

