/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.BitArrayOutputStream;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.BitInputStream;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.CDCAS30Connection;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.ICryptKeyType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.IMessageIDList;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.Request;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.Response;
import ru.bitel.common.Utils;
import ru.bitel.common.util.DebugUtils;

public abstract class Packet<Q extends Request<Q, P>, P extends Response<Q, P>>
implements IMessageIDList,
ICryptKeyType {
    private static final Logger log = LogManager.getLogger();
    private static final int Proto_Ver = 1;
    private static final int Crypt_Ver = 1;
    private static final int Key_Type = 2;
    protected int DB_ID;
    protected CDCAS30Connection connection;

    public Packet(CDCAS30Connection connection, int dB_ID) {
        this.connection = connection;
        this.DB_ID = dB_ID;
    }

    protected abstract int getMessageId();

    public void writePacket(BitArrayOutputStream output) throws IOException {
        BitArrayOutputStream databody = new BitArrayOutputStream(666);
        this.writeDataBody(databody);
        databody.close();
        output.writeBits(1, 8);
        output.writeBits(1, 6);
        output.writeBits(2, 2);
        output.writeBits(this.connection.getOPE_ID(), 16);
        output.writeBits(this.connection.getSMS_ID(), 16);
        output.writeBits(databody.size(), 16);
        output.write(databody.toByteArray());
        Packet.$trace("-[packet]-> " + Utils.bytesToString((byte[])output.toByteArray()), new Object[0]);
    }

    private void writeDataBody(BitArrayOutputStream output) throws IOException {
        BitArrayOutputStream datacont = new BitArrayOutputStream(666);
        this.writeDataCont(datacont);
        datacont.close();
        output.writeBits(this.DB_ID, 16);
        output.writeBits(this.getMessageId(), 16);
        output.writeBits(datacont.size(), 16);
        output.write(datacont.toByteArray());
        int pad = (8 - datacont.size() % 8) % 8;
        for (int i = 0; i < pad; ++i) {
            output.writeBits(0, 8);
        }
        byte[] md5 = Utils.getDigestBytes((byte[])output.toByteArray());
        output.write(md5);
    }

    protected abstract void writeDataCont(BitArrayOutputStream var1) throws IOException;

    public void readPacket(BitInputStream input) throws IOException {
        int r_Proto_Ver = input.readBits(8);
        int r_Crypt_Ver = input.readBits(6);
        int r_Key_Type = input.readBits(2);
        int r_OPE_ID = input.readBits(16);
        int r_SMS_ID = input.readBits(16);
        int r_databody_size = input.readBits(16);
        Packet.$trace("<-[packet]- Proto_Ver: %d, Crypt_Ver: %d, Key_Type: %d, OPE_ID: %d, SMS_ID: %d, databody(size: %d)...", r_Proto_Ver, r_Crypt_Ver, r_Key_Type, r_OPE_ID, r_SMS_ID, r_databody_size);
        switch (r_Key_Type) {
            case 0: {
                byte[] enc_databody = new byte[r_databody_size];
                Utils.readFullBuffer((InputStream)input, (byte[])enc_databody);
                Packet.$trace("<-[enc databody]- " + Utils.bytesToString((byte[])enc_databody), new Object[0]);
                byte[] dec_databody = Packet.decryptDataBody3DES(enc_databody, this.connection.getRootkey());
                Packet.$trace("<-[dec databody]- " + Utils.bytesToString((byte[])dec_databody), new Object[0]);
                this.readDataBody(new BitInputStream(new ByteArrayInputStream(dec_databody)), dec_databody.length);
                break;
            }
            case 1: {
                throw new IOException("unsupported crypt key type session");
            }
            case 2: {
                this.readDataBody(input, r_databody_size);
                break;
            }
            default: {
                throw new IOException("unsupported crypt key type: #" + r_Key_Type);
            }
        }
        if (r_Proto_Ver != 1) {
            throw new IOException(String.format("unsupported Proto_Ver (current: %d, response: %d)", 1, r_Proto_Ver));
        }
        if (r_Crypt_Ver != 1) {
            throw new IOException(String.format("unsupported Crypt_Ver (current: %d, response: %d)", 1, r_Crypt_Ver));
        }
        if (r_OPE_ID != this.connection.getOPE_ID()) {
            throw new IOException(String.format("unsupported OPE_ID (current: %d, response: %d)", this.connection.getOPE_ID(), r_OPE_ID));
        }
        if (r_SMS_ID != this.connection.getSMS_ID()) {
            throw new IOException(String.format("unsupported SMS_ID (current: %d, response: %d)", this.connection.getSMS_ID(), r_SMS_ID));
        }
    }

    public static void main(String[] args) throws Exception {
        String key = "ABCDEFGHABCDEFGHABCDEFGH";
        byte[] enc = Utils.stringToBytes((String)"12 7F 68 A6 8B 19 FF F7 D2 44 58 37 6C 27 45 43 02 AE 93 A3 A9 A3 A2 13 5C 7B B0 2F 11 BC BC BF 5C 7B B0 2F 11 BC BC BF 5C 7B B0 2F 11 BC BC BF 0F 93 CE F5 06 7F 71 FE 22 19 6D BA B0 BD 35 6F", (String)" ");
        byte[] dec = Packet.decryptDataBody3DES(enc, key);
        System.out.println(Utils.bytesToString((byte[])enc));
        System.out.println(Utils.bytesToString((byte[])dec));
    }

    private static byte[] decryptDataBody3DES(byte[] enc_databody, String rootkey) throws IOException {
        try {
            byte[] key192;
            byte[] keybytes = rootkey.getBytes("ascii");
            if (keybytes.length == 16) {
                key192 = new byte[24];
                System.arraycopy(keybytes, 0, key192, 0, 16);
                System.arraycopy(keybytes, 0, key192, 16, 8);
            } else {
                key192 = keybytes;
            }
            SecretKeySpec key = new SecretKeySpec(key192, "DESede");
            Cipher decipher = Cipher.getInstance("DESede/ECB/NoPadding");
            decipher.init(2, key);
            byte[] dec_databody = decipher.doFinal(enc_databody);
            return dec_databody;
        }
        catch (Exception ex) {
            throw new IOException("error decryptDataBody3DES", ex);
        }
    }

    private void readDataBody(BitInputStream input, int databodySize) throws IOException {
        int r_DB_ID = input.readBits(16);
        int r_MessageId = input.readBits(16);
        int r_datacont_size = input.readBits(16);
        Packet.$trace("<-[databody]- DB_ID: %d, MessageId: 0x%X, datacont(size: %d)...", r_DB_ID, r_MessageId, r_datacont_size);
        byte[] datacont_bytes = new byte[r_datacont_size];
        Utils.readFullBuffer((InputStream)input, (byte[])datacont_bytes);
        Packet.$trace("<-[datacont]- " + Utils.bytesToString((byte[])datacont_bytes), new Object[0]);
        if (r_DB_ID != this.DB_ID) {
            throw new IOException(String.format("not equals DB_ID (current: %d, response: %d)", this.DB_ID, r_DB_ID));
        }
        if (r_MessageId != this.getMessageId()) {
            throw new IOException(String.format("not equals MessageId (current: %d, response: %d)", this.getMessageId(), r_MessageId));
        }
        this.readDataCont(new BitInputStream(new ByteArrayInputStream(datacont_bytes)), r_datacont_size);
        int remain_size = databodySize - (6 + r_datacont_size);
        byte[] databody_remain = new byte[remain_size];
        Packet.$trace("<-[databody]- padding+mac remain(size: %d, input available: %d)...", remain_size, input.available());
        Utils.readFullBuffer((InputStream)input, (byte[])databody_remain);
        Packet.$trace("<-[databody]- %s", Utils.bytesToString((byte[])databody_remain));
    }

    protected abstract void readDataCont(BitInputStream var1, int var2) throws IOException;

    public String toString() {
        return DebugUtils.dumpObject((Object)this);
    }

    private static void $trace(String format, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug(String.format(format, args));
        }
    }
}

