/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterGroup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class RegisterGroupManager {
    private static final String TABLE_REGISTER_GROUP = "register_group";
    private Connection con;

    public RegisterGroupManager(Connection con) {
        this.con = con;
    }

    public void deleteGroup(int id) {
        String query = "DELETE FROM register_group WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
            this.deleteGroupTaskTypes(id);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateGroup(String id, RegisterGroup value) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (id.equals("new")) {
                query = "INSERT INTO register_group SET title=?, email=?";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE register_group SET title=?, email=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(3, Utils.parseInt((String)id, (int)-1));
            }
            ps.setString(1, value.getTitle());
            ps.setString(2, value.getEmail());
            ps.executeUpdate();
            if (id.equals("new")) {
                value.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            } else {
                value.setId(Utils.parseInt((String)id, (int)-1));
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public RegisterGroup getGroupById(int id) throws BGException {
        RegisterGroup result = null;
        String query = "SELECT * FROM register_group WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.loadFromRS(rs);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<RegisterGroup> getGroupList() throws BGException {
        return this.getGroupList(0);
    }

    public List<RegisterGroup> getGroupList(int taskTypeId) throws BGException {
        ArrayList<RegisterGroup> result = new ArrayList<RegisterGroup>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ");
        query.append(TABLE_REGISTER_GROUP);
        if (taskTypeId > 0) {
            query.append(" LEFT JOIN register_group_task_type AS tt ON id=tt.gid WHERE type_id=?");
        }
        query.append(" ORDER BY title");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (taskTypeId > 0) {
                ps.setInt(1, taskTypeId);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.loadFromRS(rs));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void updateGroupTaskTypes(int groupId, List<Integer> types) {
        try {
            this.deleteGroupTaskTypes(groupId);
            String query = "INSERT INTO register_group_task_type SET gid=?, type_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, groupId);
            for (Integer typeId : types) {
                ps.setInt(2, typeId);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteGroupTaskTypes(int groupId) {
        try {
            String query = "DELETE FROM register_group_task_type WHERE gid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, groupId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Integer> getGroupTaskTypes(int groupId) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            String query = "SELECT type_id FROM register_group_task_type WHERE gid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, groupId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<Integer, RegisterGroup> getGroupMap() throws BGException {
        HashMap<Integer, RegisterGroup> result = new HashMap<Integer, RegisterGroup>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM register_group");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                RegisterGroup group = this.loadFromRS(rs);
                result.put(group.getId(), group);
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    private RegisterGroup loadFromRS(ResultSet rs) throws SQLException {
        RegisterGroup group = new RegisterGroup();
        group.setId(rs.getInt("id"));
        group.setTitle(rs.getString("title"));
        group.setEmail(rs.getString("email"));
        return group;
    }
}

