/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.service;

import jakarta.activation.DataHandler;
import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentPattern;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentTable;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentTableExtractMethod;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsPatternService;
import ru.bitel.bgbilling.plugins.documents.server.bean.event.DocumentGetPatternListEvent;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocumentsPatternDao;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.PatternDataExtractor;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.TableDataExtractor;
import ru.bitel.bgbilling.plugins.documents.server.filestorage.DocumentsPatternFileStorage;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.documents.common.service.DocumentsPatternService")
public class DocumentsPatternServiceImpl
extends AbstractService
implements DocumentsPatternService {
    private DocumentsPatternDao patternManager;
    private BGPluginServer plugin;

    @PostConstruct
    public void init() throws SQLException, BGException {
        this.plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.documents");
        this.patternManager = new DocumentsPatternDao(this.getConnection());
    }

    public List<DocumentPattern> getPatternList(int contractId) throws BGException {
        List<DocumentPattern> patternList = this.patternManager.getPatternList();
        if (contractId > 0) {
            DocumentGetPatternListEvent patternListEvent = new DocumentGetPatternListEvent(contractId, this.plugin.getPluginUID(), this.userId);
            patternListEvent = (DocumentGetPatternListEvent)EventProcessor.getInstance().request((QueueEvent)patternListEvent);
            List<DocumentPattern> patternListFromEvent = patternListEvent.getPatternList();
            if (patternListFromEvent != null && patternListFromEvent.size() > 0) {
                patternList = patternListFromEvent;
            } else {
                try (ContractDao dao = new ContractDao(this.getConnection(), 0);){
                    Contract contract = (Contract)dao.get(contractId);
                    int contractDomainId = contract.getDomainId();
                    ArrayList<DocumentPattern> tmpList = new ArrayList<DocumentPattern>();
                    for (DocumentPattern pattern : patternList) {
                        List domainList = pattern.getDomainList();
                        if ((contractDomainId <= 0 || domainList == null || !domainList.contains(contractDomainId)) && (contractDomainId > 0 || domainList != null && domainList.size() != 0)) continue;
                        tmpList.add(pattern);
                    }
                    patternList = tmpList;
                }
            }
        }
        return patternList;
    }

    public DocumentPattern getPattern(int patternId) throws BGException {
        return this.patternManager.getPattern(patternId);
    }

    public int updatePattern(DocumentPattern documentPattern) throws BGException {
        documentPattern.setUserId(this.userId);
        this.patternManager.update(documentPattern);
        return documentPattern.getId();
    }

    public void deletePattern(int patternId) throws BGException {
        DocumentPattern pattern = this.getPattern(patternId);
        ArrayList<String> dynClasses = new ArrayList<String>();
        if (Utils.notBlankString((String)pattern.getDataExtractorClass())) {
            dynClasses.add(pattern.getDataExtractorClass());
        }
        for (DocumentTable table : pattern.getTableList()) {
            if (!table.getExtractMethod().equals((Object)DocumentTableExtractMethod.DYNCLASS) || !Utils.notBlankString((String)table.getValue())) continue;
            dynClasses.add(table.getValue());
        }
        this.patternManager.delete(patternId);
        this.deletePatternFile(patternId);
    }

    public void clonePattern(int patternId) throws BGException {
        BGServerFile selectedServerFile;
        DocumentPattern selectedPattern = this.getPattern(patternId);
        DocumentPattern clonedPattern = selectedPattern.clone();
        clonedPattern.setTitle(clonedPattern.getTitle() + " (\u043a\u043e\u043f\u0438\u044f " + TimeUtils.formatFullDate((Date)new Date()) + ")");
        this.updatePattern(clonedPattern);
        FileStorage patternStorage = this.getFileStorage();
        List serverFileList = patternStorage.getFilesListByOwner(selectedPattern.getId());
        if (serverFileList.size() > 0 && (selectedServerFile = (BGServerFile)serverFileList.get(0)) != null) {
            BGServerFile clonedServerFile = selectedServerFile.clone();
            clonedServerFile.setOwnerId(clonedPattern.getId());
            clonedServerFile.setUserId(this.userId);
            clonedServerFile.setDate(new Date());
            patternStorage.updateFile(clonedServerFile);
            try (FileInputStream fis = patternStorage.load(selectedServerFile.getId());){
                patternStorage.saveStream(clonedServerFile.getId(), (InputStream)fis);
            }
            catch (IOException e) {
                throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 \u0444\u0430\u0439\u043b\u043e\u043c \u0448\u0430\u0431\u043b\u043e\u043d\u0430. \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0432 \u043b\u043e\u0433\u0430\u0445 \u0441\u0435\u0440\u0432\u0435\u0440\u0430.", (Throwable)e);
            }
        }
    }

    public String getTableExtractorIfaceClassName() {
        return TableDataExtractor.class.getCanonicalName();
    }

    public String getPatternExtractorIfaceClassName() {
        return PatternDataExtractor.class.getCanonicalName();
    }

    public boolean uploadPatternFile(BGServerFile serverFile, Holder<DataHandler> fileData) throws BGException {
        block12: {
            DataHandler handler = (DataHandler)fileData.value;
            try (InputStream is = handler.getInputStream();){
                serverFile.setUserId(this.userId);
                serverFile.setSize((long)is.available());
                FileStorage patternStorage = this.getFileStorage();
                patternStorage.updateFile(serverFile);
                if (serverFile.getId() <= 0) break block12;
                try {
                    String netRootPath = this.plugin.getSetup().get("file.pattern.net.share.root.path");
                    if (!Utils.isEmptyString((String)netRootPath)) {
                        String fileExtension = serverFile.getTitle().substring(serverFile.getTitle().lastIndexOf(".") + 1);
                        patternStorage.saveStream(serverFile.getId(), is, fileExtension);
                    } else {
                        patternStorage.saveStream(serverFile.getId(), is);
                    }
                }
                catch (Exception e) {
                    patternStorage.deleteFile(serverFile.getId());
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.\n\u0418\u043b\u0438 \u043f\u0440\u0438\u0448\u043b\u0438 \u0431\u0438\u0442\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u0430.\n" + e.getMessage());
                }
            }
            catch (IOException ex) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0411\u0414! \u0418\u043b\u0438 \u043f\u0440\u0438\u0448\u043b\u0438 \u0431\u0438\u0442\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.");
            }
        }
        return false;
    }

    public BGServerFile downloadPatternFile(int patternId, Holder<DataHandler> fileData) throws BGException {
        FileStorage patternStorage = this.getFileStorage();
        BGServerFile file = (BGServerFile)patternStorage.getFilesListByOwner(patternId).get(0);
        try {
            patternStorage.checkFileExist(file.getId());
            fileData.value = new DataHandler(patternStorage.getDataSource(file.getId()));
        }
        catch (FileNotFoundException e) {
            throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0444\u0430\u0439\u043b \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435!", (Throwable)e);
        }
        return file;
    }

    public void deletePatternFile(int patternId) throws BGException {
        try {
            FileStorage patternStorage = this.getFileStorage();
            patternStorage.deleteByOwner(patternId);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public String getFilePath(int patternId) throws BGException {
        String rootPath = this.plugin.getSetup().get("file.pattern.net.share.root.path");
        if (Utils.isBlankString((String)rootPath)) {
            return null;
        }
        FileStorage patternStorage = this.getFileStorage();
        BGServerFile serverFile = (BGServerFile)patternStorage.getFilesListByOwner(patternId).get(0);
        File file = new File(patternStorage.getFileName(serverFile.getId()));
        return file.getAbsolutePath();
    }

    public void getEmbeddedFilename(int patternId, Holder<String> fileName) throws BGException {
        FileStorage patternStorage = this.getFileStorage();
        List filesList = patternStorage.getFilesListByOwner(patternId);
        if (filesList.size() > 0) {
            fileName.value = ((BGServerFile)filesList.get(0)).getTitle();
        }
    }

    private FileStorage getFileStorage() throws BGException {
        return new DocumentsPatternFileStorage(this.getConnection());
    }

    public void updatePos(List<int[]> idPosList) throws BGException {
        this.patternManager.updatePos(idPosList);
    }
}

