/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import java.util.Calendar;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskRecalculator;
import ru.bitel.bgbilling.modules.ipn.server.LogCalculator;
import ru.bitel.bgbilling.modules.ipn.server.mail.MailTaskRecalculator;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class IPNRecalculator
extends RunTaskRecalculator<LogCalculator> {
    private String cids;
    private String comment = null;

    public IPNRecalculator(int moduleId, Calendar dt, String email, String cids, String comment) {
        super(moduleId, dt, email);
        this.cids = cids;
        this.comment = comment;
    }

    public void executeTask() {
        try {
            long start = System.currentTimeMillis();
            this.createTask().startTask();
            long end = System.currentTimeMillis();
            if (this.email != null) {
                StringBuffer report = new StringBuffer("\u041e\u0431\u0441\u0447\u0435\u0442 \u043b\u043e\u0433\u043e\u0432 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\n").append("\u0412\u0440\u0435\u043c\u044f: ").append(TimeUtils.formatDeltaTime((long)((end - start) / 1000L)));
                MailTaskRecalculator mailData = new MailTaskRecalculator();
                mailData.setModuleId(this.mid);
                mailData.setRecipients(this.email);
                mailData.setSubject("\u041e\u0431\u0441\u0447\u0435\u0442 IPN \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d");
                mailData.addTextPart("text", report.toString());
                new MailMsg((Preferences)this.setup).sendMessage((MailData)mailData);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
        }
    }

    protected LogCalculator createTask() {
        LogCalculator calculator = new LogCalculator();
        calculator.setExecutingTime(this.dt);
        calculator.setCids(this.cids);
        calculator.initTask(Setup.getSetup(), 0, "mid=" + this.mid + "\ntariff_detail=1\ncomment=" + this.comment);
        return calculator;
    }
}

