/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import bitel.billing.server.MaxTrafficCalculator;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import bitel.billing.server.tariff.TariffTreesCache;
import bitel.billing.server.tariff.detail.TariffDetailKey;
import bitel.billing.server.tariff.detail.TariffDetailUtils;
import bitel.billing.server.tariff.detail.TariffDetailValue;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.bean.PeriodicErrorManager;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.CalculateEvent;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.ipn.common.bean.AddressRange;
import ru.bitel.bgbilling.modules.ipn.server.bean.AddressRangeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRule;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRuleManager;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class LogCalculator
extends TaskBase {
    private Map<TariffDetailKey, TariffDetailValue> tariffDetailMap;
    private Set<Integer> tariffDetailRangeTakeAllSet;
    private boolean calculateTariffDetail;
    private static final int MODE_SIMPLE = 1;
    private static final int MODE_DIFFICULT = 2;
    private int mode = 2;
    protected String ipnContractDataTableName;
    protected Calendar startMonth;
    protected Calendar stopMonth;
    private int daysInMonth;
    protected Map<Integer, TariffTreeSet> contractTreeSets = new HashMap<Integer, TariffTreeSet>();
    private Map<Integer, List<ServiceRange>> serviceRanges = new HashMap<Integer, List<ServiceRange>>();
    protected String moduleServices;
    protected String cids;
    protected Preferences moduleSetup;
    protected Connection con;
    protected Connection conSlave;
    private PeriodicErrorManager errorManager;
    protected ServiceCostCache cache = new ServiceCostCache();
    private Map<Integer, ContractTariffOptionList> tarifOptions = new HashMap<Integer, ContractTariffOptionList>();
    private Map<Integer, List<Period>> suspendedAndClosedPeriodMap = new HashMap<Integer, List<Period>>();
    private Set<Integer> suspendedAndClosed;
    private HashMap<Integer, Integer> contactRuleMap;
    private boolean setRules = false;
    private boolean reportIfRuleNotExist = false;

    public void setCids(String value) {
        this.cids = value;
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c IPN. \u0417\u0430\u0434\u0430\u0447\u0430 \u043e\u0431\u0441\u0447\u0435\u0442\u0430 \u043b\u043e\u0433\u043e\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ". \u041a\u043e\u0434\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: " + this.cids;
    }

    protected boolean initTask() {
        this.startMonth = (Calendar)this.getOperatingTime().clone();
        boolean minusHour = this.taskSetup.getBoolean("hour.minus", true);
        if (minusHour) {
            this.startMonth.add(11, -1);
        }
        this.startMonth.set(5, 1);
        this.startMonth.set(11, 0);
        this.stopMonth = (Calendar)this.startMonth.clone();
        this.stopMonth.add(2, 1);
        this.stopMonth.add(6, -1);
        this.daysInMonth = this.stopMonth.get(5);
        if (this.moduleId <= 0) {
            this.getLogger().error("Param mid not found in task config");
            String key = "ipn.calculator.mid.empty";
            String message = "mid \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u0437\u0430\u0434\u0430\u0447\u0438 id=>" + this.taskId;
            AlarmSender.sendAlarm((String)key, (long)30000L, (String)"mid \u043d\u0435 \u043d\u0435\u0439\u0434\u0435\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435", (String)message);
            return false;
        }
        this.mode = this.taskSetup.getInt("mode", this.mode);
        this.calculateTariffDetail = this.taskSetup.getInt("tariff_detail", 0) > 0;
        this.contactRuleMap = new HashMap();
        this.setRules = this.taskSetup.getInt("set.rules", 0) > 0;
        this.reportIfRuleNotExist = this.taskSetup.getInt("rule.error", 0) > 0;
        this.suspendedAndClosed = StatusCache.getInstance().getModuleSuspendStatusSet(this.moduleId);
        return true;
    }

    public void executeTask() {
        this.con = this.setup.getDBConnectionFromPool();
        this.conSlave = this.setup.getDBSlaveConnectionFromPool();
        try {
            this.errorManager = new PeriodicErrorManager(this.con);
            this.errorManager.initErrorMessage(this.moduleId, "IPN", String.valueOf(this.moduleId), this.startMonth.getTime());
            this.ipnContractDataTableName = ServerUtils.getModuleMonthTableName((String)"ipn_contract_data", (Date)this.startMonth.getTime(), (int)this.moduleId);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Processing table: " + this.ipnContractDataTableName);
            }
            EventProcessor.getInstance().request((QueueEvent)new CalculateEvent(0, this.moduleId, 0, this.startMonth.getTime(), this.stopMonth.getTime(), null, Utils.toIntegerSet((String)this.cids), this.taskSetup.get("comment", null)));
            this.moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
            this.moduleServices = MaxTrafficCalculator.getModuleServicesWithoutMaxTraf((Connection)this.con, (int)this.moduleId, (Preferences)this.moduleSetup);
            if (!ServerUtils.tableExists((Connection)this.con, (String)this.ipnContractDataTableName) && !this.setRules) {
                this.getLogger().error("No data table " + this.ipnContractDataTableName);
                return;
            }
            TariffTreesCache.getCache().clearCache();
            this.initContractTrees();
            this.process();
            EventProcessor.getInstance().request((QueueEvent)new CalculateEvent(1, this.moduleId, 0, this.startMonth.getTime(), this.stopMonth.getTime(), null, Utils.toIntegerSet((String)this.cids), this.taskSetup.get("comment", null)));
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            this.error = ex;
        }
        finally {
            try {
                if (Utils.isBlankString((String)this.cids)) {
                    this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.startMonth.getTime());
                }
                this.errorManager.processErrors();
            }
            catch (Exception exception) {}
            ServerUtils.closeConnection((Connection)this.con, (Connection)this.conSlave);
        }
    }

    protected void process() {
        this.tariffDetailMap = new HashMap<TariffDetailKey, TariffDetailValue>(1024);
        this.tariffDetailRangeTakeAllSet = TariffDetailUtils.getCostTypeRangeTakeAllIdSet((Preferences)this.moduleSetup);
        this.getLogger().info("Processing..");
        boolean tableExist = ServerUtils.tableExists((Connection)this.con, (String)this.ipnContractDataTableName);
        Object query = null;
        try {
            long t1 = System.currentTimeMillis();
            t1 = System.currentTimeMillis();
            if (tableExist) {
                query = this.makeQuery();
                PreparedStatement queryPS = this.conSlave.prepareStatement((String)query);
                queryPS.setFetchSize(1000000);
                ResultSet queryRS = queryPS.executeQuery();
                long t2 = System.currentTimeMillis();
                this.getLogger().info("Select records time=" + (t2 - t1) + " ms.");
                try (ContractStatusDao contractStatusDao = new ContractStatusDao(this.con);){
                    while (queryRS.next()) {
                        List suspendedAndClosedPeriods;
                        Calendar time = TimeUtils.convertDateToCalendar((Date)queryRS.getDate(1));
                        time.set(11, queryRS.getInt(2));
                        int cid = queryRS.getInt(3);
                        int sid = queryRS.getInt(4);
                        long amount = queryRS.getLong(5);
                        List<ServiceRange> rangeList = this.serviceRanges.get(cid);
                        TariffTreeSet tts = this.contractTreeSets.get(cid);
                        ContractTariffOptionList tariffOption = this.tarifOptions.get(cid);
                        if (tariffOption == null) {
                            tariffOption = new ContractTariffOptionDao(this.con).getRoundContractRealtimeTariffOptionList(cid, this.startMonth.getTime());
                            this.tarifOptions.put(cid, tariffOption);
                        }
                        if ((suspendedAndClosedPeriods = this.suspendedAndClosedPeriodMap.get(cid)) == null) {
                            suspendedAndClosedPeriods = contractStatusDao.getPeriodList(cid, 0, this.suspendedAndClosed, this.startMonth.getTime(), null);
                            if (suspendedAndClosedPeriods.size() == 0) {
                                this.suspendedAndClosedPeriodMap.put(cid, Collections.emptyList());
                            } else {
                                this.suspendedAndClosedPeriodMap.put(cid, suspendedAndClosedPeriods);
                            }
                        }
                        if (tts == null) continue;
                        this.doRequest(this.cache, time, cid, sid, amount, tts, rangeList, tariffOption, suspendedAndClosedPeriods, "calculate");
                    }
                }
                queryPS.close();
            }
            this.tarifOptions.clear();
            if (this.setRules) {
                query = "SELECT contract.id FROM contract  LEFT JOIN contract_module ON contract_module.cid = contract.id  WHERE contract_module.mid = " + this.moduleId;
                if (this.cids != null) {
                    query = (String)query + " AND cid IN (" + this.cids + ")";
                }
                query = (String)query + " AND (date1 IS NULL OR date1 <= now() ) AND ( date2 IS NULL OR date2 >= now() )";
                query = (String)query + " ORDER BY cid";
                PreparedStatement ps = this.con.prepareStatement((String)query);
                ResultSet rs = ps.executeQuery();
                GregorianCalendar currentTime = new GregorianCalendar();
                while (rs.next()) {
                    int cid = rs.getInt(1);
                    Integer sid = null;
                    Long amount = null;
                    List<ServiceRange> rangeList = null;
                    TariffTreeSet tts = this.contractTreeSets.get(cid);
                    ContractTariffOptionList tariffOption = this.tarifOptions.get(cid);
                    List<Period> suspendedAndClosedPeriods = this.suspendedAndClosedPeriodMap.get(cid);
                    if (tariffOption == null) {
                        tariffOption = new ContractTariffOptionDao(this.con).getContractRealtimeTariffOptionList(cid, currentTime.getTime());
                        this.tarifOptions.put(cid, tariffOption);
                    }
                    if (tts == null) continue;
                    this.doRequest(this.cache, currentTime, cid, sid, amount, tts, rangeList, tariffOption, suspendedAndClosedPeriods, "getRule");
                }
                ps.close();
            }
            long t2 = System.currentTimeMillis();
            this.getLogger().info("Records processing time=" + (t2 - t1) + " ms.");
            if (this.errorManager.getCounter() != 0) {
                this.getLogger().error("Detected errors => " + this.errorManager.getCounter());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.gc();
        try {
            new BalanceUtils(this.con).setAccount(this.con, this.getLogger(), this.startMonth, this.cache, this.moduleServices, this.cids, null);
            if (this.calculateTariffDetail) {
                TariffDetailUtils.flushTariffDetail((Logger)this.getLogger(), (String)"ipn", (DefaultServerSetup)this.setup, (Preferences)this.moduleSetup, (Connection)this.con, (int)this.moduleId, (Calendar)this.startMonth, (Calendar)this.stopMonth, (String)this.cids, (long)0L, this.tariffDetailMap, this.tariffDetailRangeTakeAllSet, (int)1);
            }
            if (this.setRules) {
                this.adjustGateRules();
            }
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createContractTrees() throws SQLException, BGException {
        ContractManager cm = new ContractManager(this.con);
        if (Utils.isBlankString((String)this.cids)) {
            if (this.setRules) {
                String query = "SELECT DISTINCT cid FROM contract_module WHERE mid = " + this.moduleId;
                PreparedStatement ps = this.conSlave.prepareStatement(query);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    int cid = rs.getInt(1);
                    TariffTreeSet tts = cm.getRealtimeTariffTreeSet(cid, this.startMonth, "ipn", this.moduleId, true);
                    this.contractTreeSets.put(cid, tts);
                }
                ps.close();
            } else {
                List<AddressRange> activeRangeList = new AddressRangeManager(this.con, this.moduleId).getAddressRangeList(this.startMonth, this.stopMonth);
                for (AddressRange ar : activeRangeList) {
                    int cid = ar.getContractId();
                    if (this.contractTreeSets.containsKey(cid)) continue;
                    TariffTreeSet tts = cm.getRealtimeTariffTreeSet(cid, this.startMonth, "ipn", this.moduleId, true);
                    this.contractTreeSets.put(cid, tts);
                }
            }
        } else {
            for (Integer cid : Utils.toIntegerList((String)this.cids)) {
                TariffTreeSet tts = cm.getRealtimeTariffTreeSet(cid.intValue(), this.startMonth, "ipn", this.moduleId, true);
                this.contractTreeSets.put(cid, tts);
            }
        }
        cm.recycle();
    }

    private String makeQuery() {
        String query = "SELECT dt, hh, cid, sid, amount FROM " + this.ipnContractDataTableName;
        if (Utils.notBlankString((String)this.cids)) {
            query = query + " WHERE cid IN ( " + this.cids + ") ";
        }
        query = query + " ORDER BY cid, dt, hh";
        return query;
    }

    private void doRequest(ServiceCostCache cache, Calendar time, int cid, Integer sid, Long amount, TariffTreeSet tts, List<ServiceRange> rangeList, ContractTariffOptionList tariffOption, List<Period> suspendedAndClosedPeriods, String action) {
        List treeList = tts.getTreeEntryList(time);
        if (treeList != null && treeList.size() > 0) {
            boolean accepted = false;
            TariffRequest req = null;
            for (TariffTreeSet.TariffSetEntry tree : treeList) {
                req = new TariffRequest();
                req.setRequestParam("cid", (Object)cid);
                req.setRequestParam("time", (Object)time);
                if (sid != null) {
                    req.setRequestParam("sid", (Object)sid);
                }
                if (amount != null) {
                    req.setRequestParam("amount", (Object)amount);
                }
                req.setRequestParam("action", (Object)action);
                req.setRequestParam("costTypeRangeTakeAllSet", this.tariffDetailRangeTakeAllSet);
                req.setRequestParam("part_tariff", (Object)Float.valueOf(tree.getPartOnPeriod(this.startMonth, this.stopMonth)));
                req.setRequestParam("part_tariff_suspended", (Object)Float.valueOf(tree.getPartOnPeriod(this.startMonth, this.stopMonth, suspendedAndClosedPeriods)));
                req.setRequestParam("tariffOptions", (Object)tariffOption);
                if (rangeList != null) {
                    for (ServiceRange range : rangeList) {
                        if (range.serviceId != sid || !TimeUtils.dateInRange((Calendar)time, (Calendar)range.fromDate, (Calendar)range.toDate)) continue;
                        Float part = Float.valueOf((float)range.days / (float)this.daysInMonth);
                        req.setRequestParam("part", (Object)part);
                    }
                }
                tree.getTree().processRequest(req);
                if (req.wasAccepted()) {
                    Integer ruleId;
                    accepted = true;
                    Float costAmount = (Float)req.getResponseParam("costAmount");
                    Float cost = (Float)req.getResponseParam("cost");
                    Long divisor = (Long)req.getResponseParam("divisor");
                    Double recordCost = null;
                    if (costAmount != null) {
                        recordCost = costAmount.doubleValue();
                    } else if (cost != null && divisor != null && divisor > 0L) {
                        recordCost = (double)amount.longValue() * cost.doubleValue() / (double)divisor.longValue();
                    }
                    if (recordCost != null) {
                        CostSum am = new CostSum(cid, sid.intValue(), BigDecimal.valueOf(recordCost));
                        cache.addAmount(am);
                    }
                    if (this.calculateTariffDetail) {
                        TariffDetailUtils.putTariffDetail(this.tariffDetailMap, (TariffRequest)req, (int)cid, (int)sid, (double)(recordCost != null ? recordCost : 0.0), (long)amount);
                    }
                    if ((ruleId = (Integer)req.getResponseParam("inp_rule_id")) != null) {
                        this.contactRuleMap.put(cid, ruleId);
                    }
                }
                if (req.getErrors().length() > 0) {
                    this.getLogger().error(req.getErrors());
                }
                if (!accepted) continue;
                break;
            }
            if (!accepted && (action.equals("calculate") || action.equals("getRule") && this.reportIfRuleNotExist) && !this.errorManager.isCapReached()) {
                this.getLogger().error("Contract id: " + cid);
                this.getLogger().error("Request " + req + " wasn't accepted!");
                String subject = "\u041e\u0448\u0438\u0431\u043a\u0430! \u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0435 \u0431\u044b\u043b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d!";
                String message = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 (\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + cid + "): \u0437\u0430\u043f\u0440\u043e\u0441 " + req + "\u043d\u0435 \u0431\u044b\u043b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439!";
                this.errorManager.addErrorToList(subject, message);
            }
        } else if (!this.errorManager.isCapReached()) {
            this.getLogger().error("Tree not found, contract id: " + cid);
            String subject = "\u041e\u0448\u0438\u0431\u043a\u0430! \u0422\u0430\u0440\u0438\u0444\u043d\u043e\u0435 \u0434\u0435\u0440\u0435\u0432\u043e \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e!";
            String message = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 (\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + cid + "): \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0435 \u0434\u0435\u0440\u0435\u0432\u043e \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.\n\u041e\u0431\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430: " + sid + ". \u0414\u0430\u0442\u0430: " + TimeUtils.formatDate((Calendar)time) + ".";
            this.errorManager.addErrorToList(subject, message);
        }
    }

    private void initContractTrees() throws SQLException, BGException {
        long startInit = System.currentTimeMillis();
        this.createContractTrees();
        this.initRanges();
        if (this.mode == 2 && ServerUtils.tableExists((Connection)this.con, (String)this.ipnContractDataTableName)) {
            this.getLogger().info("Difficult mode INIT");
            int lastCid = -1;
            TariffTreeSet lastTts = null;
            List<ServiceRange> lastRangeList = null;
            String query = this.makeQuery();
            try (ContractStatusDao contractStatusDao = new ContractStatusDao(this.con);
                 PreparedStatement ps = this.conSlave.prepareStatement(query);){
                ps.setFetchSize(1000000);
                ResultSet queryRS = ps.executeQuery();
                while (queryRS.next()) {
                    List treeList;
                    List<ServiceRange> rangeList;
                    boolean newCid;
                    Calendar time = TimeUtils.convertDateToCalendar((Date)queryRS.getDate(1));
                    time.set(11, queryRS.getInt(2));
                    int cid = queryRS.getInt(3);
                    int sid = queryRS.getInt(4);
                    long amount = queryRS.getLong(5);
                    boolean bl = newCid = cid != lastCid;
                    if (newCid) {
                        lastCid = cid;
                    }
                    TariffTreeSet tts = newCid ? this.contractTreeSets.get(cid) : lastTts;
                    List<ServiceRange> list = rangeList = newCid ? this.serviceRanges.get(cid) : lastRangeList;
                    if (tts == null) continue;
                    List suspendedAndClosedPeriods = this.suspendedAndClosedPeriodMap.get(cid);
                    if (suspendedAndClosedPeriods == null) {
                        suspendedAndClosedPeriods = contractStatusDao.getPeriodList(cid, 0, this.suspendedAndClosed, this.startMonth.getTime(), null);
                        if (suspendedAndClosedPeriods.size() == 0) {
                            this.suspendedAndClosedPeriodMap.put(cid, Collections.emptyList());
                        } else {
                            this.suspendedAndClosedPeriodMap.put(cid, suspendedAndClosedPeriods);
                        }
                    }
                    if ((treeList = tts.getTreeEntryList(time)) != null && treeList.size() > 0) {
                        TariffRequest req = null;
                        for (TariffTreeSet.TariffSetEntry tse : treeList) {
                            req = new TariffRequest();
                            if (rangeList != null) {
                                for (ServiceRange range : rangeList) {
                                    if (range.serviceId != sid || !TimeUtils.dateInRange((Calendar)time, (Calendar)range.fromDate, (Calendar)range.toDate)) continue;
                                    float part = (float)range.days / (float)this.daysInMonth;
                                    if (part != 1.0f && this.getLogger().isDebugEnabled()) {
                                        Date dateFrom = TimeUtils.convertCalendarToDate((Calendar)range.fromDate);
                                        Date dateTo = TimeUtils.convertCalendarToDate((Calendar)range.toDate);
                                        this.getLogger().debug(TimeUtils.formatPeriod((Date)dateFrom, (Date)dateTo));
                                    }
                                    req.setRequestParam("part", (Object)Float.valueOf(part));
                                }
                            }
                            req.setRequestParam("action", (Object)"init");
                            req.setRequestParam("cid", (Object)cid);
                            req.setRequestParam("time", (Object)time);
                            req.setRequestParam("sid", (Object)sid);
                            req.setRequestParam("amount", (Object)amount);
                            req.setRequestParam("part_tariff", (Object)Float.valueOf(tse.getPartOnPeriod(this.startMonth, this.stopMonth)));
                            req.setRequestParam("part_tariff_suspended", (Object)Float.valueOf(tse.getPartOnPeriod(this.startMonth, this.stopMonth, suspendedAndClosedPeriods)));
                            tse.getTree().processRequest(req);
                            if (req.getErrors().length() <= 0 || this.errorManager.isCapReached()) continue;
                            this.getLogger().error("Contract id: " + cid);
                            this.getLogger().error("Request process ERROR: " + req.getErrors());
                            String subject = "\u041e\u0448\u0438\u0431\u043a\u0430! \u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0435 \u0431\u044b\u043b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d!";
                            String message = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 (\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + cid + "): \u0437\u0430\u043f\u0440\u043e\u0441 " + req + "\u043d\u0435 \u0431\u044b\u043b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439!";
                            this.errorManager.addErrorToList(subject, message);
                        }
                        continue;
                    }
                    if (this.errorManager.isCapReached()) continue;
                    this.getLogger().error("Tree not found for contract id: " + cid);
                    String subject = "\u041e\u0448\u0438\u0431\u043a\u0430! \u0422\u0430\u0440\u0438\u0444\u043d\u043e\u0435 \u0434\u0435\u0440\u0435\u0432\u043e \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e!";
                    String message = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 (\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + cid + "): \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0435 \u0434\u0435\u0440\u0435\u0432\u043e \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e!";
                    this.errorManager.addErrorToList(subject, message);
                }
            }
            catch (Exception ex) {
                this.getLogger().error(ex.getMessage(), (Throwable)ex);
            }
        }
        long stopInit = System.currentTimeMillis();
        this.getLogger().info("Init time => " + (stopInit - startInit) + " ms");
    }

    private void initRanges() {
        try {
            String query = "SELECT cid, sid, date1, date2 FROM contract_service WHERE sid IN ( " + this.moduleServices + " ) AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?)";
            if (Utils.notBlankString((String)this.cids)) {
                query = query + " AND cid IN ( " + this.cids + ")";
            }
            PreparedStatement ps = this.conSlave.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)this.stopMonth));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)this.startMonth));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                List<ServiceRange> list;
                int cid = rs.getInt(1);
                int sid = rs.getInt(2);
                Calendar date1 = TimeUtils.convertDateToCalendar((Date)rs.getDate(3));
                Calendar date2 = TimeUtils.convertDateToCalendar((Date)rs.getDate(4));
                if (date1 == null) {
                    date1 = this.startMonth;
                }
                if (date2 == null) {
                    date2 = this.stopMonth;
                }
                if (TimeUtils.dateBefore((Calendar)date1, (Calendar)this.startMonth)) {
                    date1 = this.startMonth;
                }
                if (TimeUtils.dateBefore((Calendar)this.stopMonth, (Calendar)date2)) {
                    date2 = this.stopMonth;
                }
                if ((list = this.serviceRanges.get(cid)) == null) {
                    list = new ArrayList<ServiceRange>(3);
                    this.serviceRanges.put(cid, list);
                }
                ServiceRange range = new ServiceRange();
                range.serviceId = sid;
                range.fromDate = date1;
                range.toDate = date2;
                range.days = TimeUtils.daysDelta((Calendar)range.fromDate, (Calendar)range.toDate) + 1;
                list.add(range);
            }
            ps.close();
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    private void adjustGateRules() throws SQLException {
        UserGateRuleManager manager = new UserGateRuleManager(this.con, this.moduleId);
        for (Map.Entry<Integer, Integer> entry : this.contactRuleMap.entrySet()) {
            int cid = entry.getKey();
            int ruleId = entry.getValue();
            List<UserGateRule> rules = manager.getUserGateRules(cid);
            for (UserGateRule rule : rules) {
                if (rule.getRuleTypeId() == ruleId) continue;
                rule.setRuleTypeId(ruleId);
                manager.updateUserGateRule(String.valueOf(rule.getId()), rule);
            }
        }
    }

    class ServiceRange {
        public int serviceId;
        public Calendar fromDate;
        public Calendar toDate;
        public int days;

        ServiceRange() {
        }
    }
}

