/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import bitel.billing.server.ActionConType;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.ipn.common.bean.AddressRange;
import ru.bitel.bgbilling.modules.ipn.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.ipn.server.bean.AddressRangeManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

@ActionConType(value=2)
public class ActionFindAddress
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int mid = this.getIntParameter("mid", -1);
        long addr = this.getLongParameter("addr", -1L);
        String ifaces = this.getParameter("ifaces");
        int sourceList = this.getIntParameter("list", 0);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        Page page = this.getPage();
        String comment = this.getParameter("comment");
        if (sourceList == 1) {
            String query = "SELECT id, title FROM source WHERE mid=" + mid + " AND ( isNull(date1) OR date1<=now() ) AND ( isNull(date2) OR date2>=now() ) ORDER BY title";
            this.buildList(this.rootNode, query);
        }
        ContractManager cm = new ContractManager(this.conSlave);
        AddressRangeManager arm = new AddressRangeManager(this.conSlave, mid);
        if (Utils.notBlankString((String)ifaces)) {
            List<AddressRange> addressList = arm.getAddressRangeListCidSort(new GregorianCalendar(), ifaces, page);
            for (AddressRange addressRange : addressList) {
                String[] source_iface = addressRange.getSources().split("%");
                Contract contract = cm.getContractById(addressRange.getContractId());
                Element element = this.createElement(data, "record");
                element.setAttribute("source", source_iface[0]);
                element.setAttribute("iface", source_iface[1]);
                element.setAttribute("cid", String.valueOf(addressRange.getContractId()));
                element.setAttribute("con_title", contract != null ? contract.getTitle() : " - ");
                element.setAttribute("con_comment", contract != null ? contract.getComment() : " - ");
                element.setAttribute("ip_range", this.diapazonIP(addressRange.getAddr1(), addressRange.getAddr2()));
                element.setAttribute("port_range", addressRange.getPort1() + " - " + addressRange.getPort2());
                element.setAttribute("period", TimeUtils.formatPeriod((Calendar)addressRange.getDate1(), (Calendar)addressRange.getDate2()));
                element.setAttribute("comment", addressRange.getComment());
            }
        } else if (addr > -1L || Utils.notBlankString((String)comment)) {
            int mask = this.getIntParameter("mask", -1);
            int port = this.getIntParameter("port", -1);
            Calendar date1 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date1", null));
            Calendar date2 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date2", null));
            List<AddressRange> addressList = arm.getAddressRangeList(addr, port, mask, date1, date2, comment, page);
            for (AddressRange ar : addressList) {
                String[] source_iface = ar.getSources().split("%");
                Element element = this.createElement(data, "record");
                Contract contract = cm.getContractById(ar.getContractId());
                element.setAttribute("source", source_iface[0]);
                element.setAttribute("iface", source_iface[1]);
                element.setAttribute("cid", String.valueOf(ar.getContractId()));
                element.setAttribute("con_title", contract != null ? contract.getTitle() : " - ");
                element.setAttribute("con_comment", contract != null ? contract.getComment() : " - ");
                element.setAttribute("ip_range", this.diapazonIP(ar.getAddr1(), ar.getAddr2()));
                element.setAttribute("port_range", ar.getPort1() + " - " + ar.getPort2());
                element.setAttribute("period", TimeUtils.formatPeriod((Calendar)ar.getDate1(), (Calendar)ar.getDate2()));
                element.setAttribute("comment", ar.getComment());
            }
        }
        table.setAttribute("recordCount", String.valueOf(page.getRecordCount()));
        table.setAttribute("pageCount", String.valueOf(page.getPageCount()));
        table.setAttribute("pageIndex", String.valueOf(page.getPageIndex()));
    }
}

