/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.system.CommonEvent;
import ru.bitel.bgbilling.modules.ipn.common.bean.AddressRange;
import ru.bitel.bgbilling.modules.ipn.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.ipn.server.bean.AddressRangeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.IPNResourceManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.Iface;
import ru.bitel.bgbilling.modules.ipn.server.bean.IfaceManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.RangeIface;
import ru.bitel.bgbilling.modules.ipn.server.bean.RangeIfaceManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.ServiceLink;
import ru.bitel.bgbilling.modules.ipn.server.bean.ServiceLinkManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.ServiceLinkPlan;
import ru.bitel.bgbilling.modules.ipn.server.bean.ServiceLinkPlanManager;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionUpdateContractAddress
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        String serviceLink;
        String id = this.getParameter("id");
        int cid = this.getIntParameter("cid", -1);
        String comment = this.getParameter("comment");
        int objectId = this.getIntParameter("object_id", 0);
        String ifaces = this.getParameter("ifaces");
        if (id == null || this.mid <= 0 || cid < 0 || comment == null || Utils.isBlankString((String)ifaces)) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
        int mask = this.getIntParameter("mask", -1);
        long addr1 = this.getLongParameter("addr1", -1L);
        long addr2 = this.getLongParameter("addr2", -1L);
        if (mask >= 0) {
            long[] range = IPUtils.netMaskToRange((long)addr1, (int)mask);
            addr1 = range[0];
            addr2 = range[1];
        }
        Date date1 = this.getDateParameter("date1");
        Date date2 = this.getDateParameter("date2");
        TimeUtils.checkPeriod((Date)date1, (Date)date2);
        AddressRangeManager manager = new AddressRangeManager(this.con, this.mid);
        ServiceLinkManager linkManager = new ServiceLinkManager(this.con, this.mid);
        ServiceLinkPlanManager planManager = new ServiceLinkPlanManager(this.con, this.mid);
        RangeIfaceManager rangeIfaceManager = new RangeIfaceManager(this.con, this.mid);
        IfaceManager ifaceManager = new IfaceManager(this.con, this.mid);
        HashSet<Integer> zones = new HashSet<Integer>();
        HashSet<Integer> oldZones = new HashSet<Integer>();
        AddressRange address = new AddressRange();
        AddressRange oldAddress = null;
        if (!id.equals("new")) {
            address = manager.getAddressRange(Utils.parseInt((String)id));
            oldAddress = manager.getAddressRange(Utils.parseInt((String)id));
            Set<RangeIface> rangeIfaceSet = rangeIfaceManager.getAdressRangeIfaces(oldAddress.getId());
            for (RangeIface rangeIface : rangeIfaceSet) {
                Iface iface = ifaceManager.getIface(rangeIface.getSourceId(), rangeIface.getIfaceId());
                if (iface == null) continue;
                oldZones.add(iface.getZoneId());
            }
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionUpdateContractAddress", (int)this.mid, (int)this.userId);
        if (closedDate != null) {
            Date olddate1 = null;
            Date olddate2 = null;
            if (oldAddress != null) {
                olddate1 = TimeUtils.convertCalendarToDate((Calendar)oldAddress.getDate1());
                olddate2 = TimeUtils.convertCalendarToDate((Calendar)oldAddress.getDate2());
            }
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Date)olddate1, olddate2, (Date)date1, (Date)date2);
        }
        address.setAddr1(addr1);
        address.setAddr2(addr2);
        address.setPort1(this.getIntParameter("port1", -1));
        address.setPort2(this.getIntParameter("port2", -1));
        address.setDate1(TimeUtils.convertDateToCalendar((Date)date1));
        address.setDate2(TimeUtils.convertDateToCalendar((Date)date2));
        address.setPlanId(this.getIntParameter("plan", 0));
        address.setMask(mask);
        String checkResult = address.checkAddressRange();
        if (checkResult != null) {
            throw new BGMessageException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432: " + checkResult);
        }
        List<RangeIface> ifaceList = this.getIfaces(id, address, ifaces);
        for (RangeIface rangeIface : ifaceList) {
            zones.add(rangeIface.getIface().getZoneId());
        }
        if (ifaceList.size() > 1 && zones.size() > 1) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u043e\u043d \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u043e\u0432");
        }
        int resourceId = 0;
        if (zones.contains(-3) || oldZones.contains(-3)) {
            try {
                IPNResourceManager rm = new IPNResourceManager(this.con, this.mid);
                resourceId = rm.resourceAnalize(oldAddress, address);
            }
            catch (BGException e) {
                throw new BGException(e.getMessage());
            }
        }
        if (oldAddress != null) {
            CommonEvent eventAction = new CommonEvent(cid, 0);
            eventAction.setParameter("rangeUpdated", (Object)"true");
            eventAction.setParameter("dateFrom", (Object)TimeUtils.convertCalendarToDate((Calendar)address.getDate1()));
            eventAction.setParameter("dateTo", (Object)TimeUtils.convertCalendarToDate((Calendar)address.getDate2()));
            eventAction.setParameter("mid", (Object)this.mid);
            eventAction.setParameter("rangeId", (Object)address.getId());
            EventProcessor.getInstance().request((QueueEvent)eventAction);
            if (eventAction.getParameter("updateRejected") != null) {
                throw new BGMessageException(" \u0418\u0437\u043c\u0435\u043d\u044f\u0435\u043c\u044b\u0439 \u0434\u0438\u043f\u0430\u0437\u043e\u043d  \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 ip, \u0434\u043b\u044f \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0435\u0441\u0442\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u0438\u043d\u0442\u044b  \u0432 \u043c\u043e\u0434\u0443\u043b\u0435 phone. ");
            }
        }
        if (Utils.notBlankString((String)(serviceLink = this.getParameter("service_link", ""))) && address.getPersonalPlanId() <= 0) {
            ServiceLinkPlan plan = new ServiceLinkPlan();
            plan.setTitle("PERSONAL");
            plan.setType(1);
            planManager.updatePlan(plan);
            address.setPersonalPlanId(plan.getId());
        }
        if (address.getPersonalPlanId() > 0) {
            ArrayList<ServiceLink> serviceLinkList = new ArrayList<ServiceLink>();
            StringTokenizer st = new StringTokenizer(serviceLink, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                ServiceLink link = new ServiceLink();
                link.loadFromString(token);
                serviceLinkList.add(link);
            }
            linkManager.updatePlanLinks(address.getPersonalPlanId(), serviceLinkList);
        }
        address.setComment(comment);
        address.setContractId(cid);
        address.setObjectId(objectId);
        address.setResourceId(resourceId);
        manager.updateAddressRangeInfo(id, address);
        rangeIfaceManager.updateAddressRangeIfaces(address.getId(), ifaceList);
    }
}

