/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client.editor.vlan;

import bitel.billing.module.common.ModTreeNode;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.ipn.client.editor.vlan.CiscoSwitchCommonRuleEditor;
import ru.bitel.bgbilling.modules.ipn.common.bean.CiscoRule;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class CiscoSSHSwitchRuleEditor
extends CiscoSwitchCommonRuleEditor {
    protected JTextArea ruleSwitch;
    private BGTable table;
    private CiscoRule ciscoRule = new CiscoRule("");

    @Override
    protected void addSwitchTabs(JTabbedPane tabbedPane) {
        this.addRuleTab(tabbedPane);
        this.addAssociatingTab(tabbedPane);
    }

    private void addRuleTab(JTabbedPane tabbedPane) {
        JPanel panel = new JPanel();
        panel.setBorder((Border)new BGTitleBorder(" \u041f\u0440\u0430\u0432\u0438\u043b\u043e "));
        panel.setLayout(new GridBagLayout());
        this.ruleSwitch = new JTextArea();
        JScrollPane scroll = new JScrollPane(this.ruleSwitch);
        panel.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.ruleSwitch.setEditable(false);
        this.ruleSwitch.setEnabled(false);
        tabbedPane.add((Component)panel, "Switch");
    }

    private void addAssociatingTab(JTabbedPane tabbedPane) {
        this.table = new BGTable();
        this.table.setHeader(this.rb_name, ClientUtils.getModuleDoc(((Object)((Object)this)).getClass()), "ip_port_mac");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JScrollPane scroll = new JScrollPane((Component)this.table);
        panel.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        tabbedPane.add((Component)panel, "\u041f\u0440\u0438\u0432\u044f\u0437\u043a\u0430");
    }

    @Override
    public void setData() {
        super.setData();
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("AddressContractInfo");
        req.setModuleId(this.getModuleId());
        req.setContractId(this.getContractId());
        req.setAttribute("date", new SimpleDateFormat("dd.MM.yyyy").format(new Date()));
        Document mainDoc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)mainDoc)) {
            HashMap<String, String> ipPort = new HashMap<String, String>();
            HashMap<String, String> ipMac = new HashMap<String, String>();
            StringTokenizer st = new StringTokenizer(this.ciscoRule.getPorts(), ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                int firstPos = token.indexOf(58);
                int secondPos = -1;
                if (firstPos > 0) {
                    secondPos = token.indexOf(58, firstPos + 1);
                }
                if (firstPos <= 0) continue;
                if (secondPos > 0) {
                    ipPort.put(token.substring(0, firstPos), token.substring(firstPos + 1, secondPos));
                    ipMac.put(token.substring(0, firstPos), token.substring(secondPos + 1));
                    continue;
                }
                ipPort.put(token.substring(0, firstPos), token.substring(firstPos + 1));
            }
            this.table.removeRows();
            for (Element row : XMLUtils.selectElements((Node)mainDoc.getDocumentElement(), (String)"/data/table/data/row")) {
                String addressRange = row.getAttribute("address_range");
                String comment = row.getAttribute("comment");
                String[] addresses = addressRange.split("\\s+\\-\\s+");
                if (addresses.length != 2) continue;
                long address1 = IPUtils.convertStringIPtoLong((String)addresses[0].trim(), (long)0L);
                long address2 = IPUtils.convertStringIPtoLong((String)addresses[1].trim(), (long)0L);
                if (addresses[0].trim().equals("0.0.0.0") || addresses[1].trim().equals("255.255.255.255")) continue;
                ModTreeNode rangeNode = new ModTreeNode();
                rangeNode.setAttribute("id", (Object)"0");
                rangeNode.setEn(true);
                rangeNode.setText(addressRange + " [" + comment + "]");
                rangeNode.setIcon("closed");
                if (address2 - address1 > 200L) {
                    address2 = address1 + 200L;
                }
                for (long address = address1; address <= address2; ++address) {
                    String addressString = IPUtils.convertLongIpToString((long)address);
                    Vector<String> rowData = new Vector<String>();
                    rowData.add(addressString);
                    rowData.add(addressString);
                    if (ipPort.get(addressString) != null) {
                        rowData.add((String)ipPort.get(addressString));
                    }
                    if (ipMac.get(addressString) != null) {
                        rowData.add((String)ipMac.get(addressString));
                    }
                    this.table.addRow(rowData);
                }
            }
        }
        this.updateCommands();
    }

    @Override
    protected void updateCommands() {
        super.updateCommands();
        String ruleType = ClientUtils.getIdFromComboBox((JComboBox)this.ruleType_CB);
        if (ruleType != null && !ruleType.equals("0")) {
            this.updateCommandText("CiscoSSHSwitchGenerateRule", this.ruleSwitch, ruleType, this.gateTypeId, this.ruleData);
        }
    }

    @Override
    protected void stopEdit(boolean save) {
        String ruleType = ClientUtils.getIdFromComboBox((JComboBox)this.ruleType_CB);
        if (save) {
            String info = this.getIpInfo();
            if (info == null) {
                return;
            }
            Request req = new Request();
            req.setModule(this.module);
            req.setAction("UpdateContractRule");
            req.setModuleId(this.getModuleId());
            req.setAttribute("id", this.id);
            req.setContractId(this.getContractId());
            req.setAttribute("fwid", this.gateId);
            req.setAttribute("rtid", ruleType);
            req.setAttribute("rule", info.toString());
            if (ClientUtils.checkStatus((Document)this.getDocument(req))) {
                super.stopEdit(save);
            }
        } else {
            super.stopEdit(save);
        }
    }

    private String getIpInfo() {
        StringBuilder rule = new StringBuilder();
        int size = this.table.getRowCount();
        for (int i = 0; i < size; ++i) {
            String addr = (String)this.table.getValueAt(i, 1);
            String port = (String)this.table.getValueAt(i, 2);
            String mac = (String)this.table.getValueAt(i, 3);
            if (!Utils.isEmptyString((String)mac)) {
                mac = mac.trim();
                if (!Utils.checkMacAddres((String)(mac = mac.replace(':', '-')))) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 MAC \u0430\u0434\u0440\u0435\u0441");
                    return null;
                }
            }
            if (!Utils.notBlankString((String)port) || Utils.parseInt((String)port) <= 0) continue;
            port = port.trim();
            if (rule.length() > 0) {
                rule.append(";");
            }
            rule.append(addr);
            if (!Utils.isEmptyString((String)port)) {
                rule.append(":");
                rule.append(port);
            }
            if (Utils.isEmptyString((String)mac)) continue;
            rule.append(":");
            rule.append(mac);
        }
        rule.append("#" + this.treeScroll.getRule());
        return rule.toString();
    }

    @Override
    protected String getIPs(String data) {
        return this.ciscoRule != null ? this.ciscoRule.getAddresses() : "";
    }

    @Override
    protected void setRuleData(String ruleData) {
        super.setRuleData(ruleData);
        this.ciscoRule = new CiscoRule(ruleData);
    }

    @Override
    protected void addGenerateParams(Request req) {
        req.setAttribute("gid", this.gateId);
    }
}

