/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.service;

import bitel.billing.common.SummaToString;
import bitel.billing.server.contract.bean.ContractManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.license.common.bean.AdditionalAgreement;
import ru.bitel.bgbilling.modules.license.common.bean.Component;
import ru.bitel.bgbilling.modules.license.common.bean.ConfirmedOrder;
import ru.bitel.bgbilling.modules.license.common.bean.Copy;
import ru.bitel.bgbilling.modules.license.common.bean.NewPermanentOrder;
import ru.bitel.bgbilling.modules.license.common.bean.Order;
import ru.bitel.bgbilling.modules.license.common.bean.OrderType;
import ru.bitel.bgbilling.modules.license.common.bean.SpecificationTitle;
import ru.bitel.bgbilling.modules.license.common.service.AdditionalAgreementService;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.bgbilling.modules.license.common.service.OrderService;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;
import ru.bitel.bgbilling.modules.license.server.event.AddAdditionalAgreementEvent;
import ru.bitel.bgbilling.modules.license.server.event.RemoveAdditionalAgreementEvent;
import ru.bitel.bgbilling.modules.license.server.event.SignAdditionalAgreementEvent;
import ru.bitel.bgbilling.modules.license.server.utils.LicenseUtils;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentPattern;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentTable;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentTableExtractMethod;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsPatternService;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsService;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocumentsPatternGenerator;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.license.common.service.AdditionalAgreementService")
public class AdditionalAgreementServiceImpl
extends AbstractService
implements AdditionalAgreementService {
    LicenseManager manager;
    @Resource
    OrderService orderService;
    @Resource
    LicenseService licenseService;

    @PostConstruct
    void init() {
        this.manager = new LicenseManager(this.getConnection(), this.moduleId);
    }

    public List<AdditionalAgreement> additionalAgreements(int contractId, int copyId) throws BGException {
        List<AdditionalAgreement> list = this.manager.getListAdditionalAgreement(contractId, copyId);
        Comparator<SpecificationTitle> comparer = new Comparator<SpecificationTitle>(){

            @Override
            public int compare(SpecificationTitle arg0, SpecificationTitle arg1) {
                String first = arg0.getName();
                String second = arg1.getName();
                return first.compareTo(second);
            }
        };
        for (AdditionalAgreement agreement : list) {
            List specificationList = agreement.getSpecification();
            Collections.sort(specificationList, comparer);
        }
        return list;
    }

    public void additionalAgreementCreate(int contractId, AdditionalAgreement additionalAgreement, int typeDocument) throws BGException {
        int typeId;
        int journalId;
        String idPattern;
        AddAdditionalAgreementEvent event = new AddAdditionalAgreementEvent(this.moduleId, contractId, this.userId, additionalAgreement);
        event.setAttribute("module.bill.id", String.valueOf(this.getModuleSetup().getInt("module.bill.id", 0)));
        EventProcessor.getInstance().request((QueueEvent)event);
        if (typeDocument == -1) {
            idPattern = this.getModuleSetup().get("license.newDocument.pattern.id", "1");
            journalId = Utils.parseInt((String)this.getModuleSetup().get("license.newDocument.journal.id", "-1"), (int)-1);
            typeId = Utils.parseInt((String)this.getModuleSetup().get("license.newDocument.type.id", "-1"), (int)-1);
        } else {
            journalId = Utils.parseInt((String)this.getModuleSetup().get("license.document.journal.id", "-1"), (int)-1);
            typeId = Utils.parseInt((String)this.getModuleSetup().get("license.document.type.id", "-1"), (int)-1);
            idPattern = this.getModuleSetup().get("license.document.idDefault", "1");
            SortedMap map = this.getModuleSetup().subIndexed("license.document.");
            long group = 0L;
            try (ContractManager contractManager = new ContractManager(this.getConnection());){
                group = contractManager.getContractById(contractId).getGroups();
            }
            for (Map.Entry entry : map.entrySet()) {
                int value = ((ParameterMap)entry.getValue()).getInt("group", 0);
                if ((group & (long)(1 << value)) <= 0L) continue;
                ((ParameterMap)entry.getValue()).getInt("id", 0);
                idPattern = String.valueOf(((ParameterMap)entry.getValue()).getInt("id", 0));
                break;
            }
        }
        if (typeId == -1 || journalId == -1) {
            throw new BGMessageException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043a\u043e\u0434 \u0442\u0438\u043f\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0438\u043b\u0438/\u0438 \u043a\u043e\u0434 \u0436\u0443\u0440\u043d\u0430\u043b\u0430!");
        }
        Document result = null;
        DocumentPattern pattern = ((DocumentsPatternService)this.context.newService(DocumentsPatternService.class, 0)).getPattern(Utils.parseInt((String)idPattern));
        if (pattern == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430.");
        }
        DocumentTable table = new DocumentTable();
        table.setIdentifier("components");
        table.setExtractMethod(DocumentTableExtractMethod.NONE);
        pattern.addTable(table);
        Object nameFile = typeDocument == 0 ? "\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0435 \u2116" + additionalAgreement.getAgreementNumber() : pattern.getDocumentName();
        pattern.setDocumentName((String)nameFile);
        pattern.setDocumentComment("");
        pattern.setGeneratedFileNamePattern((String)nameFile);
        DocumentsPatternGenerator documentsPatternGenerator = new DocumentsPatternGenerator(this.getConnection(), pattern, contractId, typeId, journalId, this.userId);
        ArrayList tableData = new ArrayList();
        int i = 1;
        for (SpecificationTitle specification : additionalAgreement.getSpecification()) {
            HashMap<String, String> currentRow = new HashMap<String, String>(additionalAgreement.getSpecification().size());
            currentRow.put("col1", String.valueOf(i));
            String itemTitle = specification.getName().toUpperCase();
            if (itemTitle.contains(".")) {
                itemTitle = itemTitle.substring(itemTitle.lastIndexOf(".") + 1);
            }
            currentRow.put("col2", itemTitle);
            currentRow.put("col3", specification.getCount() == 0 ? "\u043d\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e" : Utils.formatCostByGrouping((BigDecimal)new BigDecimal(specification.getCount()), (int)3, (int)0));
            tableData.add(currentRow);
            ++i;
        }
        documentsPatternGenerator.setTableData("components", tableData);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("NUMBER_DOC", Integer.toString(additionalAgreement.getAgreementNumber()));
        map.put("SUM", Utils.formatCostByGrouping((BigDecimal)additionalAgreement.getSum(), (int)-1, (int)2).replace(' ', '\u00a0'));
        map.put("SUMSTRING", SummaToString.summaToString((String)Utils.formatCost((BigDecimal)additionalAgreement.getSum()), (boolean)false, (boolean)true));
        map.put("CPARAM_7", this.getEmailForDocument(contractId, 20));
        result = documentsPatternGenerator.generateDocument(map);
        if (result == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430.");
        }
        documentsPatternGenerator.recycle();
        additionalAgreement.setDocumentId(result.getId());
        this.manager.setAdditionalAgreement(contractId, additionalAgreement);
    }

    public void additionalAgreementUpdate(int contractId, AdditionalAgreement additionalAgreement) throws BGException, BGMessageException {
        if (additionalAgreement == null) {
            throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442.");
        }
        this.manager.updateAdditionalAgreement(contractId, additionalAgreement);
    }

    public void additionalAgreementDelete(int contractId, AdditionalAgreement additionalAgreement) throws BGException, BGMessageException {
        if (additionalAgreement == null) {
            throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0443\u0434\u0430\u043b\u044f\u0435\u043c\u044b\u0439 \u0434\u043e\u043f\u0438\u043a.");
        }
        AdditionalAgreement deleteAgreement = this.manager.getAdditionalAgreement(additionalAgreement.getId());
        if (deleteAgreement != null && deleteAgreement.getStatus() == 0) {
            if (!this.getStatusSigned(additionalAgreement.getId())) {
                RemoveAdditionalAgreementEvent event = new RemoveAdditionalAgreementEvent(this.moduleId, contractId, this.userId, additionalAgreement);
                event.setAttribute("module.bill.id", String.valueOf(this.getModuleSetup().getInt("module.bill.id", 0)));
                EventProcessor.getInstance().request((QueueEvent)event);
                DocumentsService docService = (DocumentsService)this.context.newService(DocumentsService.class, 0);
                docService.deleteDocument(Arrays.asList(additionalAgreement.getDocumentId()));
                this.manager.deleteAdditionalAgreement(additionalAgreement.getId());
                if (this.manager.getLastNumber(contractId) == 0) {
                    this.manager.resetCopyDiscount(contractId, additionalAgreement.getCopyId());
                }
            }
        } else {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u0445 \u0434\u043e\u043f. \u0441\u043e\u0433\u043b. \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e.");
        }
    }

    public List<SpecificationTitle> specificationTitles(int id) throws BGException {
        return this.manager.getSpecificationOfAdditionalAgreement(id);
    }

    public List<Order> permanentOrders(int copyId, boolean onlyPerformed) throws BGException {
        if (onlyPerformed) {
            return this.manager.getOrders(copyId, "2", null, -1);
        }
        return this.manager.getOrders(copyId, "0,2", null, -1);
    }

    public BigDecimal costComponents(int copyId, List<SpecificationTitle> specificationList) throws BGException {
        ArrayList<ConfirmedOrder> packageItems = new ArrayList<ConfirmedOrder>();
        for (SpecificationTitle specificationTitle : specificationList) {
            ConfirmedOrder order = new ConfirmedOrder();
            order.setComponentName(specificationTitle.getName());
            order.setCount(specificationTitle.getCount());
            packageItems.add(order);
        }
        Copy copy = this.manager.getCopy(copyId);
        String productVersion = copy.getProductVersion();
        Map<String, BigDecimal> costMap = LicenseUtils.getCosts(LicenseUtils.buildLicenseCostUrlRequest(packageItems, productVersion, (ParameterMap)Setup.getSetup()));
        BigDecimal cost = BigDecimal.ZERO;
        for (Map.Entry<String, BigDecimal> entry : costMap.entrySet()) {
            cost = cost.add(entry.getValue());
        }
        return cost;
    }

    public int lastNumber(int contractId) throws BGException {
        return this.manager.getLastNumber(contractId);
    }

    public BigDecimal discountGet(int contractId, int copyId) throws BGException {
        return this.manager.getDiscount(contractId, copyId);
    }

    public void discountSet(int contractId, int copyId, BigDecimal discount) throws BGException {
        this.manager.setDiscount(discount, contractId, copyId);
    }

    public void statusSignedSet(int contractId, int copyId, AdditionalAgreement additionalAgreement) throws BGException {
        if (!this.getStatusSigned(additionalAgreement.getId())) {
            SignAdditionalAgreementEvent event = new SignAdditionalAgreementEvent(this.moduleId, contractId, this.userId, additionalAgreement);
            event.setAttribute("module.bill.id", String.valueOf(this.getModuleSetup().getInt("module.bill.id", 0)));
            event.setAttribute("license.charge.type.id", String.valueOf(this.getModuleSetup().getInt("license.charge.type.id", 0)));
            EventProcessor.getInstance().request((QueueEvent)event);
            this.manager.setCharge(additionalAgreement.getId(), additionalAgreement.getChargeId());
            this.manager.setInvoice(additionalAgreement.getId(), additionalAgreement.getInvoiceId());
            this.manager.setStatusSigned(additionalAgreement.getId());
            List<AdditionalAgreement> list = this.additionalAgreements(contractId, copyId);
            boolean flag = true;
            List<Order> orderList = this.manager.getOrders(copyId, "0", null, -1);
            if (list.size() > 1) {
                int indexPrevious = list.indexOf(additionalAgreement) - 1;
                HashMap<String, Integer> previousMap = this.listToMap(list.get(indexPrevious).getSpecification());
                HashMap<String, Integer> difference = new HashMap<String, Integer>();
                for (SpecificationTitle specification : additionalAgreement.getSpecification()) {
                    if (specification.getCount() == 0) {
                        if (previousMap.get(specification.getName()) != null && previousMap.get(specification.getName()) == 0) continue;
                        difference.put(specification.getName(), 0);
                        continue;
                    }
                    int dif = specification.getCount() - (previousMap.get(specification.getName()) == null ? 0 : previousMap.get(specification.getName()));
                    if (dif <= 0) continue;
                    difference.put(specification.getName(), dif);
                }
                if (orderList.size() != difference.size()) {
                    flag = false;
                }
                for (Order order : orderList) {
                    if (difference.get(order.getComponentName()) != null && order.getCount() == ((Integer)difference.get(order.getComponentName())).intValue() && additionalAgreement.getDate().compareTo(order.getCreateDate()) > 0) continue;
                    flag = false;
                    break;
                }
                if (flag) {
                    for (Order order : orderList) {
                        if (order.getType() != OrderType.BUY || order.getStatus() != 0) continue;
                        order.setStatus(2);
                        this.licenseService.orderUpdate(order);
                    }
                }
            } else {
                HashMap<String, Integer> now = this.listToMap(additionalAgreement.getSpecification());
                for (Order order : orderList) {
                    if (order.getType() == OrderType.BUY && order.getStatus() == 0 && now.get(order.getComponentName()) != null && now.get(order.getComponentName()).intValue() == order.getCount()) {
                        order.setStatus(2);
                        this.licenseService.orderUpdate(order);
                        continue;
                    }
                    flag = false;
                }
            }
            if (!flag) {
                throw new BGMessageException("\u041d\u0435 \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u043e\u0441\u044c \u0432\u044b\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0443 \u0437\u0430\u043a\u0430\u0437\u043e\u0432 \u0441\u0442\u0430\u0442\u0443\u0441 \"\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\".\n\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u044d\u0442\u043e \u0432\u0440\u0443\u0447\u043d\u0443\u044e. \u0414\u043b\u044f \u0442\u043e\u0433\u043e \u0447\u0442\u043e\u0431\u044b \u0437\u0430\u043a\u0430\u0437\u044b \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u043b\u0438\u0441\u044c\n\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u043e\u043c \u043f\u0440\u0438\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0439\u0442\u0435\u0441\u044c \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u0441\u043e\u0432\u0435\u0442\u043e\u0432:\n\u043d\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0439\u0442\u0435 \u043d\u043e\u0432\u044b\u0445 \u0437\u0430\u043a\u0430\u0437\u043e\u0432 \u0434\u043e \u043c\u043e\u043c\u0435\u043d\u0442\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e \u0434\u043e\u043f.\u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u044f,\n\u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u044f\u0439\u0442\u0435 \u043a\u043e\u043b-\u0432\u043e \u0437\u0430\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432.");
            }
        }
    }

    public BigDecimal prospectiveDiscount(int copyId) throws BGException {
        List<Order> listOrder = this.manager.getOrders(copyId, "2", null, -1);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ArrayList<SpecificationTitle> specificationList = new ArrayList<SpecificationTitle>();
        Collections.reverse(listOrder);
        for (Order order : listOrder) {
            String componentName = order.getComponentName();
            if (map.containsKey(componentName)) {
                if (order.getCount() == 0) {
                    map.put(componentName, 0);
                    continue;
                }
                if ((Integer)map.get(componentName) == 0) {
                    return null;
                }
                map.put(componentName, order.getCount() + (Integer)map.get(componentName));
                continue;
            }
            map.put(order.getComponentName(), order.getCount());
        }
        for (Map.Entry entry : map.entrySet()) {
            specificationList.add(new SpecificationTitle(((Integer)entry.getValue()).intValue(), (String)entry.getKey()));
        }
        return this.costComponents(copyId, specificationList);
    }

    public AdditionalAgreement toReplaceSpecification(AdditionalAgreement agreement, int oldCopyId) throws BGException {
        this.manager = new LicenseManager(this.getConnection(), this.moduleId);
        Component ipn = this.manager.getComponent(this.getModuleSetup().getInt("license.component.ipn.id", -1));
        Component dialup = this.manager.getComponent(this.getModuleSetup().getInt("license.component.dialup.id", -1));
        Component inet = this.manager.getComponent(this.getModuleSetup().getInt("license.component.inet.id", -1));
        if (ipn == null || dialup == null || inet == null) {
            throw new BGMessageException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u0438\u0434 ipn \u0438\u043b\u0438/\u0438 dialup \u0438\u043b\u0438/\u0438 inet( \u041f\u0440\u0438\u043c\u0435\u0440 - \"license.component.ipn.id=34\" ) \u0438\u043b\u0438 \u043d\u0435\u0432\u0435\u0440\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0430\u043d\u044b. \u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u043a\u0430\u0437\u043e\u0432 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e!");
        }
        List list = agreement.getSpecification();
        agreement.setSum(this.costComponents(oldCopyId, list));
        if (list.contains(inet)) {
            list.remove(dialup);
            list.remove(ipn);
        } else {
            ArrayList<SpecificationTitle> costList = new ArrayList<SpecificationTitle>();
            if (list.contains(ipn)) {
                costList.add((SpecificationTitle)list.get(list.lastIndexOf(ipn)));
            }
            if (list.contains(dialup)) {
                costList.add((SpecificationTitle)list.get(list.lastIndexOf(dialup)));
            }
            list.remove(dialup);
            list.remove(ipn);
            BigDecimal sumRemovedComponents = this.costComponents(oldCopyId, costList);
            if (sumRemovedComponents.compareTo(BigDecimal.ZERO) == 1) {
                int inetCount = this.getInetCount(sumRemovedComponents);
                list.add(new SpecificationTitle(inetCount, inet.getName()));
                NewPermanentOrder order = new NewPermanentOrder(inet.getId(), inet.getName(), 0, BigDecimal.ZERO, inetCount == -1, oldCopyId);
                order.setTotalCount(Integer.valueOf(inetCount));
                order.setTotalSum(sumRemovedComponents);
                order.setStatus(2);
                order.setCount(inetCount);
                this.manager.updateCopyItemOrder((Order)order);
            }
        }
        return agreement;
    }

    private boolean getStatusSigned(int id) throws BGException {
        return this.manager.getAdditionalAgreement(id).getStatus() == 1;
    }

    private HashMap<String, Integer> listToMap(List<SpecificationTitle> list) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (SpecificationTitle specification : list) {
            map.put(specification.getName(), specification.getCount());
        }
        return map;
    }

    private int getInetCount(BigDecimal sum) throws BGException {
        try {
            byte[] bytes = Utils.readByBlock((InputStream)new URL("http://www.bgbilling.ru/inet5.txt").openConnection().getInputStream());
            String text = new String(bytes);
            ArrayList<Double> counts = new ArrayList<Double>();
            ArrayList<Double> sums = new ArrayList<Double>();
            for (String line : text.split("\n")) {
                String[] mas = line.split(" +");
                if (mas.length < 2) continue;
                Double countSide = Utils.parseDouble((String)mas[0], (double)-1.0);
                Double sumSide = Utils.parseDouble((String)mas[1], (double)-1.0);
                if (mas[0].lastIndexOf("unlimited") != -1) {
                    countSide = 0.0;
                }
                if (!(countSide > -1.0) || !(sumSide > 0.0)) continue;
                counts.add(countSide);
                sums.add(sumSide);
            }
            Double bottomSum = 1.0;
            Double bottomCount = 0.0;
            Double topSum = (Double)sums.get(sums.size() - 1);
            Double topCount = 0.0;
            boolean flag = true;
            for (int j = sums.size() - 1; j > -1; --j) {
                if ((Double)sums.get(j) > (double)sum.intValue()) {
                    topSum = (Double)sums.get(j);
                    continue;
                }
                if (!flag) continue;
                bottomSum = (Double)sums.get(j);
                flag = false;
            }
            if (bottomSum > 0.0) {
                bottomCount = (Double)counts.get(sums.lastIndexOf(bottomSum));
            }
            topCount = (Double)counts.get(sums.lastIndexOf(topSum));
            Double count = (sum.doubleValue() - bottomSum) * (topCount - bottomCount) / (topSum - bottomSum) + bottomCount;
            if (count > (double)count.intValue()) {
                count = count + 1.0;
            }
            return count.intValue();
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
    }

    private String getEmailForDocument(int contractId, int parameterId) throws BGException {
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            String string = contractDao.optContractParameterEmailAsString(contractId, parameterId).orElse("");
            return string;
        }
    }
}

