/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mangooffice.server.task;

import au.com.bytecode.opencsv.CSVReader;
import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.bean.PeriodicErrorManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoAccount;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoFee;
import ru.bitel.bgbilling.modules.mangooffice.server.bean.MangoAccountDao;
import ru.bitel.bgbilling.modules.mangooffice.server.bean.MangoFeeDao;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class MangoFeesFtpLoader
extends TaskBase {
    private static final Logger log = LogManager.getLogger();
    Map<String, MangoAccount> accountMap = new HashMap<String, MangoAccount>();

    protected boolean initTask() {
        return true;
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Mango Office. \u0417\u0430\u0434\u0430\u0447\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043e\u043a \u0441 FTP Mango. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
        int defaultServiceId = moduleSetup.getInt("defaultService", -1);
        if (defaultServiceId < 1) {
            log.error("The parameter \"def\u0430ultService\" in the module configuration is not set");
            return;
        }
        Set setServiceId = Utils.getIdSet((Collection)ModuleCache.getInstance().getModuleServicesList(this.moduleId));
        if (!setServiceId.contains(defaultServiceId)) {
            log.error("The parameter \"def\u0430ultService\" in the module configuration is not correct.");
            return;
        }
        Calendar day = (Calendar)this.getOperatingTime().clone();
        day.add(6, -1);
        int dayMonth = day.get(5);
        log.debug("Processing date - " + TimeUtils.formatDate((Calendar)day));
        String sids = ModuleCache.getInstance().getModuleServicesString(this.moduleId);
        Connection con = this.setup.getDBConnectionFromPool();
        PeriodicErrorManager errorManager = new PeriodicErrorManager(con);
        errorManager.initErrorMessage(this.moduleId, "Mango", String.valueOf(this.moduleId), day.getTime());
        try (MangoFeeDao mangoFeeDao = new MangoFeeDao(con, this.moduleId, day.getTime());
             MangoAccountDao accountDao = new MangoAccountDao(con, this.moduleId);
             BalanceUtils bu = new BalanceUtils(con);){
            List<MangoFee> listFee = this.getFees(moduleSetup, day, dayMonth);
            if (listFee != null) {
                mangoFeeDao.checkAndCreateTable(this.setup);
                mangoFeeDao.deleteByDay(dayMonth);
                mangoFeeDao.insertList(listFee);
                ServiceCostCache costCache = new ServiceCostCache();
                for (MangoFee fee : mangoFeeDao.aggregatedByService()) {
                    int cid = this.getCidByControl(accountDao, fee.getControl());
                    if (cid < 1) {
                        String errorText = "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0434\u043b\u044f control=" + fee.getControl();
                        log.error(errorText);
                        if (errorManager.isCapReached()) continue;
                        errorManager.addErrorToList("\u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0438", errorText);
                        continue;
                    }
                    costCache.addAmount(new CostSum(cid, defaultServiceId, fee.getSum()));
                }
                bu.setAccount(con, log, day, costCache, sids, null, null);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), day.getTime());
            errorManager.processErrors();
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private int getCidByControl(MangoAccountDao accountDao, String control) throws BGException {
        MangoAccount account = this.accountMap.get(control);
        if (account == null) {
            account = accountDao.getByControl(control);
            if (account == null) {
                return -1;
            }
            this.accountMap.put(account.getControl(), account);
        }
        return account.getContractId();
    }

    private List<MangoFee> getFees(ModuleSetup moduleSetup, Calendar day, int dayMonth) throws Exception {
        ArrayList<MangoFee> listFee;
        block34: {
            String ftpIp = moduleSetup.get("ftpIP", null);
            String loginFtp = moduleSetup.get("ftpLogin", null);
            String pwdFtp = moduleSetup.get("ftpPassword", null);
            String prvKeyPath = moduleSetup.get("ftpSshPathKey", null);
            String fileName = this.getFileName(day, moduleSetup.get("ftpFileNameFormat", null));
            if (Utils.isBlankString((String)ftpIp)) {
                throw new BGException("Ftp ip don't set");
            }
            if (Utils.isBlankString((String)loginFtp)) {
                throw new BGException("Ftp login don't set");
            }
            listFee = null;
            JSch jsch = new JSch();
            Session session = null;
            Channel channel = null;
            ChannelSftp channelSftp = null;
            try {
                if (Utils.notBlankString((String)prvKeyPath)) {
                    jsch.addIdentity(prvKeyPath);
                }
                session = jsch.getSession(loginFtp, ftpIp);
                session.setPassword(pwdFtp);
                Properties config = new Properties();
                config.put("StrictHostKeyChecking", "no");
                session.setConfig(config);
                session.connect(5000);
                channel = session.openChannel("sftp");
                channel.connect();
                channelSftp = (ChannelSftp)channel;
                String ftpPath = this.getTaskSetup().get("ftpPath", moduleSetup.get("ftpPath", "./"));
                String filePath = ftpPath + fileName;
                log.debug("Processing: " + filePath);
                boolean firstString = true;
                BigDecimal defSum = BigDecimal.valueOf(-1L);
                try (InputStream stream = channelSftp.get(filePath);
                     CSVReader reader = new CSVReader((Reader)new InputStreamReader(stream), ';');){
                    Object[] line;
                    listFee = new ArrayList<MangoFee>();
                    while ((line = reader.readNext()) != null) {
                        if (firstString) {
                            firstString = false;
                            continue;
                        }
                        if (line.length != 7) {
                            log.error("Line length don't correct");
                            continue;
                        }
                        String control = line[0];
                        int productId = Utils.parseInt((String)line[1], (int)-1);
                        int serviceId = Utils.parseInt((String)line[3], (int)-1);
                        Date date = TimeUtils.parseDate((String)line[4], (String)"dd.MM.yyyy HH:mm");
                        if (date == null) {
                            date = TimeUtils.convertCalendarToDate((Calendar)day);
                        }
                        BigDecimal sum = Utils.parseBigDecimal((String)line[5], (BigDecimal)defSum);
                        int id = Utils.parseInt((String)line[6], (int)-1);
                        if (Utils.isBlankString((String)control) || productId < 1 || serviceId < 1 || sum.compareTo(BigDecimal.ZERO) < 0 || id < 1) {
                            log.error("Don't correct data in row = " + Utils.toString((Object[])line, (String)";"));
                            continue;
                        }
                        MangoFee fee = new MangoFee();
                        fee.setId(id);
                        fee.setControl(control);
                        fee.setProductId(productId);
                        fee.setServiceId(serviceId);
                        fee.setDate(date);
                        fee.setSum(sum);
                        fee.setDay(dayMonth);
                        listFee.add(fee);
                    }
                }
                catch (SftpException e) {
                    if (e.id == 2) {
                        log.debug("File don't exist: " + filePath);
                        break block34;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                log.error("Unable to connect to FTP server. " + e.toString());
                throw e;
            }
            finally {
                try {
                    if (channelSftp != null) {
                        channelSftp.quit();
                    }
                    if (channel != null) {
                        channel.disconnect();
                    }
                    if (session != null) {
                        session.disconnect();
                    }
                }
                catch (Exception exc) {
                    log.error("Unable to disconnect from FTP server. " + exc.toString());
                }
            }
        }
        return listFee;
    }

    private String getFileName(Calendar day, String format) throws BGException {
        int index;
        if (Utils.isBlankString((String)format)) {
            format = "fees_$date.csv";
        }
        if ((index = format.indexOf("$date")) < 0) {
            throw new BGException("Incorrent file format");
        }
        String dayStr = TimeUtils.format((Calendar)day, (String)"yyyy-MM-dd");
        return format.substring(0, index) + dayStr + format.substring(index + 5);
    }
}

